/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.extractInclude;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.lang.ExtractIncludeFileBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractJspIncludeFileHandler
extends ExtractIncludeFileBase<XmlTagChild>
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.jsp.extractInclude.ExtractIncludeFileHandler");
    @NonNls
    private static final String JSPX_ROOT_TEXT = "<{0}:root version=\"2.0\">\n{1}\n</{0}:root>";

    public ExtractJspIncludeFileHandler() {
    }

    public ExtractJspIncludeFileHandler(PsiFile file) {
        this.myIncludingFile = file;
    }

    @NotNull
    protected String doExtract(PsiDirectory targetDirectory, String targetfileName, XmlTagChild first, XmlTagChild last, Language includingLanguage) throws IncorrectOperationException {
        PsiElement parent = first.getParent();
        Project project = parent.getProject();
        PsiFile including = first.getContainingFile();
        String newFileText = including.getText().substring(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
        if (includingLanguage.equals(StdFileTypes.JSPX.getLanguage())) {
            newFileText = ExtractJspIncludeFileHandler.getNewFileText(first, last, newFileText);
        }
        PsiFile extracted = targetDirectory.createFile(targetfileName);
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(extracted);
        if (doc == null) {
            throw new IncorrectOperationException("Cannot find document for " + extracted);
        }
        doc.replaceString(0, doc.getTextLength(), (CharSequence)newFileText);
        PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
        CodeStyleManager.getInstance((Project)extracted.getProject()).adjustLineIndent(extracted, extracted.getTextRange());
        String path = ExtractJspIncludeFileHandler.getWebPath(including.getContainingDirectory(), targetDirectory);
        String string = path.length() > 0 ? path + "/" + targetfileName : targetfileName;
        if (string == null) {
            ExtractJspIncludeFileHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getNewFileText(XmlTagChild first, XmlTagChild last, String newFileText) {
        XmlTag parentTag = ExtractJspIncludeFileHandler.getParentTag(first);
        Set<String> namespaces = ExtractJspIncludeFileHandler.getUsedNamespaces(first, last);
        namespaces.add("http://java.sun.com/JSP/Page");
        String jspPrefix = parentTag.getPrefixByNamespace("http://java.sun.com/JSP/Page");
        if (jspPrefix == null) {
            jspPrefix = "jsp";
        }
        String rootText = MessageFormat.format(JSPX_ROOT_TEXT, jspPrefix, newFileText);
        XmlTag rootTag = XmlElementFactory.getInstance((Project)first.getProject()).createTagFromText((CharSequence)rootText);
        for (String namespace : namespaces) {
            String prefix = parentTag.getPrefixByNamespace(namespace);
            String attrName = prefix == null ? "xmlns" : "xmlns:" + prefix;
            rootTag.setAttribute(attrName, namespace);
        }
        newFileText = rootTag.getText();
        return newFileText;
    }

    public static Set<String> getUsedNamespaces(XmlTagChild first, XmlTagChild last) {
        final LinkedHashSet<String> set = new LinkedHashSet<String>();
        XmlRecursiveElementVisitor visitor = new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                set.add(tag.getNamespace());
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                set.add(attribute.getNamespace());
            }
        };
        for (XmlTagChild child = first; child != null; child = child.getNextSiblingInTag()) {
            if (child instanceof XmlTag) {
                visitor.visitXmlTag((XmlTag)child);
            }
            if (child == last) break;
        }
        visitor.visitXmlElement((XmlElement)first);
        return set;
    }

    public static XmlTag getParentTag(XmlTagChild tagChild) {
        XmlTag parentTag = tagChild.getParentTag();
        if (parentTag != null) {
            return parentTag;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tagChild, XmlTag.class, (boolean)false);
    }

    protected boolean verifyChildRange(XmlTagChild first, XmlTagChild last) {
        return true;
    }

    @NotNull
    protected Language getLanguageForExtract(PsiElement firstExtracted) {
        Language language = this.myIncludingFile.getLanguage();
        if (language == null) {
            ExtractJspIncludeFileHandler.$$$reportNull$$$0(1);
        }
        return language;
    }

    @NonNls
    protected String getExtractExtension(FileType includeFileType, XmlTagChild first) {
        return "jspf";
    }

    protected void doReplaceRange(final String includePath, final XmlTagChild first, final XmlTagChild last) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                BaseJspFile file = BaseJspUtil.getJspFile((PsiElement)first.getContainingFile());
                int startOffset = first.getTextRange().getStartOffset();
                int endOffset = last.getTextRange().getEndOffset();
                PsiElement firstInJsp = file.getDocument().findElementAt(startOffset);
                PsiElement lastInJsp = file.getDocument().findElementAt(endOffset - 1);
                assert (firstInJsp != null);
                assert (lastInJsp != null);
                XmlText firstText = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)firstInJsp, XmlText.class);
                XmlText lastText = (XmlText)PsiTreeUtil.getParentOfType((PsiElement)lastInJsp, XmlText.class);
                try {
                    int offset;
                    String newText = "";
                    XmlText textElement = null;
                    int n = offset = firstText != null ? startOffset - firstText.getTextRange().getStartOffset() : 0;
                    if (firstText != null) {
                        newText = firstText.getValue().substring(0, firstText.physicalToDisplay(offset));
                        textElement = firstText;
                        PsiElement next = firstText.getNextSibling();
                        firstInJsp = next != null ? next : firstText;
                    } else {
                        firstInJsp = PsiTreeUtil.getParentOfType((PsiElement)firstInJsp, XmlTag.class);
                    }
                    assert (firstInJsp != null);
                    if (lastText != null) {
                        newText = newText + lastText.getValue().substring(lastText.physicalToDisplay(endOffset - lastText.getTextRange().getStartOffset()));
                        lastInJsp = lastText.getPrevSibling();
                        if (textElement == null) {
                            textElement = lastText;
                        } else if (lastText != firstText) {
                            lastText.delete();
                        }
                    } else {
                        lastInJsp = PsiTreeUtil.getParentOfType((PsiElement)lastInJsp, XmlTag.class);
                    }
                    XmlTag include = this.createInclude(firstInJsp, includePath);
                    if (textElement != null) {
                        textElement.setValue(newText);
                        if (!textElement.isValid()) {
                            firstInJsp.getParent().addBefore((PsiElement)include, firstInJsp);
                        } else {
                            textElement.insertAtOffset((XmlElement)include, offset);
                        }
                    } else {
                        firstInJsp.getParent().addBefore((PsiElement)include, firstInJsp);
                    }
                    if (firstText != lastText || firstText == null) {
                        firstInJsp.getParent().deleteChildRange(firstInJsp, lastInJsp);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            private XmlTag createInclude(PsiElement firstText, String includePath2) {
                XmlTag inJspTree = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)firstText, XmlTag.class);
                XmlTag includeTag = BaseJspUtil.getJspFile((PsiElement)ExtractJspIncludeFileHandler.this.myIncludingFile).createDirective(inJspTree, JspDirectiveKind.INCLUDE);
                try {
                    includeTag.setAttribute("file", includePath2);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                return includeTag;
            }
        });
    }

    @Nullable
    public static String getWebPath(PsiDirectory srcDirectory, PsiDirectory targetDirectory) {
        return PsiFileSystemItemUtil.getRelativePath((PsiFileSystemItem)srcDirectory, (PsiFileSystemItem)targetDirectory);
    }

    @Nullable
    protected Pair<XmlTagChild, XmlTagChild> findPairToExtract(int start, int end) {
        return XmlUtil.findTagChildrenInRange((PsiFile)this.myIncludingFile, (int)start, (int)end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/lang/jsp/extractInclude/ExtractJspIncludeFileHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForExtract";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

