/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAnnotationModelImpl
extends LocalAnnotationModel {
    @NotNull
    private final PsiClass myClass;
    @NotNull
    private final Module myModule;
    private Set<String> myActiveProfiles;
    private CachedValue<Set<CommonSpringModel>> myLocalRelatedModels;
    private boolean myEvaluateInnerConfigurationClasses;

    public LocalAnnotationModelImpl(@NotNull PsiClass aClass, @NotNull Module module) {
        if (aClass == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(1);
        }
        this.myActiveProfiles = ContainerUtil.newLinkedHashSet();
        this.myEvaluateInnerConfigurationClasses = true;
        this.myClass = aClass;
        this.myModule = module;
    }

    public void disableEvaluatingInnerConfigurationClasses() {
        this.myEvaluateInnerConfigurationClasses = false;
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myClass;
        if (psiClass == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        Set beans = (Set)RecursionManager.createGuard((String)"LocalAnnotationModel#calculateAllBeans").doPreventingRecursion((Object)this.myClass, true, () -> {
            LinkedHashSet allBeans = ContainerUtil.newLinkedHashSet();
            ContainerUtil.addIfNotNull((Collection)allBeans, (Object)LocalAnnotationModelImpl.getBeanForClass(this.myClass));
            allBeans.addAll(SpringJamUtils.getInstance().getContextBeans(this.myClass, this.getActiveProfiles()));
            return BeanService.getInstance().mapSpringBeans((Collection)allBeans);
        });
        return beans == null ? Collections.emptySet() : beans;
    }

    @Nullable
    private static CommonSpringBean getBeanForClass(@NotNull PsiClass aClass) {
        JamPsiMemberSpringBean psiMemberSpringBean;
        if (aClass == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(3);
        }
        if ((psiMemberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)aClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)aClass)) != null) {
            return psiMemberSpringBean;
        }
        if (!aClass.isInterface() && !aClass.hasModifierProperty("abstract") && SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)aClass)) {
            return new CustomSpringComponent(aClass);
        }
        return null;
    }

    public Iterable<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        models.addAll(this.getOrCreateLocalRelatedModels());
        models.add(this.getCustomDiscoveredBeansModel());
        return models;
    }

    @NotNull
    private Set<CommonSpringModel> getOrCreateLocalRelatedModels() {
        if (this.myLocalRelatedModels == null) {
            this.myLocalRelatedModels = CachedValuesManager.getManager((Project)this.getConfig().getProject()).createCachedValue(() -> {
                LinkedHashSet models = ContainerUtil.newLinkedHashSet();
                Set localModels = this.getRelatedLocalModels();
                models.addAll(localModels);
                models.addAll(this.getPackageScanModels(Collections.singleton(this), this.myModule, this.myActiveProfiles));
                if (this.myEvaluateInnerConfigurationClasses) {
                    models.addAll(LocalAnnotationModelImpl.getInnerStaticClassConfigurations(this.getConfig(), this.getModule()));
                }
                return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.mergeArrays((Object[])this.getOutsideModelDependencies((LocalModel)this), (Object[])this.getConfigs(localModels)));
            }, false);
        }
        Set set = (Set)this.myLocalRelatedModels.getValue();
        if (set == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static Set<CommonSpringModel> getInnerStaticClassConfigurations(@NotNull PsiClass config, @NotNull Module module) {
        if (config == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(5);
        }
        if (module == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(6);
        }
        HashSet models = ContainerUtil.newHashSet();
        for (PsiClass psiClass : config.getAllInnerClasses()) {
            if (!psiClass.hasModifierProperty("static") || JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) == null) continue;
            ContainerUtil.addIfNotNull((Collection)models, (Object)SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(psiClass, module));
        }
        return models;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(7);
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        LinkedHashSet allProfiles = ContainerUtil.newLinkedHashSet();
        SpringConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            LocalAnnotationModelImpl.processConfigurationProfiles(allProfiles, configuration);
        }
        for (PsiClass psiClass : SpringJamUtils.getInstance().getImportedClasses(this.myClass, this.getModule())) {
            for (SpringConfiguration springConfiguration : service.getAnnotatedMembersList(psiClass, SpringConfiguration.JAM_KEY, true, false, false, true)) {
                LocalAnnotationModelImpl.processConfigurationProfiles(allProfiles, springConfiguration);
            }
        }
        LinkedHashSet linkedHashSet = allProfiles;
        if (linkedHashSet == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    private static void processConfigurationProfiles(Set<String> allProfiles, SpringConfiguration configuration) {
        allProfiles.addAll(configuration.getProfile().getNames());
        for (SpringJavaBean bean : configuration.getBeans()) {
            allProfiles.addAll(bean.getProfile().getNames());
        }
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        if (this.myClass.isValid()) {
            files.add(this.myClass.getContainingFile());
            files.addAll(SpringJamUtils.getInstance().getImportedResources(this.myClass, new Module[]{this.myModule}));
        }
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    public boolean hasConfigFile(final @NotNull PsiFile configFile) {
        if (configFile == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(10);
        }
        if (!this.myClass.isValid()) {
            return false;
        }
        if (configFile instanceof PsiClassOwner && this.myClass.getContainingFile().equals(configFile)) {
            return true;
        }
        if (!(configFile instanceof XmlFile)) {
            return false;
        }
        CommonProcessors.FindProcessor<Pair<List<XmlFile>, ? extends PsiElement>> hasConfigFileProcessor = new CommonProcessors.FindProcessor<Pair<List<XmlFile>, ? extends PsiElement>>(){

            protected boolean accept(Pair<List<XmlFile>, ? extends PsiElement> pair) {
                return ((List)pair.first).contains(configFile);
            }
        };
        SpringJamUtils.getInstance().processImportedResources(this.myClass, (Processor)hasConfigFileProcessor, new Module[]{this.myModule});
        return hasConfigFileProcessor.isFound();
    }

    @Nullable
    public SpringConfiguration getConfiguration() {
        return (SpringConfiguration)JamService.getJamService((Project)this.myClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)this.myClass);
    }

    @NotNull
    public List<? extends SpringBeansPackagesScan> getComponentScans() {
        List packageScans = ContainerUtil.newSmartList();
        packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(this.myClass));
        for (PsiClass superClass : InheritanceUtil.getSuperClasses((PsiClass)this.myClass)) {
            if ("java.lang.Object".equals(superClass.getQualifiedName())) continue;
            packageScans.addAll(SpringJamUtils.getInstance().getBeansPackagesScan(superClass));
        }
        List list = packageScans;
        if (list == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(12);
        }
        this.myActiveProfiles = activeProfiles;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        Module module = this.getModule();
        if (module.isDisposed()) {
            Set<Pair<LocalModel, LocalModelDependency>> set = Collections.emptySet();
            if (set == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        SpringJamUtils.getInstance().processImportedResources(this.myClass, pair -> {
            if (models == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(24);
            }
            for (XmlFile xmlFile : (List)pair.first) {
                LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalXmlModel(xmlFile, module, this.getActiveProfiles()), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
            }
            return true;
        }, new Module[]{this.myModule});
        SpringJamUtils.getInstance().processImportedClasses(this.myClass, pair -> {
            if (models == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(23);
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel((PsiClass)pair.first), (LocalModelDependency)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)((PsiElement)pair.second)));
            return true;
        });
        LocalAnnotationModelImpl.processScannedConfigurations(this.myClass, (Processor<Pair<PsiPackage, ? extends PsiElement>>)((Processor)pair -> {
            if (models == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(22);
            }
            if (module.isDisposed()) {
                return false;
            }
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)((PsiPackage)pair.first), (boolean)true));
            List configurations = SpringJamModel.getModel((Module)module).getConfigurations(searchScope);
            for (SpringConfiguration configuration : configurations) {
                if (!SpringProfileUtils.isProfileAccepted((SpringProfile)configuration.getProfile(), this.getActiveProfiles())) continue;
                PsiElement identifyingElementForDependency = (PsiElement)pair.second;
                LocalModelDependency dependency = LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (PsiElement)(identifyingElementForDependency == null ? (PsiElement)pair.first : identifyingElementForDependency));
                LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel(configuration), (LocalModelDependency)dependency);
            }
            return true;
        }));
        SpringJamUtils.getInstance().processCustomAnnotations(this.myClass, enableAnnotation -> {
            if (models == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(21);
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)this.getLocalAnnotationModel((PsiClass)enableAnnotation.getFirst()), (LocalModelDependency)((LocalModelDependency)enableAnnotation.getSecond()));
            return true;
        });
        SpringJamUtils.getInstance().processCustomDependentLocalModels((LocalAnnotationModel)this, (model, dependency) -> {
            if (models == null) {
                LocalAnnotationModelImpl.$$$reportNull$$$0(20);
            }
            LocalAnnotationModelImpl.addNotNullModel((Set)models, (LocalModel)model, (LocalModelDependency)dependency);
            return true;
        });
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    @Nullable
    private LocalAnnotationModel getLocalAnnotationModel(@NotNull PsiClass aClass) {
        if (aClass == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(16);
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(aClass, this.getModule(), this.getActiveProfiles());
    }

    @Nullable
    protected LocalAnnotationModel getLocalAnnotationModel(@NotNull SpringConfiguration configuration) {
        if (configuration == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(17);
        }
        return SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, this.getModule(), this.getActiveProfiles());
    }

    private static boolean processScannedConfigurations(@NotNull PsiClass classToProcess, @NotNull Processor<Pair<PsiPackage, ? extends PsiElement>> processor) {
        if (classToProcess == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            LocalAnnotationModelImpl.$$$reportNull$$$0(19);
        }
        List scans = SpringJamUtils.getInstance().getBeansPackagesScan(classToProcess);
        for (SpringBeansPackagesScan packagesScan : scans) {
            if (packagesScan instanceof SpringComponentScan) {
                SpringComponentScan componentScan = (SpringComponentScan)packagesScan;
                if (componentScan.processPsiPackages(processor)) continue;
                return false;
            }
            for (PsiPackage aPackage : packagesScan.getPsiPackages()) {
                if (processor.process((Object)Pair.create((Object)aPackage, (Object)packagesScan.getIdentifyingPsiElement()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalAnnotationModelImpl)) {
            return false;
        }
        LocalAnnotationModelImpl model = (LocalAnnotationModelImpl)((Object)o);
        if (!this.myClass.equals(model.myClass)) {
            return false;
        }
        if (!this.myModule.equals(model.myModule)) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString(model.myActiveProfiles));
    }

    public int hashCode() {
        int result = this.myClass.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalAnnotationModelImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToProcess";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalAnnotationModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLocalRelatedModels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScans";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBeanForClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStaticClassConfigurations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processScannedConfigurations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDependentLocalModels$6";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDependentLocalModels$5";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDependentLocalModels$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDependentLocalModels$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDependentLocalModels$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

