/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.dom.namespaces;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFixes;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.namespaces.AbstractSpringBeanNamespaceDescriptor;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import org.jetbrains.annotations.NotNull;

public class PNamespaceUndefinedElementFixProvider
extends XmlUndefinedElementFixProvider {
    public IntentionAction[] createFixes(@NotNull XmlAttribute element) {
        if (element == null) {
            PNamespaceUndefinedElementFixProvider.$$$reportNull$$$0(0);
        }
        if (!"http://www.springframework.org/schema/p".equals(element.getNamespace())) {
            return null;
        }
        String localName = element.getLocalName();
        PsiClass psiClass = AbstractSpringBeanNamespaceDescriptor.getClass(element.getParent());
        if (psiClass != null) {
            PsiType type = null;
            if (localName.endsWith("-ref")) {
                PsiType[] types;
                SpringBeanPointer pointer;
                SpringModel model = SpringManager.getInstance((Project)element.getProject()).getSpringModelByFile(element.getContainingFile());
                String value = element.getDisplayValue();
                if (model != null && value != null && (pointer = SpringBeanUtils.getInstance().findBean((CommonSpringModel)model, value)) != null && (types = pointer.getEffectiveBeanTypes()).length > 0) {
                    type = types[0];
                }
            }
            String name = StringUtil.trimEnd((String)localName, (String)"-ref");
            return CreateBeanPropertyFixes.createActions((String)name, (PsiClass)psiClass, type, (boolean)true);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/dom/namespaces/PNamespaceUndefinedElementFixProvider", "createFixes"));
    }
}

