/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringObjectFactoryEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    public void processEffectiveTypes(@NotNull CommonSpringBean bean, Collection<PsiType> result) {
        if (bean == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        PsiType beanType = bean.getBeanType();
        ContainerUtil.addIfNotNull(result, (Object)SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(beanType));
    }

    @Nullable
    public static PsiType getObjectFactoryEffectiveType(@Nullable PsiType beanType) {
        if (beanType instanceof PsiClassType) {
            PsiClassType type = (PsiClassType)beanType;
            if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType(type);
            }
            if (SpringObjectFactoryEffectiveTypeProvider.isInjectProvider(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getInjectProviderType(type);
            }
        }
        return null;
    }

    public static boolean isObjectFactory(@NotNull PsiClassType aType) {
        if (aType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(1);
        }
        return InheritanceUtil.isInheritor((PsiClass)aType.resolve(), (String)"org.springframework.beans.factory.ObjectFactory");
    }

    public static boolean isInjectProvider(@NotNull PsiClassType aType) {
        if (aType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(2);
        }
        return InheritanceUtil.isInheritor((PsiClass)aType.resolve(), (String)"javax.inject.Provider");
    }

    @Nullable
    public static PsiType getInjectProviderType(@NotNull PsiClassType classType) {
        if (classType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(3);
        }
        return PsiUtil.substituteTypeParameter((PsiType)classType, (String)"javax.inject.Provider", (int)0, (boolean)false);
    }

    @Nullable
    public static PsiType getObjectFactoryType(@NotNull PsiClassType classType) {
        if (classType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(4);
        }
        return PsiUtil.substituteTypeParameter((PsiType)classType, (String)"org.springframework.beans.factory.ObjectFactory", (int)0, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEffectiveTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectProviderType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectFactoryType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

