/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.cacheable.highlighting;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.cacheable.highlighting.SpringCacheableBaseInspection;
import com.intellij.spring.model.cacheable.jam.SpringCachingGroups;
import com.intellij.spring.model.cacheable.jam.SpringJamBaseCacheableElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCacheableComponentsInspection
extends SpringCacheableBaseInspection {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(1);
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)method)) {
            ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)method.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)method);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                PsiAnnotation annotation;
                if (!method.getModifierList().hasModifierProperty("public") && (annotation = cacheable.getAnnotation()) != null) {
                    holder.registerProblem((PsiElement)annotation, SpringBundle.message("cacheable.annotations.should.be.defined.on.public.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                this.checkBeansResolve(cacheable, holder);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(3);
        }
        if (SpringCacheableComponentsInspection.isPlainJavaFileInSpringModule((PsiElement)aClass)) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            List elements = SemService.getSemService((Project)aClass.getProject()).getSemElements(SpringJamBaseCacheableElement.CACHEABLE_BASE_JAM_KEY, (PsiElement)aClass);
            for (SpringJamBaseCacheableElement cacheable : elements) {
                this.checkBeansResolve(cacheable, holder);
            }
            SpringCachingGroups cachingGroups = (SpringCachingGroups)JamService.getJamService((Project)aClass.getProject()).getJamElement((PsiElement)aClass, new JamMemberMeta[]{SpringCachingGroups.META});
            if (cachingGroups != null) {
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheables()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCachePuts()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
                for (SpringJamBaseCacheableElement springJamBaseCacheableElement : cachingGroups.getCacheEvict()) {
                    this.checkBeansResolve(springJamBaseCacheableElement, holder);
                }
            }
            return holder.getResultsArray();
        }
        return null;
    }

    private void checkBeansResolve(@NotNull SpringJamBaseCacheableElement cacheable, @NotNull ProblemsHolder holder) {
        if (cacheable == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(5);
        }
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getCacheManagerElement(), (String)"org.springframework.cache.CacheManager");
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getCacheResolverElement(), (String)"org.springframework.cache.interceptor.CacheResolver");
        SpringCacheableComponentsInspection.checkBeanPointerResolve((ProblemsHolder)holder, cacheable.getKeyGeneratorElement(), (String)"org.springframework.cache.interceptor.KeyGenerator");
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringCacheableComponentsInspection" == null) {
            SpringCacheableComponentsInspection.$$$reportNull$$$0(6);
        }
        return "SpringCacheableComponentsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/cacheable/highlighting/SpringCacheableComponentsInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkBeansResolve";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

