/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LanguageAnnotationSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationSupport;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.autowire.SpringJavaAutowiringBaseInspection;
import com.intellij.spring.model.highlighting.fixes.ShowBeansQuickFix;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.references.SpringBeanReference;
import com.intellij.spring.references.SpringQualifierReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJavaInjectionPointsAutowiringInspection
extends SpringJavaAutowiringBaseInspection {
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiMethod == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)psiMethod.getContainingFile()) && this.isRelevantClass(psiMethod.getContainingClass()) && SpringAutowireUtil.isInjectionPoint(psiMethod) && (model = SpringAutowireUtil.getProcessingSpringModel(psiMethod.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiMethod.getContainingFile(), isOnTheFly);
            boolean required = SpringAutowireUtil.isRequired((PsiModifierListOwner)psiMethod);
            if (SpringAutowireUtil.getResourceAnnotation((PsiModifierListOwner)psiMethod) != null) {
                SpringJavaInjectionPointsAutowiringInspection.checkResourceMethod(psiMethod, holder, model, required);
            } else if (psiMethod.getParameterList().getParametersCount() == 0 && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiMethod)) {
                PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
                if (nameIdentifier != null) {
                    String msg = SpringBundle.message("bean.autowiring.by.type.no.parameter.for.autowired.method", psiMethod.isConstructor() ? "constructor" : "method");
                    holder.registerProblem((PsiElement)nameIdentifier, msg, new LocalQuickFix[0]);
                }
            } else {
                SpringJavaInjectionPointsAutowiringInspection.checkAutowiredMethodInjections(psiMethod, holder, model, required);
            }
            return holder.getResultsArray();
        }
        return null;
    }

    public ProblemDescriptor[] checkField(@NotNull PsiField psiField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        CommonSpringModel model;
        if (psiField == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(3);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)psiField.getContainingFile()) && this.isRelevantClass(psiField.getContainingClass()) && SpringAutowireUtil.isAutowiredByAnnotation((PsiModifierListOwner)psiField) && (model = SpringAutowireUtil.getProcessingSpringModel(psiField.getContainingClass())) != null) {
            ProblemsHolder holder = new ProblemsHolder(manager, psiField.getContainingFile(), isOnTheFly);
            SpringJavaInjectionPointsAutowiringInspection.checkInjectionPoint((PsiModifierListOwner)psiField, psiField.getType(), holder, model, SpringAutowireUtil.isRequired((PsiModifierListOwner)psiField));
            return holder.getResultsArray();
        }
        return null;
    }

    private static void checkAutowiredMethodInjections(PsiMethod psiMethod, @NotNull ProblemsHolder holder, CommonSpringModel springModel, boolean required) {
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(4);
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"org.springframework.beans.factory.annotation.Value", (boolean)true)) continue;
            SpringJavaInjectionPointsAutowiringInspection.checkInjectionPoint((PsiModifierListOwner)parameter, parameter.getType(), holder, springModel, required);
        }
    }

    private static void checkResourceMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        PsiType type;
        if (psiMethod == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(6);
        }
        if (springModel == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(7);
        }
        if ((type = PropertyUtil.getPropertyType((PsiMember)psiMethod)) != null) {
            SpringJavaInjectionPointsAutowiringInspection.checkInjectionPoint((PsiModifierListOwner)psiMethod, type, holder, springModel, required);
        }
    }

    public static void checkInjectionPoint(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, boolean required) {
        PsiAnnotation resourceAnnotation;
        if (injectionPointOwner == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(8);
        }
        if (psiType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(10);
        }
        if (springModel == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(11);
        }
        if ((resourceAnnotation = SpringAutowireUtil.getResourceAnnotation(injectionPointOwner)) != null && injectionPointOwner instanceof PsiMember) {
            SpringJavaInjectionPointsAutowiringInspection.checkResourceInjectionPoint(injectionPointOwner, psiType, holder, springModel, resourceAnnotation);
            return;
        }
        PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getEffectiveQualifiedAnnotation(injectionPointOwner);
        if (qualifiedAnnotation != null) {
            SpringJavaInjectionPointsAutowiringInspection.checkQualifiedAutowiring(psiType, qualifiedAnnotation, holder, springModel);
            return;
        }
        SpringJavaInjectionPointsAutowiringInspection.checkByTypeAutowire((PsiNameIdentifierOwner)injectionPointOwner, psiType, holder, springModel, required);
    }

    private static void checkResourceInjectionPoint(@NotNull PsiModifierListOwner injectionPointOwner, @NotNull PsiType psiType, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel springModel, @NotNull PsiAnnotation resourceAnnotation) {
        PsiAnnotationMemberValue attributeValue;
        if (injectionPointOwner == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(12);
        }
        if (psiType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(14);
        }
        if (springModel == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(15);
        }
        if (resourceAnnotation == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(16);
        }
        if ((attributeValue = resourceAnnotation.findDeclaredAttributeValue("name")) != null) {
            SpringJavaInjectionPointsAutowiringInspection.checkByNameAutowiring(attributeValue, holder, springModel, psiType);
        }
    }

    private static void checkByNameAutowiring(@NotNull PsiAnnotationMemberValue annotationMemberValue, @NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType) {
        if (annotationMemberValue == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(18);
        }
        if (model == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(19);
        }
        if (memberEffectiveType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(20);
        }
        for (PsiReference reference : annotationMemberValue.getReferences()) {
            PsiConstantEvaluationHelper helper;
            Object o;
            PsiElement element;
            if (reference instanceof SpringBeanReference) {
                SpringBeanReference sbReference = (SpringBeanReference)reference;
                SpringJavaInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, sbReference.getValue(), sbReference.isFactoryBeanRef());
                break;
            }
            if (!(reference instanceof PsiReferenceExpression) || !((element = reference.resolve()) instanceof PsiField) || !((o = (helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)((PsiField)element).getInitializer())) instanceof String)) continue;
            SpringJavaInjectionPointsAutowiringInspection.checkResourceBeanReference(holder, model, memberEffectiveType, reference, (String)o, false);
        }
    }

    private static void checkResourceBeanReference(@NotNull ProblemsHolder holder, @NotNull CommonSpringModel model, @NotNull PsiType memberEffectiveType, @NotNull PsiReference ref, @Nullable String beanName, boolean isFactoryBeanRef) {
        SpringBeanPointer bean;
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(21);
        }
        if (model == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(22);
        }
        if (memberEffectiveType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(23);
        }
        if (ref == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(24);
        }
        if (beanName != null && (bean = SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName)) != null) {
            PsiType[] beanTypes;
            for (PsiType psiType : beanTypes = SpringJavaInjectionPointsAutowiringInspection.getEffectiveBeanTypes(isFactoryBeanRef, bean)) {
                if (!SpringAutowireUtil.canBeAutowiredByType(memberEffectiveType, psiType)) continue;
                return;
            }
            holder.registerProblem(ref, SpringBundle.message("cannot.autowire.bean.of.type", memberEffectiveType.getCanonicalText()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return;
        }
        if (ref instanceof SpringBeanReference) {
            holder.registerProblem(ref);
        } else if (beanName != null) {
            holder.registerProblem(ref.getElement(), SpringApiBundle.message((String)"model.bean.error.message", (Object[])new Object[]{beanName}), new LocalQuickFix[0]);
        }
    }

    private static PsiType[] getEffectiveBeanTypes(boolean factoryBeanRef, SpringBeanPointer bean) {
        PsiClass beanClass;
        if (factoryBeanRef && (beanClass = bean.getBeanClass()) != null) {
            return new PsiType[]{PsiTypesUtil.getClassType((PsiClass)beanClass)};
        }
        return bean.getEffectiveBeanTypes();
    }

    private static void checkQualifiedAutowiring(PsiType searchType, PsiAnnotation qualifiedAnnotation, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model) {
        Set<SpringBeanPointer> beanPointers;
        if (model == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(25);
        }
        PsiAnnotationMemberValue attributeValue = qualifiedAnnotation.findDeclaredAttributeValue("value");
        String name = SpringAutowireUtil.getQualifiedBeanName(qualifiedAnnotation);
        PsiReference qreference = null;
        if (attributeValue != null) {
            PsiReference[] references;
            for (PsiReference reference : references = attributeValue.getReferences()) {
                if (!(reference instanceof SpringQualifierReference)) continue;
                qreference = reference;
                if (((SpringQualifierReference)reference).multiResolve(false).length != 0) continue;
                if (holder != null && reference.getElement().isPhysical()) {
                    holder.registerProblem(reference, SpringBundle.message("bean.class.unknown.qualifier.bean", name), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
                return;
            }
        }
        if ((beanPointers = SpringAutowireUtil.getQualifiedBeanPointers(qualifiedAnnotation, model)).size() == 0) {
            if (holder != null) {
                if (attributeValue != null) {
                    SpringJavaInjectionPointsAutowiringInspection.reportProblem(holder, qreference, attributeValue, SpringBundle.message("bean.class.unknown.qualifier.bean", name));
                } else {
                    String qualifiedName = qualifiedAnnotation.getQualifiedName();
                    assert (qualifiedName != null);
                    SpringJavaInjectionPointsAutowiringInspection.reportProblem(holder, qreference, (PsiAnnotationMemberValue)qualifiedAnnotation, SpringBundle.message("cannot.find.bean.qualified.by", "@" + StringUtil.getShortName((String)qualifiedName)));
                }
            }
            return;
        }
        Set<SpringBeanPointer> autowiredPointers = SpringAutowireUtil.filterPointersByAutowiredType(searchType, beanPointers);
        if (autowiredPointers.isEmpty() && SpringAutowireUtil.getIterableBeanPointers(searchType, model, null).size() == 0 && holder != null) {
            String message = SpringBundle.message("bean.class.autowired.incorrect.qualifier.type", searchType.getPresentableText());
            SpringJavaInjectionPointsAutowiringInspection.reportProblem(holder, qreference, (PsiAnnotationMemberValue)(attributeValue == null ? qualifiedAnnotation : attributeValue), message);
        }
    }

    private static void reportProblem(@NotNull ProblemsHolder holder, @Nullable PsiReference qreference, @NotNull PsiAnnotationMemberValue attributeValue, String text) {
        if (holder == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(26);
        }
        if (attributeValue == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(27);
        }
        if (qreference == null) {
            holder.registerProblem((PsiElement)attributeValue, text, new LocalQuickFix[0]);
        } else {
            holder.registerProblem(qreference, text, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkByTypeAutowire(PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull PsiType searchType, @Nullable ProblemsHolder holder, @NotNull CommonSpringModel model, boolean required) {
        if (searchType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(28);
        }
        if (model == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(29);
        }
        PsiElement psiElement = psiNameIdentifierOwner.getNameIdentifier();
        assert (psiElement != null) : psiNameIdentifierOwner;
        String primaryCandidateName = psiNameIdentifierOwner.getName();
        Set<SpringBeanPointer> beanPointers = SpringAutowireUtil.autowireByType(model, searchType, primaryCandidateName);
        Set<SpringBeanPointer> iterableBeanPointers = SpringAutowireUtil.getIterableBeanPointers(searchType, model, primaryCandidateName);
        if (beanPointers.isEmpty() && iterableBeanPointers.isEmpty() && required) {
            if (!(holder == null || SpringAutowireUtil.isAutowiredByDefault(searchType) || SpringJavaInjectionPointsAutowiringInspection.isObjectFactory(searchType) || SpringJavaInjectionPointsAutowiringInspection.isInjectionPoint(searchType) || SpringAutowireUtil.isJavaUtilOptional(searchType))) {
                holder.registerProblem(psiElement, SpringJavaInjectionPointsAutowiringInspection.getBeansNotFoundMessage(searchType), new LocalQuickFix[0]);
            }
        } else if (iterableBeanPointers.isEmpty() && beanPointers.size() > 1 && holder != null) {
            Set<SpringBeanPointer> filtered = SpringJavaInjectionPointsAutowiringInspection.filterOverridenBeans(beanPointers);
            if ((filtered = SpringJavaInjectionPointsAutowiringInspection.filterSelfReferencedBeans(psiNameIdentifierOwner, filtered)).size() > 1) {
                if (SpringJavaInjectionPointsAutowiringInspection.isNonDefinedActiveProfile(model.getActiveProfiles()) && SpringJavaInjectionPointsAutowiringInspection.isAllBeansInDifferentProfiles(filtered)) {
                    return;
                }
                PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiModifierListOwner.class, (boolean)false);
                holder.registerProblem(psiElement, SpringJavaInjectionPointsAutowiringInspection.getErrorMessage(searchType, filtered), new LocalQuickFix[]{new AddSpringBeanQualifierFix(psiModifierListOwner, beanPointers, SpringJavaInjectionPointsAutowiringInspection.getQualifierAnnotation(psiModifierListOwner)), new ShowBeansQuickFix(beanPointers)});
            }
        }
    }

    private static String getBeansNotFoundMessage(@NotNull PsiType searchType) {
        PsiType secondarySearchType;
        if (searchType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(30);
        }
        return (secondarySearchType = SpringAutowireUtil.getIterableSearchType(searchType)) != null ? SpringBundle.message("bean.autowiring.by.type.no.beans", secondarySearchType.getPresentableText(), searchType.getPresentableText()) : SpringBundle.message("bean.autowiring.by.type.none", searchType.getPresentableText());
    }

    private static boolean isObjectFactory(@NotNull PsiType type) {
        if (type == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(31);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.beans.factory.ObjectFactory");
        }
        return false;
    }

    private static boolean isInjectionPoint(@NotNull PsiType type) {
        if (type == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(32);
        }
        if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            return psiClass != null && "org.springframework.beans.factory.InjectionPoint".equals(psiClass.getQualifiedName());
        }
        return false;
    }

    @NotNull
    private static String getErrorMessage(@NotNull PsiType beanType, Set<SpringBeanPointer> autowiredPointers) {
        if (beanType == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(33);
        }
        SortedList sortedByNamePointers = new SortedList((o1, o2) -> ((String)o1.first).compareTo((String)o2.first));
        for (SpringBeanPointer pointer : autowiredPointers) {
            sortedByNamePointers.add(Pair.create((Object)SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer), (Object)SpringPresentationProvider.getSpringBeanLocation((SpringBeanPointer)pointer)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        sb.append("<tr><td>");
        sb.append(SpringBundle.message("bean.class.autowired.by.type", beanType.getPresentableText()));
        sb.append("</td></tr>");
        sb.append("<tr><td>");
        sb.append("<table>");
        sb.append("<tr><td valign='top'>Beans:</td>");
        sb.append("<td>");
        for (Pair pair : sortedByNamePointers) {
            sb.append((String)pair.first);
            sb.append("&nbsp;&nbsp; (");
            sb.append((String)pair.second);
            sb.append(")<br>");
        }
        sb.append("</td></tr>");
        sb.append("</table>");
        sb.append("</td></tr>");
        sb.append("</table></html>");
        String string = sb.toString();
        if (string == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterSelfReferencedBeans(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner, @NotNull Set<SpringBeanPointer> pointers) {
        PsiMethod psiMethod;
        if (psiNameIdentifierOwner == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(35);
        }
        if (pointers == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(36);
        }
        if ((psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiNameIdentifierOwner, PsiMethod.class)) == null) {
            Set<SpringBeanPointer> set = pointers;
            if (set == null) {
                SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(37);
            }
            return set;
        }
        LinkedHashSet filtered = ContainerUtil.newLinkedHashSet();
        for (SpringBeanPointer pointer : pointers) {
            if (psiMethod.equals(pointer.getSpringBean().getIdentifyingPsiElement())) continue;
            filtered.add(pointer);
        }
        LinkedHashSet linkedHashSet = filtered;
        if (linkedHashSet == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(38);
        }
        return linkedHashSet;
    }

    private static boolean isAllBeansInDifferentProfiles(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(39);
        }
        Set names = ContainerUtil.newConcurrentSet();
        for (SpringBeanPointer pointer : pointers) {
            CommonSpringBean bean = pointer.getSpringBean();
            for (String profileName : bean.getProfile().getNames()) {
                if (names.contains(profileName)) {
                    return false;
                }
                names.add(profileName);
            }
        }
        return true;
    }

    private static boolean isNonDefinedActiveProfile(@Nullable Set<String> activeProfiles) {
        if (activeProfiles == null || activeProfiles.isEmpty()) {
            return true;
        }
        boolean isDefaultProfile = activeProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(activeProfiles.iterator().next());
        return !isDefaultProfile;
    }

    @NotNull
    private static Set<SpringBeanPointer> filterOverridenBeans(@NotNull Set<SpringBeanPointer> pointers) {
        if (pointers == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(40);
        }
        MultiMap names = new MultiMap();
        Set set = ContainerUtil.map2SetNotNull(pointers, pointer -> {
            boolean isOverriden = false;
            String name = pointer.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                VirtualFile containingFile = pointer.getContainingFile().getVirtualFile();
                if (names.containsKey((Object)name) && !names.values().contains(containingFile)) {
                    isOverriden = true;
                }
                names.putValue((Object)name, (Object)containingFile);
            }
            return isOverriden ? null : pointer;
        });
        if (set == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(41);
        }
        return set;
    }

    @NotNull
    private static String getQualifierAnnotation(@Nullable PsiModifierListOwner psiModifierListOwner) {
        PsiMember psiMember;
        if (psiModifierListOwner != null && (psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiMember.class, (boolean)false)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javax.inject.Inject", (boolean)true)) {
            if ("javax.inject.Named" == null) {
                SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(42);
            }
            return "javax.inject.Named";
        }
        if ("org.springframework.beans.factory.annotation.Qualifier" == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(43);
        }
        return "org.springframework.beans.factory.annotation.Qualifier";
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaInjectionPointsAutowiringInspection" == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(44);
        }
        return "SpringJavaInjectionPointsAutowiringInspection";
    }

    private static Expression getQualifierNamesSuggestNamesExpression(final PsiLiteral psiLiteral, final @NotNull Collection<SpringBeanPointer> beanPointers) {
        if (beanPointers == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(45);
        }
        return new Expression(){

            public com.intellij.codeInsight.template.Result calculateResult(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                return new TextResult(ElementManipulators.getValueText((PsiElement)psiLiteral));
            }

            public com.intellij.codeInsight.template.Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                LinkedHashSet<LookupElement> items = new LinkedHashSet<LookupElement>();
                PsiClass psiAnnoClass = SpringQualifierReference.findAnnoPsiClass(psiLiteral);
                for (SpringBeanPointer pointer : beanPointers) {
                    CommonSpringBean bean = pointer.getSpringBean();
                    if (psiAnnoClass == null) continue;
                    for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                        String value = qualifier.getQualifierValue();
                        if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                        items.add(SpringConverterUtil.createCompletionVariant((SpringBeanPointer)pointer, (String)value));
                    }
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }

    @NotNull
    private static String getBeanPointerName(@NotNull SpringBeanPointer beanPointer) {
        String name;
        if (beanPointer == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(46);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(name = beanPointer.getName())) ? "Unknown" : name;
        if (string == null) {
            SpringJavaInjectionPointsAutowiringInspection.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionPointOwner";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceAnnotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMemberValue";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberEffectiveType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchType";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanType";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringJavaInjectionPointsAutowiringInspection";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiNameIdentifierOwner";
                break;
            }
            case 36: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointers";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringJavaInjectionPointsAutowiringInspection";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSelfReferencedBeans";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOverridenBeans";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotation";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanPointerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiredMethodInjections";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkInjectionPoint";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceInjectionPoint";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkByNameAutowiring";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkResourceBeanReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkQualifiedAutowiring";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reportProblem";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkByTypeAutowire";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBeansNotFoundMessage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isObjectFactory";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isInjectionPoint";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "filterSelfReferencedBeans";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isAllBeansInDifferentProfiles";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "filterOverridenBeans";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierNamesSuggestNamesExpression";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getBeanPointerName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 34: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddSpringBeanQualifierFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiModifierListOwner> myModifierListOwnerPointer;
        private final Collection<SpringBeanPointer> myBeanPointers;
        private final String myQualifierAnno;

        public AddSpringBeanQualifierFix(PsiModifierListOwner psiElement, @NotNull Collection<SpringBeanPointer> beanPointers, @NotNull String qualifierAnno) {
            if (beanPointers == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(0);
            }
            if (qualifierAnno == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(1);
            }
            this.myModifierListOwnerPointer = SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer((PsiElement)psiElement);
            this.myBeanPointers = beanPointers;
            this.myQualifierAnno = qualifierAnno;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("SpringAutowiringInspection.add.qualifier.fix", new Object[0]);
            if (string == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiModifierList modifierList;
            PsiModifierListOwner modifierListOwner;
            if (project == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(4);
            }
            if ((modifierListOwner = (PsiModifierListOwner)this.myModifierListOwnerPointer.getElement()) == null) {
                return;
            }
            if (FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierListOwner) && (modifierList = modifierListOwner.getModifierList()) != null && this.myBeanPointers.size() > 0) {
                new WriteCommandAction(modifierListOwner.getProject(), new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        PsiAnnotation annotation = modifierList.addAnnotation(myQualifierAnno);
                        PsiAnnotationSupport support = (PsiAnnotationSupport)LanguageAnnotationSupport.INSTANCE.forLanguage(annotation.getLanguage());
                        PsiLiteral psiLiteral = (PsiLiteral)annotation.setDeclaredAttributeValue("value", (PsiAnnotationMemberValue)support.createLiteralValue(SpringJavaInjectionPointsAutowiringInspection.getBeanPointerName((SpringBeanPointer)myBeanPointers.iterator().next()), (PsiElement)annotation));
                        CodeStyleManager formatter = CodeStyleManager.getInstance((Project)project);
                        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                        codeStyleManager.shortenClassReferences(formatter.reformat((PsiElement)annotation));
                        Editor editor = AddSpringBeanQualifierFix.getEditor(modifierListOwner);
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                        TemplateManager manager = TemplateManager.getInstance((Project)modifierListOwner.getProject());
                        manager.startTemplate(editor, this.createQualifierNameTemplate(psiLiteral));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/model/highlighting/autowire/SpringJavaInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix$1", "run"));
                    }
                }.execute();
            }
        }

        private Template createQualifierNameTemplate(@NotNull PsiLiteral psiLiteral) {
            if (psiLiteral == null) {
                AddSpringBeanQualifierFix.$$$reportNull$$$0(5);
            }
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)psiLiteral.getContainingFile());
            TextRange textRange = psiLiteral.getTextRange();
            String valueText = ElementManipulators.getValueText((PsiElement)psiLiteral);
            builder.replaceRange(TextRange.from((int)(textRange.getStartOffset() + 1), (int)valueText.length()), SpringJavaInjectionPointsAutowiringInspection.getQualifierNamesSuggestNamesExpression(psiLiteral, this.myBeanPointers));
            return builder.buildInlineTemplate();
        }

        public static Editor getEditor(PsiModifierListOwner modifierListOwner) {
            PsiFile psiFile = modifierListOwner.getContainingFile();
            Project project = psiFile.getProject();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, 0), false);
            assert (editor != null);
            return editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "beanPointers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierAnno";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringJavaInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiLiteral";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringJavaInjectionPointsAutowiringInspection$AddSpringBeanQualifierFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createQualifierNameTemplate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

