/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.fixes.ShowBeansQuickFix;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringXmlAutowiringInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringXmlAutowiringInspection" == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(0);
        }
        return "SpringXmlAutowiringInspection";
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        DefaultableBoolean autoWireCandidate;
        if (springBean == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(1);
        }
        if (beans == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(3);
        }
        if (model == null) {
            return;
        }
        GenericAttributeValue autowireCandidateAttribute = springBean.getAutowireCandidate();
        if (DomUtil.hasXml((DomElement)autowireCandidateAttribute) && (autoWireCandidate = (DefaultableBoolean)autowireCandidateAttribute.getValue()) != null && !autoWireCandidate.getBooleanValue().booleanValue()) {
            return;
        }
        SpringXmlAutowiringInspection.checkAutowiring(springBean, model, holder);
    }

    private static void checkAutowiring(@NotNull SpringBean springBean, @NotNull CommonSpringModel model, DomElementAnnotationHolder holder) {
        Autowire autowire;
        if (springBean == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(4);
        }
        if (model == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(5);
        }
        if ((autowire = springBean.getBeanAutowire()).equals((Object)Autowire.BY_TYPE)) {
            SpringXmlAutowiringInspection.checkByTypeAutowire(springBean, model, holder);
        } else if (autowire.equals((Object)Autowire.CONSTRUCTOR)) {
            SpringXmlAutowiringInspection.checkByConstructorAutowire(springBean, holder);
        }
    }

    private static void checkByConstructorAutowire(@NotNull SpringBean springBean, @NotNull DomElementAnnotationHolder holder) {
        if (springBean == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(7);
        }
        if (PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) == null) {
            return;
        }
        ResolvedConstructorArgs resolvedArgs = springBean.getResolvedConstructorArgs();
        if (resolvedArgs.isResolved()) {
            return;
        }
        for (PsiMethod checkedMethod : resolvedArgs.getCheckedMethods()) {
            Map autowiredParams = resolvedArgs.getAutowiredParams(checkedMethod);
            if (autowiredParams == null || autowiredParams.size() <= 0) continue;
            Set entries = autowiredParams.entrySet();
            for (Map.Entry entry : entries) {
                SpringXmlAutowiringInspection.checkAutowire(springBean, holder, checkedMethod, (PsiParameter)entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    private static void checkAutowire(SpringBean springBean, DomElementAnnotationHolder holder, PsiMethod checkedMethod, PsiParameter psiParameter, Collection<SpringBeanPointer> springBeans) {
        PsiType psiType = psiParameter.getType();
        if (springBeans != null && springBeans.size() > 1 && !PsiTypeUtil.getInstance((Project)psiParameter.getProject()).isCollectionType(psiType) && !(psiType instanceof PsiArrayType)) {
            ArrayList<String> beanNames = new ArrayList<String>();
            for (SpringBeanPointer pointer : springBeans) {
                beanNames.add(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer));
            }
            String methodName = PsiFormatUtil.formatMethod((PsiMethod)checkedMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            String message = SpringBundle.message("bean.autowiring.by.type", psiType.getPresentableText(), StringUtil.join(beanNames, (String)","), methodName);
            Object problemElement = DomUtil.hasXml((DomElement)springBean.getClazz()) ? springBean.getClazz() : (DomUtil.hasXml((DomElement)springBean.getFactoryMethod()) ? springBean.getFactoryMethod() : springBean);
            holder.createProblem((DomElement)problemElement, message, new LocalQuickFix[0]);
        }
    }

    private static void checkByTypeAutowire(@NotNull SpringBean springBean, @NotNull CommonSpringModel model, @NotNull DomElementAnnotationHolder holder) {
        PsiClass beanClass;
        if (springBean == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(8);
        }
        if (model == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            SpringXmlAutowiringInspection.$$$reportNull$$$0(10);
        }
        if ((beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType())) == null) {
            return;
        }
        for (PsiMethod psiMethod : beanClass.getAllMethods()) {
            if (!PropertyUtil.isSimplePropertySetter((PsiMethod)psiMethod)) continue;
            SpringXmlAutowiringInspection.checkByType(springBean, model, holder, psiMethod.getParameterList().getParameters()[0].getType(), psiMethod);
        }
    }

    private static void checkByType(SpringBean springBean, CommonSpringModel model, DomElementAnnotationHolder holder, PsiType psiType, PsiMethod psiMethod) {
        Collection<SpringBeanPointer> beans;
        PsiAnnotation qualifiedAnnotation = SpringAutowireUtil.getQualifiedAnnotation((PsiModifierListOwner)psiMethod);
        Collection<SpringBeanPointer> collection = beans = qualifiedAnnotation != null ? SpringAutowireUtil.getQualifiedBeans(qualifiedAnnotation, model) : SpringAutowireUtil.autowireByType(model, SpringAutowireUtil.getAutowiredEffectiveBeanTypes(psiType));
        if (beans.size() > 1) {
            ArrayList<String> properties = new ArrayList<String>();
            String propertyName = PropertyUtil.getPropertyNameBySetter((PsiMethod)psiMethod);
            if (!SpringAutowireUtil.isPropertyDefined(springBean, propertyName)) {
                properties.add(propertyName);
            }
            if (properties.size() > 0) {
                ArrayList<String> beanNames = new ArrayList<String>();
                for (SpringBeanPointer pointer : beans) {
                    beanNames.add(SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)pointer));
                }
                String message = SpringBundle.message("bean.autowiring.by.type", psiType.getPresentableText(), StringUtil.join(beanNames, (String)","), StringUtil.join(properties, (String)","));
                holder.createProblem((DomElement)springBean, message, new LocalQuickFix[]{new ShowBeansQuickFix(beans)});
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowiringInspection";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowiringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAutowiring";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkByConstructorAutowire";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkByTypeAutowire";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

