/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.config.ConfigureFileSetFix;
import com.intellij.spring.model.highlighting.config.CreateSpringFacetFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.spi.SpringSpiManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFacetCodeInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass psiClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiClass == null) {
            SpringFacetCodeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringFacetCodeInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)psiClass.getProject())) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (psiClass.hasModifierProperty("static")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (SpringModelUtils.getInstance().isUsedConfigurationFile(containingFile, false)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)psiClass.getProject());
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!SpringSpiManager.getInstance((Module)module).processClassesListValues(false, psiClass.getQualifiedName(), (property, aClass) -> {
            if (psiClass == null) {
                SpringFacetCodeInspection.$$$reportNull$$$0(3);
            }
            return !aClass.isEquivalentTo((PsiElement)psiClass);
        })) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass((PsiClass)psiClass);
        for (CommonSpringModel springModel : SpringManager.getInstance((Project)psiClass.getProject()).getAllModels(module)) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)params)) continue;
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object fix = SpringCommonUtils.hasSpringFacet((Module)module) ? new ConfigureFileSetFix(module, virtualFile) : new CreateSpringFacetFix(module);
        PsiIdentifier identifier = psiClass.getNameIdentifier();
        PsiIdentifier highlightElement = identifier != null ? identifier : psiClass;
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)highlightElement, SpringBundle.message("spring.facet.inspection.context.not.configured.for.file", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
        return new ProblemDescriptor[]{descriptor};
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringFacetCodeInspection" == null) {
            SpringFacetCodeInspection.$$$reportNull$$$0(2);
        }
        return "SpringFacetCodeInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/config/SpringFacetCodeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

