/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFix;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public class ContextJavaBeanUnresolvedMethodsInspection
extends AbstractBaseUastLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiFile file;
        Module module;
        if (aClass == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(file = aClass.getContainingFile())))) && !SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (UMethod uMethod : aClass.getMethods()) {
            ContextJavaBeanUnresolvedMethodsInspection.checkMethod(uMethod, holder, module);
        }
        return holder.getResultsArray();
    }

    private static void checkMethod(@NotNull UMethod uMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        ContextJavaBean contextJavaBean;
        if (uMethod == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(4);
        }
        if ((contextJavaBean = ContextJavaBeanUnresolvedMethodsInspection.getContextJavaBean(uMethod, module)) != null) {
            ContextJavaBeanUnresolvedMethodsInspection.checkContextJavaBean(contextJavaBean, holder);
        }
    }

    private static void checkContextJavaBean(@NotNull ContextJavaBean contextJavaBean, @NotNull ProblemsHolder holder) {
        if (contextJavaBean == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(6);
        }
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getInitMethodAttributeElement());
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getDestroyMethodAttributeElement());
    }

    private static void checkMethodExists(ContextJavaBean contextJavaBean, ProblemsHolder holder, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        if (StringUtil.isNotEmpty((String)methodAttributeElement.getStringValue()) && methodAttributeElement.getValue() == null) {
            PsiAnnotationMemberValue memberValue = methodAttributeElement.getPsiElement();
            PsiAnnotationMemberValue psiElement = memberValue == null ? contextJavaBean.getPsiAnnotation() : memberValue;
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("ContextJavaBeanUnresolvedMethodsInspection.cannot.resolve.method", new Object[0]), new LocalQuickFix[]{ContextJavaBeanUnresolvedMethodsInspection.makeFix(contextJavaBean, methodAttributeElement)});
        }
    }

    private static LocalQuickFix makeFix(ContextJavaBean contextJavaBean, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        PsiClass clazz = PsiTypesUtil.getPsiClass((PsiType)contextJavaBean.getBeanType());
        if (clazz == null) {
            return null;
        }
        String methodName = methodAttributeElement.getStringValue();
        if (methodName == null) {
            return null;
        }
        return CreateMethodFix.createVoidMethodIfFixPossible((PsiClass)clazz, (String)methodName, (JvmModifier)JvmModifier.PRIVATE);
    }

    @Nullable
    private static ContextJavaBean getContextJavaBean(@NotNull UMethod uMethod, @NotNull Module module) {
        if (uMethod == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(8);
        }
        PsiMethod psi = uMethod.getPsi();
        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)module.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psi);
        return memberSpringBean instanceof ContextJavaBean ? (ContextJavaBean)memberSpringBean : null;
    }

    @NotNull
    public String getShortName() {
        if ("ContextJavaBeanUnresolvedMethodsInspection" == null) {
            ContextJavaBeanUnresolvedMethodsInspection.$$$reportNull$$$0(9);
        }
        return "ContextJavaBeanUnresolvedMethodsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextJavaBean";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkContextJavaBean";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextJavaBean";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

