/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringJavaAutowiredFieldsWarningInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiFile file;
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)(file = aClass.getContainingFile())) && !ProjectRootsUtil.isInTestSource((PsiFile)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (!SpringCommonUtils.hasSpringFacet((Module)module) && !SpringModelUtils.getInstance().hasAutoConfiguredModels(module)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringCommonUtils.isConfigurationOrMeta((PsiClass)aClass)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            if (!SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_4_3)) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            for (JamSpringBeanPointer pointer : SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)aClass).getStereotypeMappedBeans()) {
                if (!(pointer.getSpringBean() instanceof ContextJavaBean)) continue;
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            Set<String> annotations = SpringAutowireUtil.getAutowiredAnnotations(module);
            Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> autowiredFields = SpringJavaAutowiredFieldsWarningInspection.getAutowiredFields(aClass, annotations);
            LocalQuickFix allFieldsFix = null;
            if (autowiredFields.size() > 1) {
                allFieldsFix = SpringJavaAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, autowiredFields, annotations);
            }
            for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : autowiredFields) {
                LocalQuickFix[] localQuickFixArray;
                LocalQuickFix fieldFx = SpringJavaAutowiredFieldsWarningInspection.getFieldsAutowiredFix(aClass, Collections.singleton(pair), annotations);
                if (allFieldsFix != null) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                    localQuickFixArray2[0] = fieldFx;
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[1] = allFieldsFix;
                } else {
                    LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray3;
                    localQuickFixArray3[0] = fieldFx;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                PsiAnnotation psiAnnotation = (PsiAnnotation)((SmartPsiElementPointer)pair.getSecond()).getElement();
                if (psiAnnotation == null) continue;
                holder.registerProblem((PsiElement)psiAnnotation, SpringBundle.message("field.injection.is.not.recommended", new Object[0]), fixes);
            }
            return holder.getResultsArray();
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> getAutowiredFields(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(2);
        }
        if (annotations == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(3);
        }
        HashSet pairs = ContainerUtil.newHashSet();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)aClass.getProject());
        for (PsiField psiField : aClass.getFields()) {
            for (String autowiredAnno : annotations) {
                if (autowiredAnno.equals("javax.annotation.Resource")) continue;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, (String[])new String[]{autowiredAnno});
                if (annotation == null) continue;
                smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField);
                pairs.add(Pair.create((Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)psiField), (Object)smartPointerManager.createSmartPsiElementPointer((PsiElement)annotation)));
            }
        }
        return pairs;
    }

    private static LocalQuickFix getFieldsAutowiredFix(PsiClass aClass, Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> fields, Set<String> annotations) {
        PsiMethod constructor = SpringJavaAutowiredFieldsWarningInspection.findAutowiredConstructor(aClass, annotations);
        return constructor != null ? new AddParameterQuickFix(constructor, fields) : new CreateAutowiredConstructorQuickFix(aClass, fields);
    }

    @Nullable
    private static PsiMethod findAutowiredConstructor(@NotNull PsiClass aClass, @NotNull Set<String> annotations) {
        PsiMethod[] constructors;
        if (aClass == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(4);
        }
        if (annotations == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(5);
        }
        if ((constructors = aClass.getConstructors()).length == 1) {
            return constructors[0] instanceof LightElement ? null : constructors[0];
        }
        for (PsiMethod method : constructors) {
            if (method instanceof LightElement || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, annotations)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringJavaAutowiredFieldsWarningInspection" == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(6);
        }
        return "SpringJavaAutowiredFieldsWarningInspection";
    }

    private static void addParameters(Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates, PsiMethod constructor) {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)constructor.getProject()).getElementFactory();
        boolean hasAutowiredAnno = AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)constructor)));
        Map qualifierAnnotationClassNames = FactoryMap.createMap(module -> {
            List qualifierAnnotations = JamAnnotationTypeUtil.getInstance((Module)module).getQualifierAnnotationTypesWithChildren();
            return ContainerUtil.mapNotNull((Collection)qualifierAnnotations, PsiClass::getQualifiedName);
        });
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : myParameterCandidates) {
            PsiModifierList fieldModifierList;
            PsiCodeBlock body;
            PsiField field = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            PsiAnnotation annotation = (PsiAnnotation)((SmartPsiElementPointer)pair.second).getElement();
            if (field == null || annotation == null || !field.isValid() || !annotation.isValid()) continue;
            String name = field.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) {
                return;
            }
            PsiParameter parameter = elementFactory.createParameter(name, field.getType());
            PsiModifierList modifierList = parameter.getModifierList();
            if (modifierList != null) {
                for (PsiAnnotation qualifierAnno : SpringJavaAutowiredFieldsWarningInspection.getQualifierAnnotations(field, qualifierAnnotationClassNames)) {
                    modifierList.add((PsiElement)elementFactory.createAnnotationFromText(qualifierAnno.getText(), (PsiElement)modifierList));
                    qualifierAnno.delete();
                }
            }
            constructor.getParameterList().add((PsiElement)parameter);
            if (!hasAutowiredAnno) {
                constructor.getModifierList().addBefore((PsiElement)elementFactory.createAnnotationFromText(annotation.getText(), (PsiElement)constructor), constructor.getModifierList().getFirstChild());
                hasAutowiredAnno = true;
            }
            if ((body = constructor.getBody()) != null) {
                body.add((PsiElement)elementFactory.createStatementFromText("this." + name + " = " + name + ";", (PsiElement)constructor));
            }
            if ((fieldModifierList = field.getModifierList()) != null && !fieldModifierList.hasModifierProperty("final")) {
                fieldModifierList.setModifierProperty("final", true);
            }
            annotation.delete();
        }
    }

    private static PsiAnnotation[] getQualifierAnnotations(@NotNull PsiField first, Map<Module, List<String>> qualifierAnnotationClassNames) {
        Module module;
        if (first == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(7);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)first)) == null) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        List<String> annotations = qualifierAnnotationClassNames.get(module);
        List vs = ContainerUtil.mapNotNull(annotations, s -> {
            if (first == null) {
                SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(13);
            }
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)first, (String[])new String[]{s});
        });
        return vs.toArray(new PsiAnnotation[vs.size()]);
    }

    @NotNull
    private static String getConstructorName(@Nullable PsiMethod psiMethod, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        if (psiMethod != null) {
            sb.append(psiMethod.getName());
            sb.append("(");
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                sb.append(parameter.getType().getPresentableText());
                sb.append(",");
            }
            SpringJavaAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates, sb);
            sb.append(")");
        }
        String string = sb.toString();
        if (string == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getConstructorName(@Nullable String name, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(10);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append("(");
        SpringJavaAutowiredFieldsWarningInspection.addNewParameters(parameterCandidates, sb);
        sb.append(")");
        String string = sb.toString();
        if (string == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void addNewParameters(@NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> parameterCandidates, StringBuilder sb) {
        if (parameterCandidates == null) {
            SpringJavaAutowiredFieldsWarningInspection.$$$reportNull$$$0(12);
        }
        HashSet newParams = ContainerUtil.newHashSet();
        for (Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>> pair : parameterCandidates) {
            PsiField psiField = (PsiField)((SmartPsiElementPointer)pair.first).getElement();
            if (psiField == null) continue;
            newParams.add("<b>" + psiField.getType().getPresentableText() + "</b>");
        }
        sb.append(StringUtil.join((Collection)newParams, (String)","));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredFields";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAutowiredConstructor";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotations";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNewParameters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifierAnnotations$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddParameterQuickFix
    extends AutowiredConstructorQuickFix {
        private final SmartPsiElementPointer<PsiMethod> myConstructor;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;

        public AddParameterQuickFix(@NotNull PsiMethod constructor, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (constructor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(0);
            }
            if (pairs == null) {
                AddParameterQuickFix.$$$reportNull$$$0(1);
            }
            this.myConstructor = SmartPointerManager.getInstance((Project)constructor.getProject()).createSmartPsiElementPointer((PsiElement)constructor);
            this.myParameterCandidates = pairs;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.add.parameters", SpringJavaAutowiredFieldsWarningInspection.getConstructorName((PsiMethod)this.myConstructor.getElement(), (Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>>)this.myParameterCandidates));
            if (string == null) {
                AddParameterQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod constructor;
            if (project == null) {
                AddParameterQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddParameterQuickFix.$$$reportNull$$$0(4);
            }
            if ((constructor = (PsiMethod)this.myConstructor.getElement()) == null) {
                return;
            }
            SpringJavaAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$AddParameterQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CreateAutowiredConstructorQuickFix
    extends AutowiredConstructorQuickFix {
        private final SmartPsiElementPointer<PsiClass> myClass;
        private final Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> myParameterCandidates;
        private final String message;

        public CreateAutowiredConstructorQuickFix(PsiClass containingClass, @NotNull Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>> pairs) {
            if (pairs == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(0);
            }
            this.myClass = SmartPointerManager.getInstance((Project)containingClass.getProject()).createSmartPsiElementPointer((PsiElement)containingClass);
            this.myParameterCandidates = pairs;
            this.message = SpringJavaAutowiredFieldsWarningInspection.getConstructorName(containingClass.getName(), (Set<Pair<SmartPsiElementPointer<PsiField>, SmartPsiElementPointer<PsiAnnotation>>>)this.myParameterCandidates);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SpringBundle.message("field.injection.create.constructor.injection", this.message);
            if (string == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass containingClass;
            if (project == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                CreateAutowiredConstructorQuickFix.$$$reportNull$$$0(3);
            }
            if ((containingClass = (PsiClass)this.myClass.getElement()) == null) {
                return;
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod constructor = elementFactory.createConstructor();
            PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)"public", (boolean)true);
            SpringJavaAutowiredFieldsWarningInspection.addParameters(this.myParameterCandidates, constructor);
            containingClass.add((PsiElement)constructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$CreateAutowiredConstructorQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AutowiredConstructorQuickFix
    implements LocalQuickFix {
        private AutowiredConstructorQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("field.injection.warning", new Object[0]);
            if (string == null) {
                AutowiredConstructorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/jam/SpringJavaAutowiredFieldsWarningInspection$AutowiredConstructorQuickFix", "getFamilyName"));
        }
    }
}

