/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringJavaConfigInspectionBase;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringJavaConfigInconsistencyInspection
extends SpringJavaConfigInspectionBase {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        SpringJavaConfiguration configuration;
        if (module == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if ((configuration = this.getJavaConfiguration(aClass, module)) != null) {
            this.checkJavaConfiguration(configuration, module, holder);
        } else {
            for (PsiMethod psiMethod : aClass.getMethods()) {
                PsiAnnotation beanAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (boolean)true, (String[])new String[]{"org.springframework.config.java.annotation.Bean"});
                if (beanAnnotation == null) continue;
                holder.registerProblem((PsiElement)beanAnnotation, SpringBundle.message("java.config.bean.must.be.declared.inside.configuration", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    @Override
    protected void checkJavaConfiguration(SpringJavaConfiguration javaConfiguration, Module module, ProblemsHolder holder) {
        SpringJavaConfigInconsistencyInspection.checkJavaConfigurationClass(javaConfiguration, holder);
        for (SpringJavaBean springJavaBean : javaConfiguration.getBeans()) {
            SpringJavaConfigInconsistencyInspection.checkJavaBeanInconsistency(springJavaBean, holder);
        }
    }

    private static void checkJavaConfigurationClass(SpringJavaConfiguration configuration, ProblemsHolder holder) {
        PsiClass psiClass = configuration.getPsiElement();
        SpringJavaConfigInconsistencyInspection.checkConstructor(psiClass, configuration, holder);
        SpringJavaConfigInconsistencyInspection.checkNonFinal(configuration, holder, psiClass);
    }

    private static void checkNonFinal(SpringJavaConfiguration configuration, ProblemsHolder holder, PsiClass psiClass) {
        if (psiClass.hasModifierProperty("final")) {
            holder.registerProblem((PsiElement)configuration.getAnnotation(), SpringBundle.message("java.configuration.cannot.be.final", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkConstructor(PsiClass psiClass, SpringJavaConfiguration configuration, ProblemsHolder holder) {
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length != 0 && !SpringJavaConfigInconsistencyInspection.hasDefaultConstructor(constructors)) {
            holder.registerProblem((PsiElement)configuration.getAnnotation(), SpringBundle.message("java.configuration.must.have.default.constructor", new Object[0]), new LocalQuickFix[0]);
        }
        for (PsiMethod constructor : constructors) {
            if (!SpringJavaConfigInconsistencyInspection.isAutowired(constructor)) continue;
            holder.registerProblem((PsiElement)constructor.getNameIdentifier(), SpringBundle.message("java.configuration.autowired.constructor.param", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isAutowired(PsiMethod constructor) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)constructor)));
    }

    private static boolean hasDefaultConstructor(PsiMethod[] constructors) {
        for (PsiMethod constructor : constructors) {
            if (!constructor.hasModifierProperty("public") || constructor.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return false;
    }

    private static void checkJavaBeanInconsistency(@NotNull SpringJavaBean springJavaBean, ProblemsHolder holder) {
        if (springJavaBean == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(1);
        }
        SpringJavaConfigInconsistencyInspection.checkReturnType(springJavaBean, holder);
        SpringJavaConfigInconsistencyInspection.checkNonFinal(springJavaBean, holder);
        SpringJavaConfigInconsistencyInspection.checkNonPrivate(springJavaBean, holder);
        SpringJavaConfigInconsistencyInspection.checkNoArguments(springJavaBean, holder);
    }

    private static void checkNoArguments(@NotNull SpringJavaBean springJavaBean, ProblemsHolder holder) {
        if (springJavaBean == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (springJavaBean.getPsiElement().getParameterList().getParametersCount() > 0) {
            holder.registerProblem((PsiElement)springJavaBean.getPsiAnnotation(), SpringBundle.message("java.config.bean.method.cannot.has.arguments", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkNonPrivate(@NotNull SpringJavaBean springJavaBean, ProblemsHolder holder) {
        if (springJavaBean == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (springJavaBean.getPsiElement().getModifierList().hasExplicitModifier("private")) {
            holder.registerProblem((PsiElement)springJavaBean.getPsiAnnotation(), SpringBundle.message("java.config.bean.method.cannot.be.private", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkNonFinal(@NotNull SpringJavaBean springJavaBean, ProblemsHolder holder) {
        if (springJavaBean == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if (springJavaBean.getPsiElement().getModifierList().hasExplicitModifier("final")) {
            holder.registerProblem((PsiElement)springJavaBean.getPsiAnnotation(), SpringBundle.message("java.config.bean.method.cannot.be.final", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkReturnType(@NotNull SpringJavaBean springJavaBean, ProblemsHolder holder) {
        if (springJavaBean == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if (PsiType.VOID.equals((Object)springJavaBean.getPsiElement().getReturnType())) {
            holder.registerProblem((PsiElement)springJavaBean.getPsiAnnotation(), SpringBundle.message("java.config.bean.method.cannot.return.void", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringJavaConfigInconsistencyInspection" == null) {
            SpringJavaConfigInconsistencyInspection.$$$reportNull$$$0(6);
        }
        return "SpringJavaConfigInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springJavaBean";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/jam/SpringJavaConfigInconsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/jam/SpringJavaConfigInconsistencyInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaBeanInconsistency";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNoArguments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkNonPrivate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkNonFinal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnType";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

