/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.structure;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlTagTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.structure.SpringBeanTreeElement;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomElementNavigationProvider;
import com.intellij.util.xml.DomElementsNavigationManager;
import com.intellij.util.xml.DomFileElement;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringModelTreeElement
implements StructureViewTreeElement,
ItemPresentation {
    private final XmlFile myXmlFile;
    private final DomElementNavigationProvider myNavigationProvider;
    private final boolean myShowBeanStructure;

    public SpringModelTreeElement(XmlFile xmlFile, boolean showBeanStructure) {
        this(xmlFile, DomElementsNavigationManager.getManager((Project)xmlFile.getProject()).getDomElementsNavigateProvider(DomElementsNavigationManager.DEFAULT_PROVIDER_NAME), showBeanStructure);
    }

    public SpringModelTreeElement(XmlFile xmlFile, DomElementNavigationProvider navigationProvider, boolean showBeanStructure) {
        this.myXmlFile = xmlFile;
        this.myNavigationProvider = navigationProvider;
        this.myShowBeanStructure = showBeanStructure;
    }

    public Object getValue() {
        return this.myXmlFile;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        SpringModelTreeElement springModelTreeElement = this;
        if (springModelTreeElement == null) {
            SpringModelTreeElement.$$$reportNull$$$0(0);
        }
        return springModelTreeElement;
    }

    @NotNull
    public TreeElement[] getChildren() {
        LocalXmlModel springModel = this.getSpringModel();
        if (springModel == null) {
            if (EMPTY_ARRAY == null) {
                SpringModelTreeElement.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        DomFileElement fileElement = springModel.getRoot();
        if (fileElement == null) {
            if (EMPTY_ARRAY == null) {
                SpringModelTreeElement.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<SpringBeanTreeElement> treeElements = new ArrayList<SpringBeanTreeElement>();
        for (SpringBeanPointer pointer : springModel.getAllDomBeans()) {
            CommonSpringBean springBean = pointer.getSpringBean();
            if (!pointer.isValid() || !springBean.isValid() || !(springBean instanceof DomSpringBean)) continue;
            treeElements.add(new SpringBeanTreeElement((DomSpringBean)springBean, this.myNavigationProvider, this.myShowBeanStructure));
        }
        Beans beansElement = (Beans)fileElement.getRootElement();
        for (CustomBeanWrapper customBeanWrapper : beansElement.getCustomBeans()) {
            if (!customBeanWrapper.isDummy()) continue;
            treeElements.add((SpringBeanTreeElement)new XmlTagTreeElement(customBeanWrapper.getXmlTag()));
        }
        TreeElement[] treeElementArray = treeElements.toArray(new TreeElement[treeElements.size()]);
        if (treeElementArray == null) {
            SpringModelTreeElement.$$$reportNull$$$0(3);
        }
        return treeElementArray;
    }

    @Nullable
    private LocalXmlModel getSpringModel() {
        return SpringManager.getInstance((Project)this.myXmlFile.getProject()).getLocalSpringModel(this.myXmlFile);
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public String getPresentableText() {
        return SpringBundle.message("spring.beans", new Object[0]);
    }

    public String getLocationString() {
        return null;
    }

    public Icon getIcon(boolean open) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/model/structure/SpringModelTreeElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

