/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiFileProvider;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

public class SpringSpiRegistrationAnnotator
extends RelatedItemLineMarkerProvider {
    private static final NotNullFunction<IProperty, Collection<? extends PsiElement>> PROPERTY_CONVERTER = dom -> Collections.singleton(dom.getPsiElement());
    private static final NotNullFunction<IProperty, Collection<? extends GotoRelatedItem>> PROPERTY_RELATED_CONVERTER = dom -> GotoRelatedItem.createItems(Collections.singleton(dom.getPsiElement()), (String)"spring.factories");

    public String getId() {
        return "SpringSpiRegistrationAnnotator";
    }

    public String getName() {
        return "spring.factories registration (Code)";
    }

    @Nullable
    public Icon getIcon() {
        return SpringSpiFileProvider.ICON;
    }

    public void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(1);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(2);
        }
        if (result == null) {
            SpringSpiRegistrationAnnotator.$$$reportNull$$$0(3);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)element.getProject())) {
            return;
        }
        final UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)element, UClass.class);
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)uClass)) {
            return;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)uClass);
        if (module == null) {
            return;
        }
        PairProcessor findFirstProcessor = (property, aClass) -> !aClass.isEquivalentTo((PsiElement)uClass);
        final String clazzName = uClass.getName();
        boolean foundEntry = SpringSpiManager.getInstance((Module)module).processClassesListValues(false, clazzName, findFirstProcessor);
        if (!foundEntry) {
            NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringSpiFileProvider.ICON, PROPERTY_CONVERTER, PROPERTY_RELATED_CONVERTER).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends IProperty>>(){

                @NotNull
                protected Collection<? extends IProperty> compute() {
                    List mappedConfigKeys = ContainerUtil.newSmartList();
                    PairProcessor processor = (property, aClass) -> {
                        if (aClass.isEquivalentTo((PsiElement)uClass)) {
                            mappedConfigKeys.add(property);
                        }
                        return true;
                    };
                    SpringSpiManager.getInstance((Module)module).processClassesListValues(false, clazzName, processor);
                    List list = mappedConfigKeys;
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiRegistrationAnnotator$1", "compute"));
                }
            }).setPopupTitle("Choose Registration").setTooltipText("Navigate to Registration in spring.factories");
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)ObjectUtils.assertNotNull((Object)uClass.getNameIdentifier())));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/spi/SpringSpiRegistrationAnnotator";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

