/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.SpringBeanGraphPanelContent;
import com.intellij.spring.perspectives.diagrams.SpringDiagramDataModel;
import com.intellij.spring.perspectives.diagrams.SpringDiagramProvider;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPointerGraphPanelContent
implements SpringBeanPointerFinderRecursivePanel.SpringBeanPointerPanelContent {
    private final SpringBeanGraphPanelContent myDelegate = new SpringBeanGraphPanelContent();

    @Override
    public JComponent createComponent(FinderRecursivePanel panel, Disposable parent, NullableFactory<CommonSpringModel> factory, SpringBeanPointer pointer) {
        return this.myDelegate.createComponent(panel.getProject(), (UserDataHolder)panel, parent, SpringBeanPointerGraphPanelContent.getProvider(factory, pointer));
    }

    @Override
    public void update(FinderRecursivePanel panel) {
        this.myDelegate.update((UserDataHolder)panel);
    }

    @Override
    public Object getData(FinderRecursivePanel panel, @NonNls String dataId) {
        return this.myDelegate.getData((UserDataHolder)panel, dataId);
    }

    private static DiagramProvider getProvider(final NullableFactory<CommonSpringModel> factory, final SpringBeanPointer pointer) {
        return new SpringDiagramProvider(){

            @Override
            public DiagramEdgeCreationPolicy<SpringElementWrapper> getEdgeCreationPolicy() {
                return null;
            }

            @Override
            public DiagramDataModel<SpringElementWrapper> createDataModel(final @NotNull Project project, @Nullable SpringElementWrapper element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new SpringDiagramDataModel(project, this, null){
                    private DiagramNode<SpringElementWrapper> sourceNode;

                    @Override
                    protected void updateDataModel() {
                        if (!pointer.isValid() || DumbService.isDumb((Project)project)) {
                            return;
                        }
                        CommonSpringModel model = (CommonSpringModel)factory.create();
                        if (model == null) {
                            return;
                        }
                        this.sourceNode = this.getOrCreateElement(pointer);
                        if (this.sourceNode != null) {
                            Collection pointers = model.getAllCommonBeans();
                            THashSet pointerSet = new THashSet(pointers);
                            this.processDependencies(model, (Set<SpringBeanPointer>)pointerSet, pointer, this.sourceNode);
                        }
                    }

                    @Override
                    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
                        if (targetNode == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return super.isProcessed(targetNode) || !targetNode.equals(this.sourceNode);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetNode", "com/intellij/spring/toolWindow/panels/SpringBeanPointerGraphPanelContent$1$1", "isProcessed"));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/toolWindow/panels/SpringBeanPointerGraphPanelContent$1", "createDataModel"));
            }
        };
    }
}

