/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.TreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.JavaTreeHasher;
import com.intellij.dupLocator.treeView.DuplocatorPsiTreeView;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaSpecificHasher
extends NodeSpecificHasher {
    private final TreeHasher myTreeHasher;
    private final DuplocatorSettings mySettings;
    private final boolean myForIndexing;
    private final DuplocatorPsiTreeView myView;

    public JavaSpecificHasher(@NotNull DuplocatorSettings settings, @NotNull FragmentsCollector callback, boolean forIndexing) {
        if (settings == null) {
            JavaSpecificHasher.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaSpecificHasher.$$$reportNull$$$0(1);
        }
        this.myView = new DuplocatorPsiTreeView();
        this.mySettings = settings;
        this.myTreeHasher = new JavaTreeHasher(callback, settings, forIndexing);
        this.myForIndexing = forIndexing;
    }

    @Override
    public int getNodeCost(PsiElement node) {
        if (node instanceof PsiReturnStatement || node instanceof PsiExpressionStatement || node instanceof PsiParenthesizedExpression || node instanceof PsiCodeBlock || node instanceof PsiThisExpression || node instanceof PsiSuperExpression) {
            return 0;
        }
        if (node instanceof PsiExpression) {
            return 1;
        }
        if (node instanceof PsiStatement) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getNodeHash(PsiElement node) {
        if (node instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression expression = (PsiPolyadicExpression)node;
            return expression.getOperationTokenType().toString().hashCode();
        }
        if (node instanceof PsiPrefixExpression) {
            PsiPrefixExpression expression = (PsiPrefixExpression)node;
            return expression.getOperationTokenType().toString().hashCode();
        }
        if (node instanceof PsiPostfixExpression) {
            PsiPostfixExpression expression = (PsiPostfixExpression)node;
            return expression.getOperationTokenType().toString().hashCode();
        }
        if (node instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression expression = (PsiAssignmentExpression)node;
            return expression.getOperationTokenType().toString().hashCode();
        }
        if (node instanceof PsiLiteralExpression) {
            if (this.mySettings.DISTINGUISH_LITERALS) {
                return node.getText().hashCode();
            }
            return 0;
        }
        if (this.myForIndexing && node instanceof PsiJavaCodeReferenceElement) {
            String name;
            PsiElement parent = node.getParent();
            if (parent instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)parent).getMethodExpression() == node) {
                String name2;
                if (this.mySettings.DISTINGUISH_METHODS && (name2 = ((PsiJavaCodeReferenceElement)node).getReferenceName()) != null) {
                    return name2.hashCode();
                }
            } else if ((this.mySettings.DISTINGUISH_FIELDS || this.mySettings.DISTINGUISH_VARIABLES || parent instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent).getCheckType() == node || parent instanceof PsiNewExpression || parent instanceof PsiTypeCastExpression || ((PsiJavaCodeReferenceElement)node).getQualifier() instanceof PsiReferenceExpression) && (name = ((PsiJavaCodeReferenceElement)node).getReferenceName()) != null) {
                return name.hashCode();
            }
            return 0;
        }
        if (node instanceof PsiReferenceExpression) {
            if (!this.myForIndexing) {
                PsiElement var = ((PsiReferenceExpression)node).resolve();
                if (var instanceof PsiLocalVariable || var instanceof PsiParameter) {
                    return this.getVariableHash((PsiVariable)var);
                }
                if (var instanceof PsiMethod) {
                    return this.getMethodHash((PsiMethod)var);
                }
                if (var instanceof PsiField) {
                    return this.getFieldHash((PsiField)var);
                }
            }
        } else {
            if (node instanceof PsiLocalVariable || node instanceof PsiParameter) {
                return this.getVariableHash((PsiVariable)node);
            }
            if (node instanceof PsiField) {
                return this.getFieldHash((PsiField)node);
            }
            if (node instanceof PsiMethod) {
                return this.getMethodHash((PsiMethod)node);
            }
            if (node instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement lab = (PsiSwitchLabelStatement)node;
                if (lab.isDefaultCase()) {
                    return 0;
                }
                PsiExpression value = lab.getCaseValue();
                if (this.myForIndexing) {
                    return value != null ? value.getText().hashCode() : 0;
                }
                Object val = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value, (boolean)false);
                return val != null ? val.getClass().getName().hashCode() : 0;
            }
            if (node instanceof PsiIfStatement) {
                return 1;
            }
            if (node instanceof PsiInstanceOfExpression && this.myForIndexing) {
                return 1;
            }
        }
        return 0;
    }

    private int getFieldHash(PsiField psiField) {
        if (this.mySettings.DISTINGUISH_FIELDS) {
            return this.getVariableHash((PsiVariable)psiField);
        }
        return 0;
    }

    private int getVariableHash(PsiVariable var) {
        if (this.myForIndexing) {
            PsiTypeElement element = var.getTypeElement();
            if (element != null) {
                return element.getText().hashCode();
            }
            return 0;
        }
        if (this.mySettings.DISTINGUISH_VARIABLES) {
            String name = var.getName();
            return name.hashCode();
        }
        return 0;
    }

    private int getMethodHash(PsiMethod psiMethod) {
        if (this.mySettings.DISTINGUISH_METHODS) {
            return psiMethod.getName().hashCode();
        }
        return 0;
    }

    @Override
    public List<PsiElement> getNodeChildren(PsiElement node) {
        if (this.myForIndexing) {
            return Arrays.asList(node.getChildren());
        }
        return this.myView.getChildren(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            JavaSpecificHasher.$$$reportNull$$$0(2);
        }
        if (node2 == null) {
            JavaSpecificHasher.$$$reportNull$$$0(3);
        }
        if (!node1.getClass().equals(node2.getClass())) return false;
        if (node1 instanceof PsiExpression) {
            PsiElement element1 = node1.getParent();
            PsiElement element2 = node2.getParent();
            if (element1 instanceof PsiExpressionList && element2 instanceof PsiExpressionList && element1.getParent() instanceof PsiMethodCallExpression && element2.getParent() instanceof PsiMethodCallExpression) {
                return true;
            }
            if (!this.areTypesEqual(((PsiExpression)node1).getType(), ((PsiExpression)node2).getType())) {
                return false;
            }
        }
        if (node1 instanceof PsiPolyadicExpression) {
            if (((PsiPolyadicExpression)node1).getOperationTokenType() != ((PsiPolyadicExpression)node2).getOperationTokenType()) {
                return false;
            }
        } else if (node1 instanceof PsiPrefixExpression) {
            if (((PsiPrefixExpression)node1).getOperationTokenType() != ((PsiPrefixExpression)node2).getOperationTokenType()) {
                return false;
            }
        } else if (node1 instanceof PsiPostfixExpression) {
            if (((PsiPostfixExpression)node1).getOperationTokenType() != ((PsiPostfixExpression)node2).getOperationTokenType()) {
                return false;
            }
        } else if (node1 instanceof PsiAssignmentExpression) {
            if (((PsiAssignmentExpression)node1).getOperationTokenType() != ((PsiAssignmentExpression)node2).getOperationTokenType()) {
                return false;
            }
        } else if (node1 instanceof PsiTypeCastExpression) {
            PsiType typeY;
            PsiTypeElement typeCastX = ((PsiTypeCastExpression)node1).getCastType();
            PsiTypeElement typeCastY = ((PsiTypeCastExpression)node2).getCastType();
            PsiType typeX = typeCastX != null ? typeCastX.getType() : null;
            PsiType psiType = typeY = typeCastY != null ? typeCastY.getType() : null;
            if (typeX == null ? typeY != null : !typeX.equals(typeY)) {
                return false;
            }
        } else if (node1 instanceof PsiReferenceExpression) {
            PsiElement varX = ((PsiReferenceExpression)node1).resolve();
            PsiElement varY = ((PsiReferenceExpression)node2).resolve();
            if (varX instanceof PsiLocalVariable || varX instanceof PsiParameter) {
                if (varY instanceof PsiLocalVariable) return this.areVariablesEqual((PsiVariable)varX, (PsiVariable)varY);
                if (varY instanceof PsiParameter) {
                    return this.areVariablesEqual((PsiVariable)varX, (PsiVariable)varY);
                }
            }
            if (varX instanceof PsiMethod && varY instanceof PsiMethod) {
                return this.areMethodsEqual((PsiMethod)varX, (PsiMethod)varY);
            }
            if (varX instanceof PsiField && varY instanceof PsiField) {
                return this.areFieldsEqual((PsiField)varX, (PsiField)varY);
            }
            if (varX == null) {
                if (varY != null) return false;
                return true;
            }
            boolean bl = varX.equals(varY);
            return bl;
        }
        if (node1 instanceof PsiLiteralExpression) {
            if (!this.mySettings.DISTINGUISH_LITERALS) return true;
            if (node1.getText().equals(node2.getText())) return true;
            return false;
        }
        if (node1 instanceof PsiLocalVariable) return this.areVariablesEqual((PsiVariable)node1, (PsiVariable)node2);
        if (node1 instanceof PsiParameter) {
            return this.areVariablesEqual((PsiVariable)node1, (PsiVariable)node2);
        }
        if (node1 instanceof PsiField) {
            return this.areFieldsEqual((PsiField)node1, (PsiField)node2);
        }
        if (node1 instanceof PsiMethod) {
            return this.areMethodsEqual((PsiMethod)node1, (PsiMethod)node2);
        }
        if (!(node1 instanceof PsiSwitchLabelStatement)) return true;
        PsiSwitchLabelStatement labX = (PsiSwitchLabelStatement)node1;
        PsiSwitchLabelStatement labY = (PsiSwitchLabelStatement)node2;
        if (labX.isDefaultCase() != labY.isDefaultCase()) {
            return false;
        }
        Object valX = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)labX.getCaseValue(), (boolean)false);
        Object valY = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)labY.getCaseValue(), (boolean)false);
        if (valX == null) {
            if (valY != null) return false;
            return true;
        }
        boolean bl = valX.equals(valY);
        return bl;
    }

    @Override
    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        if (node1 instanceof PsiReferenceExpression && node2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression1 = (PsiReferenceExpression)node1;
            PsiReferenceExpression referenceExpression2 = (PsiReferenceExpression)node2;
            if (JavaSpecificHasher.checkDeep(referenceExpression1, referenceExpression2)) {
                return false;
            }
            if (JavaSpecificHasher.checkDeep(referenceExpression2, referenceExpression1)) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkDeep(PsiReferenceExpression referenceExpression1, PsiReferenceExpression referenceExpression2) {
        PsiElement resolved2;
        PsiElement resolved1 = referenceExpression1.resolve();
        if (resolved1 == (resolved2 = referenceExpression2.resolve())) {
            PsiType type2;
            PsiElement qualifier1 = referenceExpression1.getQualifier();
            PsiElement qualifier2 = referenceExpression2.getQualifier();
            if (qualifier1 == null && qualifier2 instanceof PsiReferenceExpression && (type2 = ((PsiReferenceExpression)qualifier2).getType()) instanceof PsiClassType && PsiTreeUtil.getParentOfType((PsiElement)referenceExpression1, PsiClass.class) == ((PsiClassType)type2).resolve()) {
                return true;
            }
        }
        return false;
    }

    private boolean areMethodsEqual(PsiMethod psiMethod, PsiMethod psiMethod1) {
        if (!this.areTypesEqual(psiMethod.getReturnType(), psiMethod1.getReturnType())) {
            return false;
        }
        PsiParameter[] params = psiMethod.getParameterList().getParameters();
        PsiParameter[] params1 = psiMethod1.getParameterList().getParameters();
        if (params1.length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (this.areVariablesEqual((PsiVariable)params[i], (PsiVariable)params1[i])) continue;
            return false;
        }
        if (this.mySettings.DISTINGUISH_METHODS) {
            return Comparing.strEqual((String)psiMethod.getName(), (String)psiMethod1.getName());
        }
        return true;
    }

    private boolean areFieldsEqual(PsiField psiField, PsiField psiField1) {
        if (!this.areTypesEqual(psiField.getType(), psiField1.getType())) {
            return false;
        }
        if (this.mySettings.DISTINGUISH_FIELDS) {
            return Comparing.strEqual((String)psiField.getName(), (String)psiField1.getName());
        }
        return true;
    }

    private boolean areVariablesEqual(PsiVariable psiVariable, PsiVariable psiVariable1) {
        if (!this.areTypesEqual(psiVariable.getType(), psiVariable1.getType())) {
            return false;
        }
        if (this.mySettings.DISTINGUISH_VARIABLES) {
            return Comparing.strEqual((String)psiVariable.getName(), (String)psiVariable1.getName());
        }
        return true;
    }

    private boolean areTypesEqual(PsiType typeX, PsiType typeY) {
        if (this.mySettings.DISTINGUISH_TYPES) {
            String canonicalTextX = typeX == null ? null : typeX.getCanonicalText();
            String canonicalTextY = typeY == null ? null : typeY.getCanonicalText();
            return Comparing.strEqual((String)canonicalTextX, (String)canonicalTextY);
        }
        return true;
    }

    @Override
    public void visitNode(@NotNull PsiElement node) {
        PsiFile psiFile;
        if (node == null) {
            JavaSpecificHasher.$$$reportNull$$$0(4);
        }
        if ((psiFile = node.getContainingFile().getViewProvider().getPsi((Language)JavaLanguage.INSTANCE)) instanceof PsiJavaFile) {
            PsiClass[] psiClasses;
            PsiJavaFile file = (PsiJavaFile)psiFile;
            for (PsiClass psiClass : psiClasses = file.getClasses()) {
                this.myTreeHasher.hash((PsiElement)psiClass, this);
            }
        }
    }

    @Override
    public void hashingFinished() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/treeHash/JavaSpecificHasher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesEqual";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

