/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFieldToAtomicIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToAtomicIntention.class);
    private final Map<PsiType, String> myFromToMap = ContainerUtil.newHashMap();

    public ConvertFieldToAtomicIntention() {
        this.myFromToMap.put((PsiType)PsiType.INT, AtomicInteger.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG, AtomicLong.class.getName());
        this.myFromToMap.put((PsiType)PsiType.BOOLEAN, AtomicBoolean.class.getName());
        this.myFromToMap.put((PsiType)PsiType.INT.createArrayType(), AtomicIntegerArray.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG.createArrayType(), AtomicLongArray.class.getName());
    }

    @NotNull
    public String getText() {
        if ("Convert to atomic" == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(0);
        }
        return "Convert to atomic";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        String qualifiedName;
        PsiVariable psiVariable;
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(3);
        }
        if ((psiVariable = this.getVariable(element)) == null || psiVariable instanceof PsiResourceVariable) {
            return false;
        }
        if (psiVariable.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiVariable.getTypeElement() == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiVariable)) {
            return false;
        }
        PsiType psiType = psiVariable.getType();
        PsiClass psiTypeClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiTypeClass != null ? (qualifiedName = psiTypeClass.getQualifiedName()) != null && (this.myFromToMap.values().contains(qualifiedName) || qualifiedName.equals(AtomicReference.class.getName()) || qualifiedName.equals(AtomicReferenceArray.class.getName())) : !this.myFromToMap.containsKey(psiType)) {
            return false;
        }
        return AllowedApiFilterExtension.isClassAllowed((String)AtomicReference.class.getName(), (PsiElement)element);
    }

    PsiVariable getVariable(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiIdentifier && ((parent = element.getParent()) instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return (PsiVariable)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiVariable var;
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(5);
        }
        LOG.assertTrue((var = this.getVariable(element)) != null);
        PsiType fromType = var.getType();
        PsiClassType toType = this.getMigrationTargetType(project, element, fromType);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{var})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer(var);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(var, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable(var, toTypeCanonicalText);
    }

    static void addExplicitInitializer(@NotNull PsiVariable var) {
        PsiExpression currentInitializer;
        if (var == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(6);
        }
        if ((currentInitializer = var.getInitializer()) != null) {
            return;
        }
        PsiType type = var.getType();
        String initializerText = null;
        if (PsiType.BOOLEAN.equals((Object)type)) {
            initializerText = "false";
        } else if (type instanceof PsiPrimitiveType) {
            initializerText = "0";
        }
        if (initializerText != null) {
            String finalInitializerText = initializerText;
            WriteAction.run(() -> {
                if (var == null) {
                    ConvertFieldToAtomicIntention.$$$reportNull$$$0(14);
                }
                PsiExpression initializer = JavaPsiFacade.getElementFactory((Project)var.getProject()).createExpressionFromText(finalInitializerText, (PsiElement)var);
                if (var instanceof PsiLocalVariable) {
                    ((PsiLocalVariable)var).setInitializer(initializer);
                } else if (var instanceof PsiField) {
                    ((PsiField)var).setInitializer(initializer);
                }
            });
        }
    }

    static void postProcessVariable(@NotNull PsiVariable var, @NotNull String toType) {
        if (var == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(7);
        }
        if (toType == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(8);
        }
        Project project = var.getProject();
        if (var instanceof PsiField || ((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS) {
            PsiModifierList modifierList = (PsiModifierList)ObjectUtils.assertNotNull((Object)var.getModifierList());
            WriteAction.run(() -> {
                if (var == null) {
                    ConvertFieldToAtomicIntention.$$$reportNull$$$0(12);
                }
                if (toType == null) {
                    ConvertFieldToAtomicIntention.$$$reportNull$$$0(13);
                }
                if (var.getInitializer() == null) {
                    PsiExpression newInitializer = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("new " + toType + "()", (PsiElement)var);
                    if (var instanceof PsiLocalVariable) {
                        ((PsiLocalVariable)var).setInitializer(newInitializer);
                    } else if (var instanceof PsiField) {
                        ((PsiField)var).setInitializer(newInitializer);
                    }
                    JavaCodeStyleManager.getInstance((Project)var.getProject()).shortenClassReferences((PsiElement)var.getInitializer());
                }
                modifierList.setModifierProperty("final", true);
                modifierList.setModifierProperty("volatile", false);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)var);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)var);
            });
        }
    }

    @Nullable
    private PsiClassType getMigrationTargetType(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiType fromType) {
        if (project == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(9);
        }
        if (element == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(10);
        }
        if (fromType == null) {
            ConvertFieldToAtomicIntention.$$$reportNull$$$0(11);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        String atomicQualifiedName = this.myFromToMap.get(fromType);
        if (atomicQualifiedName != null) {
            PsiClass atomicClass = psiFacade.findClass(atomicQualifiedName, GlobalSearchScope.allScope((Project)project));
            if (atomicClass == null) {
                return null;
            }
            return factory.createType(atomicClass);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass atomicReferenceArrayClass = psiFacade.findClass(AtomicReferenceArray.class.getName(), GlobalSearchScope.allScope((Project)project));
            if (atomicReferenceArrayClass == null) {
                return null;
            }
            HashMap substitutor = ContainerUtil.newHashMap();
            PsiTypeParameter[] typeParameters = atomicReferenceArrayClass.getTypeParameters();
            if (typeParameters.length == 1) {
                PsiType componentType = ((PsiArrayType)fromType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    componentType = ((PsiPrimitiveType)componentType).getBoxedType(element);
                }
                substitutor.put(typeParameters[0], componentType);
            }
            return factory.createType(atomicReferenceArrayClass, factory.createSubstitutor((Map)substitutor));
        }
        PsiClass atomicReferenceClass = psiFacade.findClass(AtomicReference.class.getName(), GlobalSearchScope.allScope((Project)project));
        if (atomicReferenceClass == null) {
            return null;
        }
        HashMap substitutor = ContainerUtil.newHashMap();
        PsiTypeParameter[] typeParameters = atomicReferenceClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type = fromType;
            if (type instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)fromType).getBoxedType(element);
            }
            substitutor.put(typeParameters[0], type);
        }
        return factory.createType(atomicReferenceClass, factory.createSubstitutor((Map)substitutor));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitInitializer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "postProcessVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationTargetType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postProcessVariable$1";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addExplicitInitializer$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConvertNonFinalLocalToAtomicFix
    extends ConvertFieldToAtomicIntention
    implements HighPriorityAction {
        private PsiElement myContext;

        public ConvertNonFinalLocalToAtomicFix(PsiElement context) {
            this.myContext = context;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ConvertNonFinalLocalToAtomicFix.$$$reportNull$$$0(1);
            }
            return this.myContext.isValid();
        }

        @Override
        PsiVariable getVariable(PsiElement element) {
            PsiReferenceExpression ref;
            if (this.myContext instanceof PsiReferenceExpression && this.myContext.isValid() && PsiUtil.isAccessedForWriting((PsiExpression)(ref = (PsiReferenceExpression)this.myContext))) {
                return (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiLocalVariable.class);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention$ConvertNonFinalLocalToAtomicFix";
            objectArray[2] = "isAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

