/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.UnsupportedPatternException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringToConstraintsTransformer {
    @NonNls
    private static final String REF = "ref";
    @NonNls
    private static final String REGEX = "regex";
    @NonNls
    private static final String REGEXW = "regexw";
    @NonNls
    private static final String EXPRTYPE = "exprtype";
    @NonNls
    private static final String FORMAL = "formal";
    @NonNls
    private static final String SCRIPT = "script";
    @NonNls
    private static final String CONTAINS = "contains";
    @NonNls
    private static final String WITHIN = "within";

    public static void transformCriteria(String criteria, MatchOptions options) {
        StringBuilder buf = new StringBuilder();
        StringBuilder miscBuffer = null;
        int anonymousTypedVarsCount = 0;
        boolean targetFound = false;
        int length = criteria.length();
        for (int index = 0; index < length; ++index) {
            char ch = criteria.charAt(index);
            if (index == 0 && ch == '[') {
                if (miscBuffer == null) {
                    miscBuffer = new StringBuilder();
                } else {
                    miscBuffer.setLength(0);
                }
                MatchVariableConstraint constraint = new MatchVariableConstraint();
                constraint.setName("__context__");
                index = StringToConstraintsTransformer.eatTypedVarCondition(0, criteria, miscBuffer, constraint);
                options.addVariableConstraint(constraint);
                if (index == length) break;
                ch = criteria.charAt(index);
            }
            if (ch == '\\' && index + 1 < length) {
                ch = criteria.charAt(++index);
            } else if (ch == '\'') {
                if (index + 1 < length && criteria.charAt(index + 1) == '\'') {
                    ++index;
                } else if (index + 2 < length && criteria.charAt(index + 2) == '\'') {
                    buf.append(ch);
                    buf.append(criteria.charAt(++index));
                    ch = criteria.charAt(++index);
                } else if (index + 3 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 3) == '\'') {
                    buf.append(ch);
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    ch = criteria.charAt(++index);
                } else if (index + 7 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 2) == 'u' && criteria.charAt(index + 7) == '\'') {
                    buf.append(ch);
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    buf.append(criteria.charAt(++index));
                    ch = criteria.charAt(++index);
                } else {
                    buf.append("$");
                    if (miscBuffer == null) {
                        miscBuffer = new StringBuilder();
                    } else {
                        miscBuffer.setLength(0);
                    }
                    ++index;
                    while (index < length && Character.isJavaIdentifierPart(ch = criteria.charAt(index))) {
                        miscBuffer.append(ch);
                        buf.append(ch);
                        ++index;
                    }
                    if (miscBuffer.length() == 0) {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.character", new Object[0]));
                    }
                    boolean anonymous = false;
                    if (miscBuffer.charAt(0) == '_') {
                        anonymous = true;
                        if (miscBuffer.length() == 1) {
                            miscBuffer.append(++anonymousTypedVarsCount);
                            buf.append(anonymousTypedVarsCount);
                        } else {
                            buf.deleteCharAt(buf.length() - miscBuffer.length());
                            miscBuffer.deleteCharAt(0);
                        }
                    }
                    buf.append("$");
                    String typedVar = miscBuffer.toString();
                    MatchVariableConstraint constraint = options.getVariableConstraint(typedVar);
                    boolean constraintCreated = false;
                    if (constraint == null) {
                        constraint = new MatchVariableConstraint();
                        constraint.setName(typedVar);
                        constraintCreated = true;
                    }
                    int savedIndex = index;
                    int minOccurs = 1;
                    int maxOccurs = 1;
                    boolean greedy = true;
                    if (index < length) {
                        if (ch == '+') {
                            maxOccurs = Integer.MAX_VALUE;
                            ++index;
                        } else if (ch == '?') {
                            minOccurs = 0;
                            ++index;
                        } else if (ch == '*') {
                            minOccurs = 0;
                            maxOccurs = Integer.MAX_VALUE;
                            ++index;
                        } else if (ch == '{') {
                            ++index;
                            minOccurs = 0;
                            while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                                minOccurs *= 10;
                                if ((minOccurs += ch - 48) < 0) {
                                    throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                }
                                ++index;
                            }
                            if (ch == ',') {
                                ++index;
                                maxOccurs = 0;
                                while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                                    maxOccurs *= 10;
                                    if ((maxOccurs += ch - 48) < 0) {
                                        throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                    }
                                    ++index;
                                }
                            } else {
                                maxOccurs = Integer.MAX_VALUE;
                            }
                            if (ch != '}') {
                                if (maxOccurs == Integer.MAX_VALUE) {
                                    throw new MalformedPatternException(SSRBundle.message("error.expected.brace1", new Object[0]));
                                }
                                throw new MalformedPatternException(SSRBundle.message("error.expected.brace2", new Object[0]));
                            }
                            ++index;
                        }
                        if (index < length && (ch = criteria.charAt(index)) == '?') {
                            greedy = false;
                            ++index;
                        }
                    }
                    if (constraintCreated) {
                        constraint.setMinCount(minOccurs);
                        constraint.setMaxCount(maxOccurs);
                        constraint.setGreedy(greedy);
                        constraint.setPartOfSearchResults(!anonymous);
                        if (targetFound && !anonymous) {
                            throw new MalformedPatternException(SSRBundle.message("error.only.one.target.allowed", new Object[0]));
                        }
                        targetFound = !anonymous;
                    } else if (savedIndex != index) {
                        throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                    }
                    if (index < length && criteria.charAt(index) == ':') {
                        if (++index >= length) {
                            throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
                        }
                        ch = criteria.charAt(index);
                        if (ch == ':') {
                            buf.append(ch);
                        } else {
                            if (!constraintCreated) {
                                throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                            }
                            index = StringToConstraintsTransformer.eatTypedVarCondition(index, criteria, miscBuffer, constraint);
                        }
                    }
                    if (constraintCreated) {
                        options.addVariableConstraint(constraint);
                    }
                    if (index == length) break;
                    --index;
                    continue;
                }
            }
            buf.append(ch);
        }
        options.setSearchPattern(buf.toString());
    }

    private static int eatTypedVarCondition(int index, String criteria, StringBuilder miscBuffer, MatchVariableConstraint constraint) {
        int length = criteria.length();
        char ch = criteria.charAt(index);
        if (ch == '+' || ch == '*') {
            switch (ch) {
                case '+': {
                    constraint.setStrictlyWithinHierarchy(true);
                    break;
                }
                case '*': {
                    constraint.setWithinHierarchy(true);
                }
            }
            if (++index >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index);
        }
        if (ch == '[') {
            miscBuffer.setLength(0);
            boolean quoted = false;
            while (++index < length) {
                ch = criteria.charAt(index);
                if (criteria.charAt(index - 1) != '\\') {
                    if (ch == '\"') {
                        quoted = !quoted;
                    } else if (ch == ']' && !quoted) break;
                }
                miscBuffer.append(ch);
            }
            if (quoted) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
            }
            if (ch != ']') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition.or.bracket", new Object[0]));
            }
            ++index;
            StringToConstraintsTransformer.parseCondition(constraint, miscBuffer.toString());
        } else {
            miscBuffer.setLength(0);
            index = StringToConstraintsTransformer.handleRegExp(index, criteria, miscBuffer, constraint);
        }
        return index;
    }

    private static int handleRegExp(int index, String criteria, StringBuilder miscBuffer, MatchVariableConstraint constraint) {
        char ch;
        char c = criteria.charAt(index - 1);
        int length = criteria.length();
        while (index < length && !Character.isWhitespace(ch = criteria.charAt(index))) {
            miscBuffer.append(ch);
            ++index;
        }
        if (miscBuffer.length() == 0) {
            if (c == ':') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(c)));
            }
            return index;
        }
        String regexp = miscBuffer.toString();
        if (constraint.getRegExp() != null && constraint.getRegExp().length() > 0 && !constraint.getRegExp().equals(regexp)) {
            throw new MalformedPatternException(SSRBundle.message("error.two.different.type.constraints", new Object[0]));
        }
        StringToConstraintsTransformer.checkRegex(regexp);
        constraint.setRegExp(regexp);
        return index;
    }

    private static void parseCondition(MatchVariableConstraint constraint, String condition) {
        int length = condition.length();
        StringBuilder text = new StringBuilder();
        boolean invert = false;
        boolean optionExpected = true;
        for (int i = 0; i < length; ++i) {
            char c = condition.charAt(i);
            if (Character.isWhitespace(c)) {
                if (text.length() == 0) continue;
                StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
                optionExpected = false;
                continue;
            }
            if (c == '(') {
                if (text.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.condition.name", new Object[0]));
                }
                String option = text.toString();
                text.setLength(0);
                int spaces = 0;
                while (++i < length && condition.charAt(i) == ' ') {
                    ++spaces;
                }
                --i;
                boolean quoted = false;
                boolean closed = false;
                while (++i < length) {
                    c = condition.charAt(i);
                    if (condition.charAt(i - 1) != '\\') {
                        if (c == '\"') {
                            quoted = !quoted;
                        } else if (c == ')' && !quoted) {
                            int j;
                            for (j = 1; j <= spaces && condition.charAt(i - j) == ' '; ++j) {
                            }
                            if (j - 1 == spaces) {
                                closed = true;
                                break;
                            }
                        }
                    }
                    text.append(c);
                }
                if (quoted) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
                }
                if (!closed) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", StringUtil.repeatSymbol((char)' ', (int)spaces) + ")"));
                }
                StringToConstraintsTransformer.handleOption(constraint, option, text.toString(), invert);
                text.setLength(0);
                invert = false;
                optionExpected = false;
                continue;
            }
            if (c == '&') {
                if (text.length() != 0) {
                    StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
                    optionExpected = false;
                }
                if (++i == length || condition.charAt(i) != '&' || optionExpected) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "&"));
                }
                text.setLength(0);
                invert = false;
                optionExpected = true;
                continue;
            }
            if (!optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "&&"));
            }
            if (c == '!') {
                if (text.length() != 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "!"));
                }
                invert = !invert;
                continue;
            }
            text.append(c);
        }
        if (text.length() != 0) {
            StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
        } else {
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "!"));
            }
            if (optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "&&"));
            }
        }
    }

    private static void handleOption(@NotNull MatchVariableConstraint constraint, @NotNull String option, @NotNull String argument, boolean invert) {
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(0);
        }
        if (option == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(2);
        }
        argument = argument.trim();
        if (option.equalsIgnoreCase(REF)) {
            constraint.setReference(true);
            constraint.setInvertReference(invert);
            if (argument.length() == 0 || argument.charAt(0) != '\'') {
                throw new MalformedPatternException(SSRBundle.message("error.reference.variable.name.expected", option));
            }
            constraint.setNameOfReferenceVar(argument.substring(1));
        } else if (option.equalsIgnoreCase(REGEX) || option.equalsIgnoreCase(REGEXW)) {
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setRegExp(argument);
            constraint.setInvertRegExp(invert);
            if (option.equalsIgnoreCase(REGEXW)) {
                constraint.setWholeWordsOnly(true);
            }
        } else if (option.equalsIgnoreCase(EXPRTYPE)) {
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setExprTypeWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setNameOfExprType(argument);
            constraint.setInvertExprType(invert);
        } else if (option.equalsIgnoreCase(FORMAL)) {
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.regular.expression.argument.expected", option));
            }
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setFormalArgTypeWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setNameOfFormalArgType(argument);
            constraint.setInvertFormalType(invert);
        } else if (option.equalsIgnoreCase(SCRIPT)) {
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.script.argument.expected", option));
            }
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option));
            }
            constraint.setScriptCodeConstraint(argument);
        } else if (option.equalsIgnoreCase(CONTAINS)) {
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.pattern.argument.expected", option));
            }
            constraint.setContainsConstraint(argument);
            constraint.setInvertContainsConstraint(invert);
        } else if (option.equalsIgnoreCase(WITHIN)) {
            if (!"__context__".equals(constraint.getName())) {
                throw new MalformedPatternException(SSRBundle.message("error.only.applicable.to.complete.match", option));
            }
            if (argument.length() == 0) {
                throw new MalformedPatternException(SSRBundle.message("error.pattern.argument.expected", option));
            }
            constraint.setWithinConstraint(argument);
            constraint.setInvertWithinConstraint(invert);
        } else {
            throw new UnsupportedPatternException(SSRBundle.message("option.is.not.recognized.error.message", option));
        }
    }

    private static void checkRegex(@NotNull String regex) {
        if (regex == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(3);
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", e.getMessage()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGEX;
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/StringToConstraintsTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRegex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

