/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WithinPredicate
extends MatchPredicate {
    private static final ThreadLocal<Set<String>> ourRecursionGuard = ThreadLocal.withInitial(() -> new HashSet());
    private final MatchOptions myMatchOptions;
    private final Matcher matcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WithinPredicate(String within, FileType fileType, Project project) {
        if (StringUtil.isQuotedString((String)within)) {
            this.myMatchOptions = new MatchOptions();
            this.myMatchOptions.setLooseMatching(true);
            this.myMatchOptions.setFileType(fileType);
            this.myMatchOptions.fillSearchCriteria(StringUtil.unquoteString((String)within));
            this.matcher = new Matcher(project, this.myMatchOptions);
        } else {
            Set<String> set = ourRecursionGuard.get();
            if (!set.add(within)) {
                throw new MalformedPatternException("Pattern recursively contained within itself");
            }
            try {
                Configuration configuration = ConfigurationManager.getInstance(project).findConfigurationByName(within);
                if (configuration == null) {
                    throw new MalformedPatternException("Configuration '" + within + "' not found");
                }
                this.myMatchOptions = configuration.getMatchOptions();
                this.matcher = new Matcher(project, this.myMatchOptions);
            }
            finally {
                set.remove(within);
                if (set.isEmpty()) {
                    ourRecursionGuard.remove();
                }
            }
        }
    }

    @Override
    public boolean match(PsiElement matchedNode, int start, int end, MatchContext context) {
        List<MatchResult> results = this.matcher.matchByDownUp(matchedNode, this.myMatchOptions);
        for (MatchResult result : results) {
            if (!PsiTreeUtil.isAncestor((PsiElement)result.getMatch(), (PsiElement)matchedNode, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

