/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;

public class Optimizer {
    static void applyDirectResolutionHorizontalChain(ConstraintWidgetContainer container, LinearSystem system, int numMatchConstraints, ConstraintWidget widget) {
        ConstraintWidget firstWidget = widget;
        int widgetSize = 0;
        int firstPosition = 0;
        ConstraintWidget previous = null;
        int count = 0;
        float totalWeights = 0.0f;
        while (widget != null) {
            ++count;
            if (widget.mHorizontalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widgetSize += widget.getWidth();
                widgetSize += widget.mLeft.mTarget != null ? widget.mLeft.getMargin() : 0;
                widgetSize += widget.mRight.mTarget != null ? widget.mRight.getMargin() : 0;
            } else {
                totalWeights += widget.mHorizontalWeight;
            }
            previous = widget;
            widget = widget.mRight.mTarget != null ? widget.mRight.mTarget.mOwner : null;
            if (widget == null || widget.mLeft.mTarget != null && (widget.mLeft.mTarget == null || widget.mLeft.mTarget.mOwner == previous)) continue;
            widget = null;
        }
        int lastPosition = 0;
        if (previous != null) {
            ConstraintWidget endTarget;
            int n = lastPosition = previous.mRight.mTarget != null ? previous.mRight.mTarget.mOwner.getX() : 0;
            if (previous.mRight.mTarget != null && (endTarget = previous.mRight.mTarget.mOwner) == container) {
                lastPosition = container.getRight();
            }
        }
        float total = lastPosition - firstPosition;
        float spreadSpace = total - (float)widgetSize;
        float split = spreadSpace / (float)(count + 1);
        widget = firstWidget;
        float currentPosition = 0.0f;
        if (numMatchConstraints == 0) {
            currentPosition = split;
        } else {
            split = spreadSpace / (float)numMatchConstraints;
        }
        while (widget != null) {
            int left = widget.mLeft.mTarget != null ? widget.mLeft.getMargin() : 0;
            int right = widget.mRight.mTarget != null ? widget.mRight.getMargin() : 0;
            system.addEquality(widget.mLeft.mSolverVariable, (int)((currentPosition += (float)left) + 0.5f));
            currentPosition = widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? (totalWeights == 0.0f ? (currentPosition += split - (float)left - (float)right) : (currentPosition += spreadSpace * widget.mHorizontalWeight / totalWeights - (float)left - (float)right)) : (currentPosition += (float)widget.getWidth());
            system.addEquality(widget.mRight.mSolverVariable, (int)(currentPosition + 0.5f));
            if (numMatchConstraints == 0) {
                currentPosition += split;
            }
            currentPosition += (float)right;
            previous = widget;
            ConstraintWidget constraintWidget = widget = widget.mRight.mTarget != null ? widget.mRight.mTarget.mOwner : null;
            if (widget != null && widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner != previous) {
                widget = null;
            }
            if (widget != container) continue;
            widget = null;
        }
    }

    static void applyDirectResolutionVerticalChain(ConstraintWidgetContainer container, LinearSystem system, int numMatchConstraints, ConstraintWidget widget) {
        ConstraintWidget firstWidget = widget;
        int widgetSize = 0;
        int firstPosition = 0;
        ConstraintWidget previous = null;
        int count = 0;
        float totalWeights = 0.0f;
        while (widget != null) {
            ++count;
            if (widget.mVerticalDimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widgetSize += widget.getHeight();
                widgetSize += widget.mTop.mTarget != null ? widget.mTop.getMargin() : 0;
                widgetSize += widget.mBottom.mTarget != null ? widget.mBottom.getMargin() : 0;
            } else {
                totalWeights += widget.mVerticalWeight;
            }
            previous = widget;
            widget = widget.mBottom.mTarget != null ? widget.mBottom.mTarget.mOwner : null;
            if (widget == null || widget.mTop.mTarget != null && (widget.mTop.mTarget == null || widget.mTop.mTarget.mOwner == previous)) continue;
            widget = null;
        }
        int lastPosition = 0;
        if (previous != null) {
            ConstraintWidget endTarget;
            int n = lastPosition = previous.mBottom.mTarget != null ? previous.mBottom.mTarget.mOwner.getX() : 0;
            if (previous.mBottom.mTarget != null && (endTarget = previous.mBottom.mTarget.mOwner) == container) {
                lastPosition = container.getBottom();
            }
        }
        float total = lastPosition - firstPosition;
        float spreadSpace = total - (float)widgetSize;
        float split = spreadSpace / (float)(count + 1);
        widget = firstWidget;
        float currentPosition = 0.0f;
        if (numMatchConstraints == 0) {
            currentPosition = split;
        } else {
            split = spreadSpace / (float)numMatchConstraints;
        }
        while (widget != null) {
            int top = widget.mTop.mTarget != null ? widget.mTop.getMargin() : 0;
            int bottom = widget.mBottom.mTarget != null ? widget.mBottom.getMargin() : 0;
            system.addEquality(widget.mTop.mSolverVariable, (int)((currentPosition += (float)top) + 0.5f));
            currentPosition = widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? (totalWeights == 0.0f ? (currentPosition += split - (float)top - (float)bottom) : (currentPosition += spreadSpace * widget.mVerticalWeight / totalWeights - (float)top - (float)bottom)) : (currentPosition += (float)widget.getHeight());
            system.addEquality(widget.mBottom.mSolverVariable, (int)(currentPosition + 0.5f));
            if (numMatchConstraints == 0) {
                currentPosition += split;
            }
            currentPosition += (float)bottom;
            previous = widget;
            ConstraintWidget constraintWidget = widget = widget.mBottom.mTarget != null ? widget.mBottom.mTarget.mOwner : null;
            if (widget != null && widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner != previous) {
                widget = null;
            }
            if (widget != container) continue;
            widget = null;
        }
    }

    static void checkHorizontalSimpleDependency(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (widget.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            widget.mHorizontalResolution = 1;
            return;
        }
        if (widget.mLeft.mTarget != null && widget.mRight.mTarget != null) {
            if (widget.mLeft.mTarget.mOwner == container && widget.mRight.mTarget.mOwner == container) {
                int left = 0;
                int right = 0;
                int leftMargin = widget.mLeft.getMargin();
                int rightMargin = widget.mRight.getMargin();
                if (container.mHorizontalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    left = leftMargin;
                    right = container.getWidth() - rightMargin;
                } else {
                    int w = widget.getWidth();
                    int dim = container.getWidth() - leftMargin - rightMargin - w;
                    left = leftMargin + (int)((float)dim * widget.mHorizontalBiasPercent + 0.5f);
                    right = left + widget.getWidth();
                }
                widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                system.addEquality(widget.mLeft.mSolverVariable, left);
                system.addEquality(widget.mRight.mSolverVariable, right);
                widget.mHorizontalResolution = 2;
                widget.setHorizontalDimension(left, right);
                return;
            }
            widget.mHorizontalResolution = 1;
            return;
        }
        if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner == container) {
            int left = widget.mLeft.getMargin();
            int right = left + widget.getWidth();
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner == container) {
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int right = container.getWidth() - widget.mRight.getMargin();
            int left = right - widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mLeft.mTarget != null && widget.mLeft.mTarget.mOwner.mHorizontalResolution == 2) {
            SolverVariable target = widget.mLeft.mTarget.mSolverVariable;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int left = (int)(target.computedValue + (float)widget.mLeft.getMargin() + 0.5f);
            int right = left + widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else if (widget.mRight.mTarget != null && widget.mRight.mTarget.mOwner.mHorizontalResolution == 2) {
            SolverVariable target = widget.mRight.mTarget.mSolverVariable;
            widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
            widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
            int right = (int)(target.computedValue - (float)widget.mRight.getMargin() + 0.5f);
            int left = right - widget.getWidth();
            system.addEquality(widget.mLeft.mSolverVariable, left);
            system.addEquality(widget.mRight.mSolverVariable, right);
            widget.mHorizontalResolution = 2;
            widget.setHorizontalDimension(left, right);
        } else {
            boolean hasRight;
            boolean hasLeft = widget.mLeft.mTarget != null;
            boolean bl = hasRight = widget.mRight.mTarget != null;
            if (!hasLeft && !hasRight) {
                if (widget instanceof Guideline) {
                    Guideline guideline = (Guideline)widget;
                    if (guideline.getOrientation() == 1) {
                        widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                        widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                        float position = 0.0f;
                        position = guideline.getRelativeBegin() != -1 ? (float)guideline.getRelativeBegin() : (guideline.getRelativeEnd() != -1 ? (float)(container.getWidth() - guideline.getRelativeEnd()) : (float)container.getWidth() * guideline.getRelativePercent());
                        int value = (int)(position + 0.5f);
                        system.addEquality(widget.mLeft.mSolverVariable, value);
                        system.addEquality(widget.mRight.mSolverVariable, value);
                        widget.mHorizontalResolution = 2;
                        widget.mVerticalResolution = 2;
                        widget.setHorizontalDimension(value, value);
                        widget.setVerticalDimension(0, container.getHeight());
                    }
                } else {
                    widget.mLeft.mSolverVariable = system.createObjectVariable(widget.mLeft);
                    widget.mRight.mSolverVariable = system.createObjectVariable(widget.mRight);
                    int left = widget.getX();
                    int right = left + widget.getWidth();
                    system.addEquality(widget.mLeft.mSolverVariable, left);
                    system.addEquality(widget.mRight.mSolverVariable, right);
                    widget.mHorizontalResolution = 2;
                }
            }
        }
    }

    static void checkVerticalSimpleDependency(ConstraintWidgetContainer container, LinearSystem system, ConstraintWidget widget) {
        if (widget.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
            widget.mVerticalResolution = 1;
            return;
        }
        if (widget.mTop.mTarget != null && widget.mBottom.mTarget != null) {
            if (widget.mTop.mTarget.mOwner == container && widget.mBottom.mTarget.mOwner == container) {
                int top = 0;
                int bottom = 0;
                int topMargin = widget.mTop.getMargin();
                int bottomMargin = widget.mBottom.getMargin();
                if (container.mVerticalDimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    top = topMargin;
                    bottom = top + widget.getHeight();
                } else {
                    int h = widget.getHeight();
                    int dim = container.getHeight() - topMargin - bottomMargin - h;
                    top = (int)((float)topMargin + (float)dim * widget.mVerticalBiasPercent + 0.5f);
                    bottom = top + widget.getHeight();
                }
                widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                system.addEquality(widget.mTop.mSolverVariable, top);
                system.addEquality(widget.mBottom.mSolverVariable, bottom);
                if (widget.mBaselineDistance > 0) {
                    widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                    system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
                }
                widget.mVerticalResolution = 2;
                widget.setVerticalDimension(top, bottom);
                return;
            }
            widget.mVerticalResolution = 1;
            return;
        }
        if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner == container) {
            int top = widget.mTop.getMargin();
            int bottom = top + widget.getHeight();
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner == container) {
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int bottom = container.getHeight() - widget.mBottom.getMargin();
            int top = bottom - widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mTop.mTarget != null && widget.mTop.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mTop.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = (int)(target.computedValue + (float)widget.mTop.getMargin() + 0.5f);
            int bottom = top + widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBottom.mTarget != null && widget.mBottom.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mBottom.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int bottom = (int)(target.computedValue - (float)widget.mBottom.getMargin() + 0.5f);
            int top = bottom - widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            if (widget.mBaselineDistance > 0) {
                widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            }
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else if (widget.mBaseline.mTarget != null && widget.mBaseline.mTarget.mOwner.mVerticalResolution == 2) {
            SolverVariable target = widget.mBaseline.mTarget.mSolverVariable;
            widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
            widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
            int top = (int)(target.computedValue - (float)widget.mBaselineDistance + 0.5f);
            int bottom = top + widget.getHeight();
            system.addEquality(widget.mTop.mSolverVariable, top);
            system.addEquality(widget.mBottom.mSolverVariable, bottom);
            widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
            system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
            widget.mVerticalResolution = 2;
            widget.setVerticalDimension(top, bottom);
        } else {
            boolean hasBottom;
            boolean hasBaseline = widget.mBaseline.mTarget != null;
            boolean hasTop = widget.mTop.mTarget != null;
            boolean bl = hasBottom = widget.mBottom.mTarget != null;
            if (!(hasBaseline || hasTop || hasBottom)) {
                if (widget instanceof Guideline) {
                    Guideline guideline = (Guideline)widget;
                    if (guideline.getOrientation() == 0) {
                        widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                        widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                        float position = 0.0f;
                        position = guideline.getRelativeBegin() != -1 ? (float)guideline.getRelativeBegin() : (guideline.getRelativeEnd() != -1 ? (float)(container.getHeight() - guideline.getRelativeEnd()) : (float)container.getHeight() * guideline.getRelativePercent());
                        int value = (int)(position + 0.5f);
                        system.addEquality(widget.mTop.mSolverVariable, value);
                        system.addEquality(widget.mBottom.mSolverVariable, value);
                        widget.mVerticalResolution = 2;
                        widget.mHorizontalResolution = 2;
                        widget.setVerticalDimension(value, value);
                        widget.setHorizontalDimension(0, container.getWidth());
                    }
                } else {
                    widget.mTop.mSolverVariable = system.createObjectVariable(widget.mTop);
                    widget.mBottom.mSolverVariable = system.createObjectVariable(widget.mBottom);
                    int top = widget.getY();
                    int bottom = top + widget.getHeight();
                    system.addEquality(widget.mTop.mSolverVariable, top);
                    system.addEquality(widget.mBottom.mSolverVariable, bottom);
                    if (widget.mBaselineDistance > 0) {
                        widget.mBaseline.mSolverVariable = system.createObjectVariable(widget.mBaseline);
                        system.addEquality(widget.mBaseline.mSolverVariable, top + widget.mBaselineDistance);
                    }
                    widget.mVerticalResolution = 2;
                }
            }
        }
    }
}

