/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ColorSet;
import com.android.tools.sherpa.drawing.SceneDraw;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.drawing.WidgetDraw;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class AnimatedHoverAnchor
extends Animation {
    private static final BasicStroke sStroke = new BasicStroke(4.0f);
    private static final BasicStroke sThinStroke = new BasicStroke(3.0f);
    private final ColorSet mColorSet;
    private ConstraintHandle mAnchor;
    private boolean mIsBaseline = false;
    private ConstraintAnchor mTargetAnchor;
    protected Color mColor = Color.white;
    private ConstraintAnchor mOriginalTarget;
    private Color mFrame;
    private boolean mShowTooltip = true;
    private long mStartTime;
    private final Ellipse2D.Float mCircle = new Ellipse2D.Float();
    private final Ellipse2D.Float mInnerCircle = new Ellipse2D.Float();

    public AnimatedHoverAnchor(ColorSet colorSet, ConstraintHandle anchor) {
        this.mAnchor = anchor;
        this.mColorSet = colorSet;
        this.mOriginalTarget = this.mAnchor.getAnchor().getTarget();
        this.mFrame = this.mColorSet.getAnchorCircle();
        if (this.mAnchor.getAnchor().isConnected()) {
            this.mFrame = this.mColor = this.mColorSet.getAnchorDisconnectionCircle();
            this.mTargetAnchor = this.mAnchor.getAnchor().getTarget();
        } else {
            this.mColor = this.mColorSet.getAnchorCreationCircle();
        }
        if (this.mAnchor.getAnchor().getType() == ConstraintAnchor.Type.BASELINE) {
            this.mIsBaseline = true;
        }
        this.setDuration(1200);
        this.setLoop(true);
        this.mStartTime = System.currentTimeMillis();
    }

    private String[] getText() {
        boolean isNewConnection;
        String[] text = new String[2];
        boolean bl = isNewConnection = this.mAnchor.getAnchor().getTarget() != null && this.mOriginalTarget != this.mAnchor.getAnchor().getTarget();
        if (!this.mAnchor.getAnchor().isConnected()) {
            text[0] = "Drag To Create";
        } else if (isNewConnection) {
            text[0] = "Release to Create";
        } else {
            text[0] = "Click To Delete";
            if (this.mAnchor.getAnchor().getConnectionCreator() == 2) {
                text[0] = text[0] + " Unlocked";
            }
        }
        switch (this.mAnchor.getAnchor().getType()) {
            case LEFT: {
                text[1] = "Left Constraint";
                break;
            }
            case RIGHT: {
                text[1] = "Right Constraint";
                break;
            }
            case TOP: {
                text[1] = "Top Constraint";
                break;
            }
            case BOTTOM: {
                text[1] = "Bottom Constraint";
                break;
            }
            case BASELINE: {
                text[1] = "Baseline Constraint";
            }
        }
        return text;
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        boolean newConnection;
        int x = transform.getSwingX(this.mAnchor.getDrawX());
        int y = transform.getSwingY(this.mAnchor.getDrawY());
        double progress = this.getProgress();
        int alpha = 255 - this.getPulsatingAlpha(progress);
        int anchorSize = (int)SceneDraw.getAnchorSize(transform.getScale());
        int radius = anchorSize + 4;
        boolean isNewConnection = this.mAnchor.getAnchor().getTarget() != null && this.mOriginalTarget != this.mAnchor.getAnchor().getTarget();
        Composite savedComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
        ConstraintWidget widget = this.mAnchor.getOwner();
        int l = transform.getSwingX(widget.getDrawX());
        int t = transform.getSwingY(widget.getDrawY());
        int w = transform.getSwingDimension(widget.getDrawWidth());
        if (this.mIsBaseline) {
            int extra = radius - 3;
            g.setColor(this.mColor);
            g.setStroke(sThinStroke);
            int handleWidth = this.mAnchor.getBaselineHandleWidth(transform);
            int padding = (w - handleWidth) / 2;
            g.drawRoundRect(l + padding, t + transform.getSwingDimension(widget.getBaselineDistance()) - extra / 2, handleWidth + 1, extra, radius, radius);
        } else {
            if (isNewConnection) {
                radius = anchorSize + 3;
            }
            this.mCircle.setFrame(x - radius, y - radius, radius * 2, radius * 2);
            g.setColor(this.mFrame);
            g.setStroke(isNewConnection ? sThinStroke : sStroke);
            g.draw(this.mCircle);
            if (isNewConnection) {
                g.setColor(this.mColorSet.getBackground());
                g.fill(this.mCircle);
                g.setColor(this.mColorSet.getAnchorConnectionCircle());
                this.mInnerCircle.setFrame(x - (radius -= 4), y - radius, radius * 2, radius * 2);
                g.fill(this.mInnerCircle);
                g.draw(this.mInnerCircle);
            } else {
                this.mCircle.setFrame(x - radius, y - radius, radius * 2, radius * 2);
                g.setColor(this.mColor);
            }
            g.draw(this.mCircle);
        }
        g.setComposite(savedComposite);
        if (!this.mColorSet.useTooltips()) {
            return;
        }
        boolean showTooltip = this.mShowTooltip;
        boolean bl = newConnection = this.mAnchor.getAnchor().getTarget() != this.mTargetAnchor;
        if ((showTooltip |= newConnection) && System.currentTimeMillis() - this.mStartTime > 800L) {
            WidgetDraw.drawTooltip(g, this.mColorSet, this.getText(), x, y, true);
        }
    }

    public void setShowTooltip(boolean showTooltip) {
        this.mShowTooltip = showTooltip;
    }
}

