/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.VtlCompositeElementType;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlRangeExpression;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.directives.VtlFileReferenceDirective;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlLiteralExpressionType
extends VtlCompositeElementType {
    private final String myTypeName;
    private final PsiPrimitiveType myPrimitiveType;

    public VtlLiteralExpressionType(@NotNull @NonNls String debugName, @NotNull String typeName) {
        if (debugName == null) {
            VtlLiteralExpressionType.$$$reportNull$$$0(0);
        }
        if (typeName == null) {
            VtlLiteralExpressionType.$$$reportNull$$$0(1);
        }
        super(debugName);
        this.myTypeName = typeName;
        this.myPrimitiveType = null;
    }

    public VtlLiteralExpressionType(@NotNull @NonNls String debugName, @NotNull PsiType primitiveType) {
        if (debugName == null) {
            VtlLiteralExpressionType.$$$reportNull$$$0(2);
        }
        if (primitiveType == null) {
            VtlLiteralExpressionType.$$$reportNull$$$0(3);
        }
        super(debugName);
        this.myTypeName = null;
        assert (primitiveType instanceof PsiPrimitiveType);
        this.myPrimitiveType = (PsiPrimitiveType)primitiveType;
    }

    @Override
    public PsiElement createPsiElement(ASTNode node) {
        return VtlCompositeElementTypes.STRING_LITERALS.contains((IElementType)this) ? new VtlStringLiteral(node) : new VtlLiteralExpression(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "debugName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "typeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "primitiveType";
                break;
            }
        }
        objectArray[1] = "com/intellij/velocity/psi/VtlLiteralExpressionType";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class VtlStringLiteral
    extends VtlLiteralExpression
    implements PsiLanguageInjectionHost {
        public VtlStringLiteral(ASTNode node) {
            if (node == null) {
                VtlStringLiteral.$$$reportNull$$$0(0);
            }
            super(node);
        }

        @NotNull
        public PsiReference[] getReferences() {
            if (this.isFileReference()) {
                FileReference[] fileReferenceArray = PsiUtil.getFileReferences(this.getValueText(), this, this.getFirstChild().getTextLength(), true);
                if (fileReferenceArray == null) {
                    VtlStringLiteral.$$$reportNull$$$0(1);
                }
                return fileReferenceArray;
            }
            if (this.isPropertyReference()) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new PropertyReference(this.getValueText(), (PsiElement)this, null, true)};
                if (psiReferenceArray == null) {
                    VtlStringLiteral.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                VtlStringLiteral.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private boolean isFileReference() {
            return this.isStringLiteralAndArgumentOf(VtlFileReferenceDirective.class);
        }

        private boolean isPropertyReference() {
            String valueText = this.getValueText();
            return !valueText.contains(" ");
        }

        private String getValueText() {
            String text = this.getText();
            return text.substring(1, text.length() - 1);
        }

        private boolean isStringLiteralAndArgumentOf(Class<? extends VtlDirective> directiveClass) {
            PsiElement parent = this.getParent();
            return parent instanceof VtlArgumentList && directiveClass.isInstance(parent.getParent());
        }

        @NotNull
        public TextRange getValueRange() {
            TextRange textRange = new TextRange(1, this.getText().length() - 1);
            if (textRange == null) {
                VtlStringLiteral.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        public VtlStringLiteral setStringValue(TextRange range, String newContent) {
            String oldText = this.getText();
            String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
            VtlStringLiteral newElement = PsiUtil.createStringLiteral(this.getProject(), newText);
            ASTNode newNode = newElement.getNode();
            this.getParent().getNode().replaceChild(this.getNode(), newNode);
            return (VtlStringLiteral)newNode.getPsi();
        }

        public boolean isValidHost() {
            return true;
        }

        public VtlStringLiteral updateText(@NotNull String text) {
            if (text == null) {
                VtlStringLiteral.$$$reportNull$$$0(5);
            }
            this.setStringValue(this.getValueRange(), text);
            return this;
        }

        @NotNull
        public LiteralTextEscaper<VtlStringLiteral> createLiteralTextEscaper() {
            StringLiteralEscaper stringLiteralEscaper = new StringLiteralEscaper((PsiLanguageInjectionHost)this);
            if (stringLiteralEscaper == null) {
                VtlStringLiteral.$$$reportNull$$$0(6);
            }
            return stringLiteralEscaper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlStringLiteral";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferences";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLiteralTextEscaper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class VtlLiteralExpression
    extends VtlCompositeElement
    implements VtlExpression {
        public VtlLiteralExpression(ASTNode node) {
            if (node == null) {
                VtlLiteralExpression.$$$reportNull$$$0(0);
            }
            super(node);
        }

        @Override
        public PsiType getPsiType() {
            VtlRangeExpression range;
            if (this.getNode().getElementType() == VtlCompositeElementTypes.LIST_EXPRESSION && (range = (VtlRangeExpression)this.findChildByClass(VtlRangeExpression.class)) != null) {
                return range.getPsiType();
            }
            if (VtlLiteralExpressionType.this.myPrimitiveType != null) {
                return VtlLiteralExpressionType.this.myPrimitiveType;
            }
            return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeByFQClassName(VtlLiteralExpressionType.this.myTypeName, this.getResolveScope());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/velocity/psi/VtlLiteralExpressionType$VtlLiteralExpression", "<init>"));
        }
    }
}

