/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlCompositeElement;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlExpressionTypeCalculator;
import com.intellij.velocity.psi.VtlOperatorTokenType;
import org.jetbrains.annotations.NotNull;

public class VtlOperatorExpression
extends VtlCompositeElement
implements VtlExpression {
    private final boolean myBinary;

    public VtlOperatorExpression(@NotNull ASTNode node, boolean binary) {
        if (node == null) {
            VtlOperatorExpression.$$$reportNull$$$0(0);
        }
        super(node);
        this.myBinary = binary;
    }

    @Override
    public PsiType getPsiType() {
        VtlExpressionTypeCalculator typeCalculator = this.getOperationSign().getTypeCalculator();
        VtlExpression operand1 = this.getOperand1();
        if (operand1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return typeCalculator.calculateUnary(operand1);
        }
        VtlExpression operand2 = this.getOperand2();
        if (operand2 == null) {
            return null;
        }
        return typeCalculator.calculateBinary(operand1, operand2);
    }

    @NotNull
    private VtlOperatorTokenType getOperationSign() {
        ASTNode operationNode = this.getNode().findChildByType(VtlElementTypes.OPERATIONS);
        assert (operationNode != null) : this.getText();
        IElementType tokenType = operationNode.getElementType();
        assert (tokenType instanceof VtlOperatorTokenType) : this.getText();
        VtlOperatorTokenType vtlOperatorTokenType = (VtlOperatorTokenType)tokenType;
        if (vtlOperatorTokenType == null) {
            VtlOperatorExpression.$$$reportNull$$$0(1);
        }
        return vtlOperatorTokenType;
    }

    private VtlExpression getOperand1() {
        return (VtlExpression)this.findChildByClass(VtlExpression.class);
    }

    private VtlExpression getOperand2() {
        PsiElement second;
        VtlExpression first = this.getOperand1();
        if (first == null) {
            return null;
        }
        for (second = first.getNextSibling(); second != null && !(second instanceof VtlExpression); second = second.getNextSibling()) {
        }
        return (VtlExpression)second;
    }

    public String getIndefiniteTypeMessage() {
        PsiType opType2;
        PsiType opType1;
        VtlExpression op1 = this.getOperand1();
        PsiType psiType = opType1 = op1 == null ? null : op1.getPsiType();
        if (opType1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return VelocityBundle.message("invalid.operand.type", PsiUtil.getPresentableText(opType1));
        }
        VtlExpression op2 = this.getOperand2();
        PsiType psiType2 = opType2 = op2 == null ? null : op2.getPsiType();
        if (opType2 == null) {
            return null;
        }
        return VelocityBundle.message("invalid.operands.type", PsiUtil.getPresentableText(opType1), PsiUtil.getPresentableText(opType2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/VtlOperatorExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/VtlOperatorExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

