/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.codeInspection.htmlInspections.HtmlLabelsHolder;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateLabelFromTextAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFormInputWithoutLabelInspection
extends HtmlLocalInspectionTool {
    private static final HashSet<String> ourNonlabelInputTypes = new HashSet<String>(Arrays.asList("hidden", "file", "image", "reset", "submit", "button"));
    private static final HashSet<String> ourInputElements = new HashSet<String>(Arrays.asList("input", "textarea", "select"));
    private static final String TITLE = "title";

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.form.input.without.label", (Object[])new Object[0]);
        if (string == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlFormInputWithoutLabel" == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(1);
        }
        return "HtmlFormInputWithoutLabel";
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(3);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        String tagName = tag.getName().toLowerCase();
        if (ourInputElements.contains(tagName)) {
            XmlAttribute title;
            String attrValue;
            XmlAttribute type;
            if ("input".equals(tagName) && (type = tag.getAttribute("type")) != null && (attrValue = type.getValue()) != null) {
                if (tag instanceof HtmlTag) {
                    attrValue = attrValue.toLowerCase();
                }
                if (ourNonlabelInputTypes.contains(attrValue)) {
                    return;
                }
            }
            if ((title = tag.getAttribute(TITLE)) != null) {
                return;
            }
            PsiFile file = tag.getContainingFile();
            if (file instanceof XmlFile) {
                PsiElement parent;
                HtmlLabelsHolder labelsHolder = HtmlLabelsHolder.getInstance((XmlFile)file);
                boolean hasLabel = false;
                for (XmlAttribute attribute : tag.getAttributes()) {
                    String id;
                    if (!attribute.getName().toLowerCase().equals("id") && !HtmlFormInputWithoutLabelInspection.isImplicitIdAttribute(attribute) || (id = attribute.getValue()) == null || !labelsHolder.hasForValue(id)) continue;
                    hasLabel = true;
                    break;
                }
                XmlTag child = tag;
                while (!hasLabel && (parent = child.getParent()) != null) {
                    if (parent instanceof XmlTag && "label".equals(((XmlTag)parent).getName().toLowerCase())) {
                        boolean anotherLabel = false;
                        for (PsiElement element : parent.getChildren()) {
                            if (element == child) break;
                            if (!(element instanceof XmlTag) || !"label".equals(((XmlTag)element).getName().toLowerCase())) continue;
                            anotherLabel = true;
                        }
                        hasLabel = !anotherLabel;
                    }
                    child = parent;
                }
                if (!hasLabel && tag.getAttribute("placeholder") == null) {
                    HtmlFormInputWithoutLabelInspection.registerProblem(tag, holder);
                }
            }
        }
    }

    private static boolean isImplicitIdAttribute(@NotNull XmlAttribute attribute) {
        XmlTag parent;
        if (attribute == null) {
            HtmlFormInputWithoutLabelInspection.$$$reportNull$$$0(4);
        }
        if ((parent = attribute.getParent()) != null) {
            return attribute.equals(IdRefReference.getImplicitIdRefAttr((XmlTag)parent));
        }
        return false;
    }

    @Nullable
    private static Pair<ProblemDescriptor, ProblemsHolder> registerProblem(XmlTag tag, ProblemsHolder holder) {
        if (InjectedLanguageManager.getInstance((Project)tag.getProject()).getInjectionHost((PsiElement)tag) != null) {
            return null;
        }
        ArrayList<Object> fixes = new ArrayList<Object>();
        Pair<PsiElement, PsiElement> pair = HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)tag, new ForwardIterator());
        if (pair != null) {
            fixes.add(new CreateLabelFromTextAction("html.inspections.create.label.from.text.after.action", false, tag.getName()));
        }
        if ((pair = HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)tag, new BackwardIterator())) != null) {
            fixes.add(new CreateLabelFromTextAction("html.inspections.create.label.from.text.before.action", true, tag.getName()));
        }
        fixes.add(new CreateNewLabelAction(tag.getName()));
        if (holder.isOnTheFly()) {
            fixes.add(new InsertRequiredAttributeFix(tag, TITLE, new String[0]){

                @NotNull
                public String getText() {
                    String string = MessageFormat.format("Insert ''{0}'' attribute (WCAG 2.0)", HtmlFormInputWithoutLabelInspection.TITLE);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection$1", "getText"));
                }
            });
        }
        XmlToken toRegister = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
        assert (toRegister != null);
        InspectionManager manager = holder.getManager();
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)toRegister, (PsiElement)toRegister, XmlBundle.message((String)"html.inspections.form.input.without.label", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly(), fixes.toArray(new LocalQuickFix[fixes.size()]));
        holder.registerProblem(descriptor);
        return Pair.create((Object)descriptor, (Object)holder);
    }

    @Nullable
    public static Pair<PsiElement, PsiElement> getNearestText(PsiElement element, ElementIterator iterator) {
        if ((element = iterator.getNext(element)) == null || !(element instanceof XmlText) || element.getChildren().length == 0) {
            return null;
        }
        element = iterator.getFirstChild(element);
        PsiElement first = null;
        PsiElement last = null;
        boolean textPassed = false;
        PsiElement current = element;
        while (current != null) {
            if (current instanceof PsiWhiteSpace && current.getText().contains("\n")) {
                if (textPassed) {
                    break;
                }
            } else if (!(current instanceof PsiComment)) {
                if (first == null) {
                    first = current;
                }
                last = current;
                textPassed = true;
            }
            current = iterator.getNext(current);
        }
        if (!textPassed) {
            return null;
        }
        return iterator.sortOrderedPair(first, last);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitIdAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BackwardIterator
    implements ElementIterator {
        @Override
        public PsiElement getNext(PsiElement element) {
            return element.getPrevSibling();
        }

        @Override
        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                BackwardIterator.$$$reportNull$$$0(0);
            }
            if (right == null) {
                BackwardIterator.$$$reportNull$$$0(1);
            }
            return Pair.create((Object)right, (Object)left);
        }

        @Override
        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                BackwardIterator.$$$reportNull$$$0(2);
            }
            return element.getLastChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection$BackwardIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortOrderedPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ForwardIterator
    implements ElementIterator {
        @Override
        public PsiElement getNext(PsiElement element) {
            return element.getNextSibling();
        }

        @Override
        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                ForwardIterator.$$$reportNull$$$0(0);
            }
            if (right == null) {
                ForwardIterator.$$$reportNull$$$0(1);
            }
            return Pair.create((Object)left, (Object)right);
        }

        @Override
        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            if (element == null) {
                ForwardIterator.$$$reportNull$$$0(2);
            }
            return element.getFirstChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlFormInputWithoutLabelInspection$ForwardIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortOrderedPair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstChild";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ElementIterator {
        @Nullable
        public PsiElement getNext(PsiElement var1);

        public Pair<PsiElement, PsiElement> sortOrderedPair(@NotNull PsiElement var1, @NotNull PsiElement var2);

        @Nullable
        public PsiElement getFirstChild(@NotNull PsiElement var1);
    }
}

