/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class SetJavaScriptEnabledDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("SetJavaScriptEnabled", "Using `setJavaScriptEnabled`", "Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", Category.SECURITY, 6, Severity.WARNING, new Implementation(SetJavaScriptEnabledDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/security.html");

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression call, UMethod method) {
        Object constant;
        List arguments = call.getValueArguments();
        if (arguments.size() == 1 && (constant = ConstantEvaluator.evaluate(context, (UElement)arguments.get(0))) != null && !Boolean.FALSE.equals(constant)) {
            context.report(ISSUE, (UElement)call, context.getUastLocation((UElement)call), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into you application, review carefully.");
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

