/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class WrongCallDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("WrongCall", "Using wrong draw/layout method", "Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", Category.CORRECTNESS, 6, Severity.FATAL, new Implementation(WrongCallDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    @Override
    public void visitMethod(JavaContext context, UastVisitor visitor, UCallExpression node, UMethod calledMethod) {
        String callName;
        UExpression operand2 = node.getReceiver();
        if (!(operand2 instanceof USuperExpression)) {
            WrongCallDetector.report(context, node, (PsiMethod)calledMethod);
            return;
        }
        PsiMethod method = (PsiMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method != null && (callName = node.getMethodName()) != null && !callName.equals(method.getName())) {
            WrongCallDetector.report(context, node, (PsiMethod)calledMethod);
        }
    }

    private static void report(JavaContext context, UCallExpression node, PsiMethod method) {
        if (!context.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
            return;
        }
        String name = method.getName();
        String suggestion = Character.toLowerCase(name.charAt(2)) + name.substring(3);
        String message = String.format("Suspicious method call; should probably call \"`%1$s`\" rather than \"`%2$s`\"", suggestion, name);
        context.report(ISSUE, (UElement)node, context.getUastNameLocation((UElement)node), message);
    }

    public static String getOldValue(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "than \"", "\"");
    }

    public static String getNewValue(String errorMessage, TextFormat format) {
        errorMessage = format.toText(errorMessage);
        return LintUtils.findSubstring(errorMessage, "call \"", "\"");
    }
}

