/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.JavaParser;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.File;
import java.util.List;
import java.util.Set;
import lombok.ast.Node;
import lombok.ast.Position;
import org.jetbrains.android.inspections.klint.IntellijLintClient;
import org.jetbrains.android.inspections.klint.IntellijLintUtils;
import org.jetbrains.uast.UastContext;

public class IdeaJavaParser
extends JavaParser {
    private final IntellijLintClient myClient;
    private final Project myProject;
    private final UastContext myContext;
    private final JavaEvaluator myEvaluator;

    public IdeaJavaParser(IntellijLintClient client, Project myProject) {
        this.myClient = client;
        this.myProject = myProject;
        this.myEvaluator = new MyJavaEvaluator(myProject);
        this.myContext = (UastContext)ServiceManager.getService((Project)myProject, UastContext.class);
    }

    @Override
    public UastContext getUastContext() {
        return this.myContext;
    }

    @Override
    public void prepareJavaParse(List<JavaContext> contexts) {
    }

    @Override
    public PsiJavaFile parseJavaToPsi(JavaContext context) {
        PsiFile psiFile = IntellijLintUtils.getPsiFile(context);
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        return (PsiJavaFile)psiFile;
    }

    @Override
    public JavaEvaluator getEvaluator() {
        return this.myEvaluator;
    }

    @Override
    public Project getIdeaProject() {
        return this.myProject;
    }

    @Override
    public Location getRangeLocation(JavaContext context, Node from, int fromDelta, Node to, int toDelta) {
        Position position1 = from.getPosition();
        Position position2 = to.getPosition();
        if (position1 == null) {
            return this.getLocation(context, to);
        }
        if (position2 == null) {
            return this.getLocation(context, from);
        }
        int start = Math.max(0, from.getPosition().getStart() + fromDelta);
        int end = to.getPosition().getEnd() + toDelta;
        return Location.create(context.file, null, start, end);
    }

    @Override
    public Location.Handle createLocationHandle(JavaContext context, Node node) {
        return new LocationHandle(context.file, node);
    }

    @Override
    public void runReadAction(Runnable runnable) {
        ApplicationManager.getApplication().runReadAction(runnable);
    }

    private static class MyJavaEvaluator
    extends JavaEvaluator {
        private final Project myProject;

        public MyJavaEvaluator(Project project) {
            this.myProject = project;
        }

        @Override
        public PsiClass findClass(String qualifiedName) {
            return JavaPsiFacade.getInstance((Project)this.myProject).findClass(qualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        }

        @Override
        public PsiClassType getClassType(PsiClass cls) {
            return cls != null ? JavaPsiFacade.getElementFactory((Project)this.myProject).createType(cls) : null;
        }

        @Override
        public PsiAnnotation[] getAllAnnotations(PsiModifierListOwner owner) {
            return AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)true, null, (boolean)true);
        }

        @Override
        public PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, String ... annotationNames) {
            return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])annotationNames));
        }

        @Override
        public PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])annotationNames);
        }

        @Override
        public File getFile(PsiFile file) {
            VirtualFile virtualFile = file.getVirtualFile();
            return virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : null;
        }
    }

    private class LocationHandle
    implements Location.Handle {
        private final File myFile;
        private final Node myNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.myFile = file;
            this.myNode = node;
        }

        @Override
        public Location resolve() {
            Position pos = this.myNode.getPosition();
            if (pos == null) {
                IdeaJavaParser.this.myClient.log(Severity.WARNING, null, "No position data found for node %1$s", this.myNode);
                return Location.create(this.myFile);
            }
            return Location.create(this.myFile, null, pos.getStart(), pos.getEnd());
        }

        @Override
        public void setClientData(Object clientData) {
            this.mClientData = clientData;
        }

        @Override
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

