/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.checks.BuiltinIssueRegistry;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.checks.ViewTypeDetector;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.android.inspections.klint.IntellijViewTypeDetector;

public class IntellijLintIssueRegistry
extends BuiltinIssueRegistry {
    private static final Implementation DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
    private static final String CUSTOM_EXPLANATION = "When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.";
    public static final Issue CUSTOM_WARNING = Issue.create("CustomWarning", "Warning from Custom Rule", "When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.", Category.CORRECTNESS, 5, Severity.WARNING, DUMMY_IMPLEMENTATION);
    public static final Issue CUSTOM_ERROR = Issue.create("CustomError", "Error from Custom Rule", "When custom (third-party) lint rules are integrated in the IDE, they are not available as native IDE inspections, so the explanation text (which must be statically registered by a plugin) is not available. As a workaround, run the lint target in Gradle instead; the HTML report will include full explanations.", Category.CORRECTNESS, 5, Severity.ERROR, DUMMY_IMPLEMENTATION);
    private static List<Issue> ourFilteredIssues;

    @Override
    public List<Issue> getIssues() {
        if (ourFilteredIssues == null) {
            List<Issue> sIssues = super.getIssues();
            ArrayList<Issue> result = new ArrayList<Issue>(sIssues.size());
            for (Issue issue : sIssues) {
                Implementation implementation = issue.getImplementation();
                EnumSet<Scope> scope = implementation.getScope();
                Class<? extends Detector> detectorClass = implementation.getDetectorClass();
                if (detectorClass != ApiDetector.class && detectorClass == ViewTypeDetector.class) {
                    issue.setImplementation(IntellijViewTypeDetector.IMPLEMENTATION);
                }
                if (detectorClass == SupportAnnotationDetector.class) continue;
                if (scope.contains((Object)Scope.CLASS_FILE) || scope.contains((Object)Scope.ALL_CLASS_FILES) || scope.contains((Object)Scope.JAVA_LIBRARIES)) {
                    boolean isOk = false;
                    for (EnumSet<Scope> analysisScope : implementation.getAnalysisScopes()) {
                        if (analysisScope.contains((Object)Scope.CLASS_FILE) || analysisScope.contains((Object)Scope.ALL_CLASS_FILES) || analysisScope.contains((Object)Scope.JAVA_LIBRARIES)) continue;
                        isOk = true;
                        break;
                    }
                    if (!isOk) continue;
                }
                result.add(issue);
            }
            ourFilteredIssues = result;
        }
        return ourFilteredIssues;
    }
}

