/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.klint;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.KtPsiUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0016J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J$\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010#\u001a\u00020\u000eH\u0016J\f\u0010$\u001a\u00020\u000e*\u00020%H\u0002J\f\u0010&\u001a\u00020\u000e*\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/android/inspections/klint/SuppressLintIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "id", "", "element", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getId", "()Ljava/lang/String;", "lintId", "addArgumentToAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "argument", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getLintId", "intentionId", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "startInWriteAction", "isNewLineNeededForAnnotation", "Lorg/jetbrains/kotlin/psi/KtElement;", "isSuppressLintTarget", "Companion", "lint-idea"})
public final class SuppressLintIntentionAction
implements IntentionAction,
Iconable {
    private final String lintId;
    @NotNull
    private final String id;
    @NotNull
    private final PsiElement element;
    @NotNull
    private static final String INTENTION_NAME_PREFIX = "AndroidKLint";
    @NotNull
    private static final String SUPPRESS_LINT_MESSAGE = "android.lint.fix.suppress.lint.api.annotation";
    @NotNull
    private static final FqName FQNAME_SUPPRESS_LINT;
    public static final Companion Companion;

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public String getText() {
        String string = AndroidBundle.message((String)Companion.getSUPPRESS_LINT_MESSAGE(), (Object[])new Object[]{this.lintId});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"AndroidBundle.message(SU\u2026ESS_LINT_MESSAGE, lintId)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!(file instanceof KtFile)) {
            return;
        }
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)this.element, (boolean)true, (Condition)((Condition)new Condition<PsiElement>(this){
            final /* synthetic */ SuppressLintIntentionAction this$0;

            public final boolean value(PsiElement it) {
                return SuppressLintIntentionAction.access$isSuppressLintTarget(this.this$0, it);
            }
            {
                this.this$0 = suppressLintIntentionAction;
            }
        }));
        if (psiElement == null) {
            return;
        }
        PsiElement annotationContainer2 = psiElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(annotationContainer2)) {
            return;
        }
        String argument = '\"' + this.lintId + '\"';
        PsiElement psiElement2 = annotationContainer2;
        if (psiElement2 instanceof KtModifierListOwner) {
            ModifierListModifactorKt.addAnnotation((KtModifierListOwner)((KtModifierListOwner)annotationContainer2), (FqName)Companion.getFQNAME_SUPPRESS_LINT(), (String)argument, (String)(this.isNewLineNeededForAnnotation((KtElement)annotationContainer2) ? "\n" : " "), (Function1)((Function1)new Function1<KtAnnotationEntry, Boolean>(this, argument){
                final /* synthetic */ SuppressLintIntentionAction this$0;
                final /* synthetic */ String $argument;

                public final boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                    return SuppressLintIntentionAction.access$addArgumentToAnnotation(this.this$0, entry, this.$argument);
                }
                {
                    this.this$0 = suppressLintIntentionAction;
                    this.$argument = string;
                    super(1);
                }
            }));
        }
    }

    private final boolean addArgumentToAnnotation(KtAnnotationEntry entry, String argument) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)entry), (boolean)false, (int)2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments('(' + argument + ')');
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            boolean bl;
            block8: {
                Iterable $receiver$iv = args.getArguments();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtValueArgument it = (KtValueArgument)element$iv;
                        if (!it.textMatches((CharSequence)argument)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
            }
        }
        return true;
    }

    private final String getLintId(String intentionId) {
        String string;
        if (StringsKt.startsWith$default((String)intentionId, (String)Companion.getINTENTION_NAME_PREFIX(), (boolean)false, (int)2, null)) {
            String string2 = intentionId;
            int n = Companion.getINTENTION_NAME_PREFIX().length();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = intentionId;
        }
        return string;
    }

    private final boolean isNewLineNeededForAnnotation(@NotNull KtElement $receiver) {
        return !($receiver instanceof KtParameter) && !($receiver instanceof KtTypeParameter) && !($receiver instanceof KtPropertyAccessor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuppressLintTarget(@NotNull PsiElement $receiver) {
        if (!($receiver instanceof KtDeclaration)) return false;
        PsiElement psiElement = $receiver;
        if (!(psiElement instanceof KtProperty)) {
            psiElement = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement;
        if (!(ktProperty != null ? KtPsiUtilKt.hasBackingField((KtProperty)ktProperty) : true)) return false;
        if ($receiver instanceof KtFunctionLiteral) return false;
        if ($receiver instanceof KtDestructuringDeclaration) return false;
        return true;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    public SuppressLintIntentionAction(@NotNull String id, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.id = id;
        this.element = element;
        this.lintId = this.getLintId(this.id);
    }

    static {
        Companion = new Companion(null);
        INTENTION_NAME_PREFIX = INTENTION_NAME_PREFIX;
        SUPPRESS_LINT_MESSAGE = SUPPRESS_LINT_MESSAGE;
        FQNAME_SUPPRESS_LINT = new FqName("android.annotation.SuppressLint");
    }

    public static final /* synthetic */ boolean access$isSuppressLintTarget(SuppressLintIntentionAction $this, @NotNull PsiElement $receiver) {
        return $this.isSuppressLintTarget($receiver);
    }

    public static final /* synthetic */ boolean access$addArgumentToAnnotation(SuppressLintIntentionAction $this, @NotNull KtAnnotationEntry entry, @NotNull String argument) {
        return $this.addArgumentToAnnotation(entry, argument);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/android/inspections/klint/SuppressLintIntentionAction$Companion;", "", "()V", "FQNAME_SUPPRESS_LINT", "Lorg/jetbrains/kotlin/name/FqName;", "getFQNAME_SUPPRESS_LINT", "()Lorg/jetbrains/kotlin/name/FqName;", "INTENTION_NAME_PREFIX", "", "getINTENTION_NAME_PREFIX", "()Ljava/lang/String;", "SUPPRESS_LINT_MESSAGE", "getSUPPRESS_LINT_MESSAGE", "lint-idea"})
    private static final class Companion {
        @NotNull
        public final String getINTENTION_NAME_PREFIX() {
            return INTENTION_NAME_PREFIX;
        }

        @NotNull
        public final String getSUPPRESS_LINT_MESSAGE() {
            return SUPPRESS_LINT_MESSAGE;
        }

        @NotNull
        public final FqName getFQNAME_SUPPRESS_LINT() {
            return FQNAME_SUPPRESS_LINT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

