/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.browse;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.css.util.CssConstants;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.browse.CssColorGutterRenderer;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.descriptor.value.CssColorValue;
import com.intellij.psi.css.impl.descriptor.value.CssInlineValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorLineMarkerProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CssColorAnnotator
implements Annotator {
    private static final String COLOR_DECLARATION = "color";

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        boolean annotateEveryTerm;
        WebEditorOptions webEditorOptions;
        if (psiElement == null) {
            CssColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CssColorAnnotator.$$$reportNull$$$0(1);
        }
        if ((webEditorOptions = WebEditorOptions.getInstance()) != null && webEditorOptions.isShowCssInlineColorPreview() && !LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)new ColorLineMarkerProvider())) {
            return;
        }
        CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)psiElement);
        boolean bl = annotateEveryTerm = descriptorProvider != null && descriptorProvider.isColorTermsSupported();
        if (psiElement instanceof CssTerm && annotateEveryTerm) {
            CssColorAnnotator.annotateTerm((CssTerm)psiElement, holder);
        } else if (psiElement instanceof CssFunction) {
            CssColorAnnotator.annotateFunction((CssFunction)psiElement, holder);
        } else if (!annotateEveryTerm && psiElement instanceof CssDeclaration) {
            CssColorAnnotator.annotateDeclaration((CssDeclaration)psiElement, holder);
        }
    }

    private static void annotateDeclaration(@NotNull CssDeclaration declaration, final @NotNull AnnotationHolder holder) {
        CssTermList value;
        if (declaration == null) {
            CssColorAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            CssColorAnnotator.$$$reportNull$$$0(3);
        }
        if ((value = declaration.getValue()) != null) {
            final HashSet annotatedTerms = ContainerUtil.newHashSet();
            Collection propertyDescriptors = declaration.getDescriptors();
            if (propertyDescriptors.isEmpty()) {
                CssTerm[] terms;
                if (declaration.getPropertyName().toLowerCase(Locale.US).contains(COLOR_DECLARATION) && (terms = (CssTerm[])PsiTreeUtil.getChildrenOfType((PsiElement)declaration.getValue(), CssTerm.class)) != null) {
                    for (CssTerm term : terms) {
                        CssColorAnnotator.annotateTerm(term, holder);
                    }
                }
                return;
            }
            for (CssPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                final CssValueMatchData matchData = value.matchWithValueDescriptor(propertyDescriptor.getValueDescriptor());
                value.acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                    public void visitCssTerm(CssTerm _term) {
                        if (!annotatedTerms.contains(_term)) {
                            for (CssValueDescriptor valueDescriptor = matchData.findDeepestDescriptorForElement((PsiElement)_term); valueDescriptor != null; valueDescriptor = valueDescriptor.getParent()) {
                                if (!(valueDescriptor instanceof CssColorValue) && (!(valueDescriptor instanceof CssInlineValue) || !CssColorAnnotator.COLOR_DECLARATION.equals(((CssInlineValue)valueDescriptor).getRefId())) && (!(valueDescriptor instanceof CssPropertyReferenceValue) || !((CssPropertyReferenceValue)valueDescriptor).getPropertyName().contains(CssColorAnnotator.COLOR_DECLARATION))) continue;
                                annotatedTerms.add(_term);
                                CssColorAnnotator.annotateTerm(_term, holder);
                                break;
                            }
                        }
                    }

                    public void visitCssElement(CssElement element) {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                });
            }
        }
    }

    private static void annotateFunction(@NotNull CssFunction function, @NotNull AnnotationHolder holder) {
        Color color;
        String functionName;
        if (function == null) {
            CssColorAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            CssColorAnnotator.$$$reportNull$$$0(5);
        }
        if (CssConstants.COLOR_FUNCTIONS.contains(functionName = function.getName()) && !CssPsiColorUtil.isInsideColorFunction((PsiElement)function) && (color = CssColorGutterRenderer.getColor((PsiElement)function)) != null) {
            CssColorAnnotator.annotate((PsiElement)function, color, holder);
        }
    }

    private static void annotateTerm(@NotNull CssTerm term, @NotNull AnnotationHolder holder) {
        if (term == null) {
            CssColorAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            CssColorAnnotator.$$$reportNull$$$0(7);
        }
        if (term.getFirstChild() instanceof CssFunction) {
            return;
        }
        if (CssPsiColorUtil.isColorTerm(term)) {
            String termText = term.getText();
            Color color = ColorMap.getColor((String)termText);
            if (color == null || termText.startsWith("#")) {
                color = CssColorGutterRenderer.getColor((PsiElement)term);
            }
            if (color != null) {
                CssColorAnnotator.annotate((PsiElement)term, color, holder);
            }
        }
    }

    private static void annotate(@NotNull PsiElement psiElement, @NotNull Color color, @NotNull AnnotationHolder holder) {
        WebEditorOptions webEditorOptions;
        if (psiElement == null) {
            CssColorAnnotator.$$$reportNull$$$0(8);
        }
        if (color == null) {
            CssColorAnnotator.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            CssColorAnnotator.$$$reportNull$$$0(10);
        }
        Annotation annotation = holder.createInfoAnnotation(psiElement, null);
        if (LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)new ColorLineMarkerProvider())) {
            annotation.setGutterIconRenderer((GutterIconRenderer)new CssColorGutterRenderer(psiElement));
        }
        if ((webEditorOptions = WebEditorOptions.getInstance()) != null && webEditorOptions.isShowCssInlineColorPreview()) {
            annotation.setTextAttributes(CssColorAnnotator.createTextAttributeKey(color));
        }
    }

    @NotNull
    private static TextAttributesKey createTextAttributeKey(@NotNull Color color) {
        if (color == null) {
            CssColorAnnotator.$$$reportNull$$$0(11);
        }
        TextAttributes attributes = new TextAttributes();
        Color background = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        Color mix = ColorUtil.mix((Color)background, (Color)color, (double)((double)color.getAlpha() / 255.0));
        attributes.setBackgroundColor(mix);
        attributes.setForegroundColor((Color)(ColorUtil.isDark((Color)mix.darker()) ? Gray._254 : Gray._1));
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)("CSS_COLOR_" + mix.hashCode()), (TextAttributes)attributes);
        if (textAttributesKey == null) {
            CssColorAnnotator.$$$reportNull$$$0(12);
        }
        return textAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = COLOR_DECLARATION;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/browse/CssColorAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/browse/CssColorAnnotator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextAttributeKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateDeclaration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotateFunction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateTerm";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTextAttributeKey";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

