/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;

public class XsltXmlAnnotator
extends XmlElementVisitor
implements Annotator {
    private AnnotationHolder myHolder;

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            XsltXmlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XsltXmlAnnotator.$$$reportNull$$$0(1);
        }
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        PsiElement parent = value.getParent();
        if (parent instanceof XmlAttribute) {
            boolean enumerated;
            List<Integer> singleBraces;
            if (!XsltSupport.isXsltFile(parent.getContainingFile())) {
                return;
            }
            String s = value.getValue();
            if (s == null || s.length() == 0) {
                if (XsltSupport.isXPathAttribute((XmlAttribute)parent)) {
                    InjectedLanguageUtil.enumerate((PsiElement)value, (injectedPsi, places) -> {
                        if (injectedPsi instanceof XPathFile && injectedPsi.getTextLength() == 0) {
                            this.myHolder.createErrorAnnotation((PsiElement)value, "Empty XPath expression");
                        }
                    });
                }
            } else if (XsltSupport.mayBeAVT((XmlAttribute)parent) && (singleBraces = XsltXmlAnnotator.collectClosingBraceOffsets(s)) != null && (enumerated = InjectedLanguageUtil.enumerate((PsiElement)value, (injectedPsi, places) -> {
                if (injectedPsi instanceof XPathFile) {
                    for (PsiLanguageInjectionHost.Shred place : places) {
                        TextRange range = place.getRangeInsideHost();
                        Iterator iterator = singleBraces.iterator();
                        while (iterator.hasNext()) {
                            Integer brace = (Integer)iterator.next();
                            if (!range.contains(brace.intValue())) continue;
                            iterator.remove();
                        }
                    }
                }
            }))) {
                for (Integer brace : singleBraces) {
                    this.myHolder.createErrorAnnotation(TextRange.from((int)(value.getTextOffset() + brace), (int)1), "Invalid single closing brace. Escape as '}}'");
                }
            }
        }
        super.visitXmlAttributeValue(value);
    }

    private static List<Integer> collectClosingBraceOffsets(String s) {
        SmartList singleBraces = null;
        int i = -1;
        while ((i = XsltXmlAnnotator.getAVTEndOffset(s, i)) != -1) {
            if (singleBraces == null) {
                singleBraces = new SmartList();
            }
            if (i != 0 && s.charAt(i - 1) == '{') continue;
            singleBraces.add(i);
        }
        return singleBraces;
    }

    public static int getAVTEndOffset(String value, int i) {
        while ((i = value.indexOf(125, i + 1)) != -1 && i == value.indexOf("}}", i) && (i += 2) != -1) {
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/xslt/validation/XsltXmlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

