/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facelets.taglibs;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.jsf.facelets.FaceletsManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.jsp.TaglibIndex;
import com.intellij.psi.impl.source.jsp.TldProcessorFactory;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.xml.index.IndexedRelevantResource;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaceletsTaglibProcessorFactory
extends TldProcessorFactory {
    private static final Key<CachedValue<JspManagerImpl.UriFactoryMap>> CACHED_VALUE_KEY = new Key("facelets uris");

    public boolean isProcessable(@Nullable JspFile context) {
        return context != null && FaceletsManager.isFaceletFile((PsiFile)context);
    }

    @NotNull
    @Nls
    public Key<CachedValue<JspManagerImpl.UriFactoryMap>> getKey() {
        Key<CachedValue<JspManagerImpl.UriFactoryMap>> key = CACHED_VALUE_KEY;
        if (key == null) {
            FaceletsTaglibProcessorFactory.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void processResources(List<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> resources) {
        ListIterator<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> it = resources.listIterator();
        while (it.hasNext()) {
            VirtualFile file;
            String location;
            IndexedRelevantResource resource = it.next();
            String wrappingClass = ((TaglibIndex.TaglibInfo)resource.getValue()).getWrappingClass();
            if (!StringUtil.isEmpty((String)wrappingClass) && !(location = ExternalResourceManager.getInstance().getResourceLocation(wrappingClass)).equals(wrappingClass) && (file = VfsUtil.findRelativeFile((String)location, null)) != null) {
                resource = new IndexedRelevantResource(file, resource.getKey(), resource.getValue(), resource.getRelevance());
                it.set((IndexedRelevantResource<String, TaglibIndex.TaglibInfo>)resource);
            }
            if (!TaglibIndex.isFaceletsTaglib((VirtualFile)resource.getFile()) || resources.size() <= 1) continue;
            it.remove();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/facelets/taglibs/FaceletsTaglibProcessorFactory", "getKey"));
    }
}

