/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jsf.references.JsfResourceIdentifierReferenceSet;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfResourceDirectoryReference
extends PsiPolyVariantReferenceBase
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    private static String subDirectoryName;
    private final JsfResourceIdentifierReferenceSet myReferenceSet;
    private final int myIndex;

    public JsfResourceDirectoryReference(JsfResourceIdentifierReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, set.isSoft());
        this.myReferenceSet = set;
        this.myIndex = index;
    }

    private Collection<PsiDirectory> getContext() {
        return this.myIndex == 0 ? this.myReferenceSet.getResourceLibraryDirectories() : this.getParentDirectories();
    }

    private List<PsiDirectory> getParentDirectories() {
        Object[] results = ((JsfResourceDirectoryReference)this.myReferenceSet.getReference(this.myIndex - 1)).multiResolve(false);
        return ContainerUtil.mapNotNull((Object[])results, resolveResult -> {
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiDirectory) {
                return (PsiDirectory)element;
            }
            return null;
        });
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        java.util.HashSet<String> added = new java.util.HashSet<String>();
        Collection<PsiDirectory> directories = this.getContext();
        for (PsiDirectory directory : directories) {
            for (PsiDirectory subDirectory : directory.getSubdirectories()) {
                if (added.contains(subDirectory.getName())) continue;
                variants.add(subDirectory);
                added.add(subDirectory.getName());
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            JsfResourceDirectoryReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = FacesBundle.message("cannot.resolve.library", new Object[0]);
        if (string == null) {
            JsfResourceDirectoryReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet resolvResultSet = new HashSet();
        Collection<PsiDirectory> parentDirectories = this.getContext();
        if (parentDirectories != null) {
            String name = this.getValue();
            for (PsiDirectory parentDirectory : parentDirectories) {
                if (this.myIndex == 0 && name.length() == 0) {
                    resolvResultSet.add(new PsiElementResolveResult((PsiElement)parentDirectory));
                    continue;
                }
                PsiDirectory psiDirectory = parentDirectory.findSubdirectory(name);
                if (psiDirectory == null) continue;
                resolvResultSet.add(new PsiElementResolveResult((PsiElement)psiDirectory));
            }
        }
        ResolveResult[] resolveResultArray = resolvResultSet.toArray(new ResolveResult[resolvResultSet.size()]);
        if (resolveResultArray == null) {
            JsfResourceDirectoryReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    public JsfResourceIdentifierReferenceSet getReferenceSet() {
        return this.myReferenceSet;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        Collection<PsiDirectory> context = this.getContext();
        for (PsiDirectory psiDirectory : context) {
            if (!psiDirectory.isWritable() || !psiDirectory.getVirtualFile().getFileSystem().isValidName(this.getValue())) continue;
            return new LocalQuickFix[]{JsfResourceDirectoryReference.createSubDirectoryLocalQuickFix(psiDirectory, this.getValue())};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    public static LocalQuickFix createSubDirectoryLocalQuickFix(PsiDirectory parentDirectory, @NotNull String value) {
        if (value == null) {
            JsfResourceDirectoryReference.$$$reportNull$$$0(3);
        }
        return new CreateSubDirectoryLocalQuickFix(parentDirectory, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/references/JsfResourceDirectoryReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/references/JsfResourceDirectoryReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSubDirectoryLocalQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateSubDirectoryLocalQuickFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiDirectory> myParentDirectory;
        private String mySubDirectoryName;

        public CreateSubDirectoryLocalQuickFix(PsiDirectory parentDirectory, String value) {
            this.myParentDirectory = SmartPointerManager.getInstance((Project)parentDirectory.getProject()).createSmartPsiElementPointer((PsiElement)parentDirectory);
            this.mySubDirectoryName = value;
        }

        @NotNull
        public String getName() {
            String string = FacesBundle.message("create.resource.directory", this.mySubDirectoryName);
            if (string == null) {
                CreateSubDirectoryLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = FacesBundle.message("jsf.relocatable.resources", new Object[0]);
            if (string == null) {
                CreateSubDirectoryLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            if (file == null) {
                CreateSubDirectoryLocalQuickFix.$$$reportNull$$$0(2);
            }
            return null;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiDirectory parentDirectoryElement;
            if (project == null) {
                CreateSubDirectoryLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                CreateSubDirectoryLocalQuickFix.$$$reportNull$$$0(4);
            }
            if ((parentDirectoryElement = (PsiDirectory)this.myParentDirectory.getElement()) != null && parentDirectoryElement.isValid()) {
                parentDirectoryElement.createSubdirectory(subDirectoryName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsf/references/JsfResourceDirectoryReference$CreateSubDirectoryLocalQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsf/references/JsfResourceDirectoryReference$CreateSubDirectoryLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

