/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JsfResourceNameReference<T extends PsiElement>
extends PsiPolyVariantReferenceBase
implements EmptyResolveMessageProvider {
    public JsfResourceNameReference(T psiElement) {
        super(psiElement);
    }

    public JsfResourceNameReference(PsiElement element, TextRange range, boolean soft) {
        super(element, range, soft);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Set<PsiFileSystemItem> items = this.getFileVariants();
        if (this.isCompleteSubDirectories()) {
            for (PsiDirectory psiDirectory : this.getLibraries()) {
                ContainerUtil.addAll(items, (Object[])psiDirectory.getSubdirectories());
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(items);
        if (objectArray == null) {
            JsfResourceNameReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    protected boolean isCompleteSubDirectories() {
        return true;
    }

    protected Set<PsiFileSystemItem> getFileVariants() {
        HashSet variants = new HashSet();
        HashSet addedItems = new HashSet();
        Set<PsiDirectory> directories = this.getLibraries();
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (addedItems.contains(file.getName())) continue;
                variants.add(file);
                addedItems.add(file.getName());
            }
        }
        return variants;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Set<PsiDirectory> libraries = this.getLibraries();
        String name = this.getValue();
        HashSet resolvResultSet = new HashSet();
        for (PsiDirectory psiDirectory : libraries) {
            PsiFile psiFile = psiDirectory.findFile(name);
            if (psiFile == null) continue;
            resolvResultSet.add(new PsiElementResolveResult((PsiElement)psiFile));
        }
        ResolveResult[] resolveResultArray = resolvResultSet.toArray(new ResolveResult[resolvResultSet.size()]);
        if (resolveResultArray == null) {
            JsfResourceNameReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = FacesBundle.message("cannot.find.library.name", new Object[0]);
        if (string == null) {
            JsfResourceNameReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public abstract Set<PsiDirectory> getLibraries();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/references/JsfResourceNameReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

