/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jsf.references.libraries.providers.ReferenceProviderCustomDataHolder;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiVariantsPsiReferenceProvider
extends PsiReferenceProvider
implements ReferenceProviderCustomDataHolder {
    private String myItems = null;

    protected Set<String> getAllVariants() {
        String items = this.getUserData();
        if (StringUtil.isEmptyOrSpaces((String)items)) {
            return Collections.emptySet();
        }
        HashSet map = new HashSet();
        for (String s : StringUtil.split((String)items, (String)",")) {
            String trimmed = s.trim();
            if (StringUtil.isEmpty((String)trimmed)) continue;
            map.add(trimmed);
        }
        return map;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            MultiVariantsPsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MultiVariantsPsiReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlElement) {
            PsiReference[] psiReferenceArray = new PsiReference[]{this.createReference((XmlElement)element)};
            if (psiReferenceArray == null) {
                MultiVariantsPsiReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            MultiVariantsPsiReferenceProvider.$$$reportNull$$$0(3);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    protected PsiReference createReference(@NotNull XmlElement element) {
        if (element == null) {
            MultiVariantsPsiReferenceProvider.$$$reportNull$$$0(4);
        }
        return new MultiVariantsReference(element);
    }

    @Override
    public String getUserData() {
        return this.myItems;
    }

    @Override
    public void putUserData(@Nullable String userData) {
        this.myItems = userData;
    }

    public String getUnresolvedMessagePattern(String value) {
        if (StringUtil.isEmptyOrSpaces((String)this.getUserData())) {
            return FacesBundle.message("value.format.exception", value);
        }
        return FacesBundle.message("value.must.be.one.of", this.getUserData());
    }

    public static String getProviderName() {
        return "variants";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MultiVariantsReference
    extends PsiReferenceBase<XmlElement>
    implements EmptyResolveMessageProvider {
        public MultiVariantsReference(XmlElement element) {
            if (element == null) {
                MultiVariantsReference.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = MultiVariantsPsiReferenceProvider.this.getUnresolvedMessagePattern(this.getValue());
            if (string == null) {
                MultiVariantsReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        public PsiElement resolve() {
            if (MultiVariantsPsiReferenceProvider.this.getAllVariants().contains(this.getValue())) {
                return this.getElement();
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            HashSet items = new HashSet();
            for (String entry : MultiVariantsPsiReferenceProvider.this.getAllVariants()) {
                items.add(LookupElementBuilder.create((String)entry));
            }
            Object[] objectArray = items.toArray(new LookupElementBuilder[items.size()]);
            if (objectArray == null) {
                MultiVariantsReference.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider$MultiVariantsReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsf/references/libraries/providers/MultiVariantsPsiReferenceProvider$MultiVariantsReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

