/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.actions;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.jsf.yfilesGraph.FacesBuildersFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.util.text.StringUtil;

public class OpenSelectedPagesActon
extends AbstractGraphAction {
    public OpenSelectedPagesActon() {
    }

    public OpenSelectedPagesActon(Graph2D graph) {
        super(graph);
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        FacesConfig facesConfig = OpenSelectedPagesActon.getFacesConfig(e);
        GraphBuilderImpl<String, NavigationCase> graphBuilder = OpenSelectedPagesActon.getGraphBuilder(e);
        if (facesConfig == null || graphBuilder == null) {
            return;
        }
        NodeCursor nc = graph.selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            String pageName = graphBuilder.getNodeName(node);
            JsfCommonUtils.navigate(facesConfig, pageName);
            nc.next();
        }
    }

    private static FacesConfig getFacesConfig(AnActionEvent e) {
        return (FacesConfig)e.getDataContext().getData(FacesBuildersFactory.FACES_CONFIG_KEY);
    }

    private static GraphBuilderImpl<String, NavigationCase> getGraphBuilder(AnActionEvent e) {
        return (GraphBuilderImpl)e.getDataContext().getData(FacesBuildersFactory.GRAPH_BUILDER_KEY);
    }

    public void update(AnActionEvent e, Graph2D graph) {
        FacesConfig facesConfig = OpenSelectedPagesActon.getFacesConfig(e);
        GraphBuilderImpl<String, NavigationCase> graphBuilder = OpenSelectedPagesActon.getGraphBuilder(e);
        if (facesConfig == null || graphBuilder == null) {
            return;
        }
        boolean enabled = false;
        NodeCursor nc = graph.selectedNodes();
        while (nc.ok()) {
            if (JsfCommonUtils.getFileByRelativePath(facesConfig, graphBuilder.getNodeName(nc.node())) != null) {
                enabled = true;
            }
            nc.next();
        }
        e.getPresentation().setEnabled(enabled);
        String s = FacesBundle.message("faces.graph.actions.open.selected.pages", new Object[0]);
        e.getPresentation().setText(graph.selectedNodes().size() == 1 ? s : StringUtil.pluralize((String)s));
    }
}

