/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.android.tools.idea.jps.model.JpsGradleModuleExtension;
import com.android.tools.idea.jps.model.impl.JpsAndroidGradleModuleExtensionImpl;
import com.android.tools.idea.jps.model.impl.JpsGradleModuleExtensionImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModule;

public final class AndroidGradleJps {
    @NonNls
    private static final String COMPILER_NAME = "Gradle";

    private AndroidGradleJps() {
    }

    @Nullable
    public static JpsAndroidGradleModuleExtension getFirstExtension(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            AndroidGradleJps.$$$reportNull$$$0(0);
        }
        for (JpsModule module : chunk.getModules()) {
            JpsAndroidGradleModuleExtension extension = AndroidGradleJps.getExtension(module);
            if (extension == null) continue;
            return extension;
        }
        return null;
    }

    public static boolean hasAndroidGradleFacet(@NotNull JpsProject project) {
        if (project == null) {
            AndroidGradleJps.$$$reportNull$$$0(1);
        }
        for (JpsModule module : project.getModules()) {
            if (AndroidGradleJps.getExtension(module) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JpsAndroidGradleModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            AndroidGradleJps.$$$reportNull$$$0(2);
        }
        return (JpsAndroidGradleModuleExtension)module.getContainer().getChild(JpsAndroidGradleModuleExtensionImpl.KIND);
    }

    @Nullable
    public static JpsGradleModuleExtension getOrCreateGradleSystemExtension(@NotNull JpsModule module) {
        JpsGradleModuleExtension extension;
        if (module == null) {
            AndroidGradleJps.$$$reportNull$$$0(3);
        }
        if ((extension = AndroidGradleJps.getGradleSystemExtension(module)) == null) {
            extension = new JpsGradleModuleExtensionImpl();
            module.getContainer().setChild(JpsGradleModuleExtensionImpl.ROLE, (JpsElement)extension);
        }
        return extension;
    }

    @Nullable
    public static JpsGradleModuleExtension getGradleSystemExtension(@NotNull JpsModule module) {
        if (module == null) {
            AndroidGradleJps.$$$reportNull$$$0(4);
        }
        return (JpsGradleModuleExtension)module.getContainer().getChild(JpsGradleModuleExtensionImpl.ROLE);
    }

    @Nullable
    public static JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> getFirstAndroidSdk(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            AndroidGradleJps.$$$reportNull$$$0(5);
        }
        for (JpsModule module : chunk.getModules()) {
            JpsSdk sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE);
            if (sdk == null) continue;
            return sdk;
        }
        return null;
    }

    @NotNull
    public static CompilerMessage createCompilerMessage(@NotNull BuildMessage.Kind kind, @NotNull String text) {
        if (kind == null) {
            AndroidGradleJps.$$$reportNull$$$0(6);
        }
        if (text == null) {
            AndroidGradleJps.$$$reportNull$$$0(7);
        }
        CompilerMessage compilerMessage = new CompilerMessage(COMPILER_NAME, kind, text);
        if (compilerMessage == null) {
            AndroidGradleJps.$$$reportNull$$$0(8);
        }
        return compilerMessage;
    }

    @NotNull
    public static List<CompilerMessage> createCompilerMessages(@NotNull Message message) {
        BuildMessage.Kind kind;
        if (message == null) {
            AndroidGradleJps.$$$reportNull$$$0(9);
        }
        switch (message.getKind()) {
            case INFO: {
                kind = BuildMessage.Kind.INFO;
                break;
            }
            case WARNING: {
                kind = BuildMessage.Kind.WARNING;
                break;
            }
            case ERROR: {
                kind = BuildMessage.Kind.ERROR;
                break;
            }
            default: {
                kind = BuildMessage.Kind.PROGRESS;
            }
        }
        ArrayList<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
        for (SourceFilePosition filePosition : message.getSourceFilePositions()) {
            File sourceFile = filePosition.getFile().getSourceFile();
            String sourceFilePath = sourceFile != null ? sourceFile.getAbsolutePath() : null;
            SourcePosition pos = filePosition.getPosition();
            compilerMessages.add(new CompilerMessage(COMPILER_NAME, kind, message.getText().trim(), sourceFilePath, (long)pos.getStartOffset(), (long)pos.getEndOffset(), (long)pos.getEndOffset(), (long)pos.getEndLine(), (long)pos.getEndColumn()));
        }
        List<CompilerMessage> list = Collections.unmodifiableList(compilerMessages);
        if (list == null) {
            AndroidGradleJps.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/jps/AndroidGradleJps";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/jps/AndroidGradleJps";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilerMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilerMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFirstExtension";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasAndroidGradleFacet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGradleSystemExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSystemExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFirstAndroidSdk";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerMessage";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCompilerMessages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

