/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlSuppressableInspection
extends LocalInspectionTool {
    private static final Pattern SUPPRESSION_PATTERN = Pattern.compile(".#--\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*\\s*--.");

    public boolean isSuppressedFor(@NotNull PsiElement place) {
        FtlCompositeElement ftlElement;
        if (place == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(0);
        }
        return (ftlElement = FtlSuppressableInspection.getTopmostFtlElement(place)) != null && FtlSuppressableInspection.getCommentFor((PsiElement)ftlElement, this.getID()) != null;
    }

    @Nullable
    static PsiComment getCommentFor(@NotNull PsiElement anchor, @NotNull String inspectionId) {
        Suppression suppression;
        if (anchor == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(1);
        }
        if (inspectionId == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(2);
        }
        return (suppression = FtlSuppressableInspection.getSuppressionFor(anchor)) != null && SuppressionUtil.isInspectionToolIdMentioned((String)suppression.suppressedIds, (String)inspectionId) ? suppression.comment : null;
    }

    @Nullable
    private static PsiElement findLeafOnPrevLine(@Nullable PsiElement ftlElement) {
        if (ftlElement == null) {
            return null;
        }
        int lineStart = FtlSuppressableInspection.getEolBefore(ftlElement);
        if (lineStart <= 0) {
            return null;
        }
        FileViewProvider provider = ftlElement.getContainingFile().getViewProvider();
        return provider.findElementAt(lineStart - 1, provider.getBaseLanguage());
    }

    @Nullable
    private static Suppression getSuppressionFor(@Nullable PsiElement ftlElement) {
        Matcher matcher;
        PsiElement anchor;
        for (anchor = FtlSuppressableInspection.findLeafOnPrevLine(ftlElement); anchor != null && StringUtil.isEmpty((String)anchor.getText().trim()); anchor = anchor.getPrevSibling()) {
        }
        if (anchor instanceof PsiComment && (matcher = SUPPRESSION_PATTERN.matcher(anchor.getText())).matches()) {
            return new Suppression((PsiComment)anchor, matcher.group(1), matcher.end(1));
        }
        return null;
    }

    private static int getEolBefore(PsiElement element) {
        return element.getContainingFile().getText().lastIndexOf(10, element.getTextRange().getStartOffset());
    }

    private static FtlCompositeElement getTopmostFtlElement(PsiElement place) {
        return (FtlCompositeElement)PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{FtlInterpolation.class, FtlXmlTag.class});
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (!SyntaxTraverser.psiApi().parents((Object)element).filter(e -> FtlDirectiveType.isDirective(e, "ftl")).isEmpty()) {
            if (SuppressQuickFix.EMPTY_ARRAY == null) {
                FtlSuppressableInspection.$$$reportNull$$$0(3);
            }
            return SuppressQuickFix.EMPTY_ARRAY;
        }
        final String id = HighlightDisplayKey.find((String)this.getShortName()).getID();
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new AbstractBatchSuppressByNoInspectionCommentFix(id, false){

            @NotNull
            protected Language getCommentLanguage(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                Language language = element.getContainingFile().getLanguage();
                if (language == null) {
                    1.$$$reportNull$$$0(1);
                }
                return language;
            }

            protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
                if (container == null) {
                    1.$$$reportNull$$$0(2);
                }
                return ContainerUtil.createMaybeSingletonList((Object)FtlSuppressableInspection.getCommentFor(container, FtlSuppressableInspection.this.getID()));
            }

            protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) {
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (container == null) {
                    1.$$$reportNull$$$0(5);
                }
                FtlSuppressableInspection.suppressForElement(container, id);
            }

            @NotNull
            public String getText() {
                if ("Suppress the inspection" == null) {
                    1.$$$reportNull$$$0(6);
                }
                return "Suppress the inspection";
            }

            @Nullable
            public PsiElement getContainer(PsiElement context) {
                return FtlSuppressableInspection.getTopmostFtlElement(context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/freemarker/inspections/FtlSuppressableInspection$1";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "container";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/freemarker/inspections/FtlSuppressableInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCommentLanguage";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCommentLanguage";
                        break;
                    }
                    case 1: 
                    case 6: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getCommentsFor";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createSuppression";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }};
        if (suppressQuickFixArray == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(4);
        }
        return suppressQuickFixArray;
    }

    static void suppressForElement(@NotNull PsiElement element, @NotNull String inspectionId) {
        if (element == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(5);
        }
        if (inspectionId == null) {
            FtlSuppressableInspection.$$$reportNull$$$0(6);
        }
        Project project = element.getProject();
        int lineStart = FtlSuppressableInspection.getEolBefore(element) + 1;
        PsiFile file = element.getContainingFile();
        String fileText = file.getText();
        String indent = fileText.substring(lineStart, CharArrayUtil.shiftForward((CharSequence)fileText, (int)lineStart, (String)" \t"));
        Document document = Objects.requireNonNull(file.getViewProvider().getDocument());
        Suppression suppression = FtlSuppressableInspection.getSuppressionFor(element);
        if (suppression != null) {
            document.insertString(suppression.idEnd, (CharSequence)("," + inspectionId));
            return;
        }
        String suppressionText = "noinspection " + inspectionId;
        PsiComment comment = SuppressionUtil.createComment((Project)project, (String)suppressionText, (Language)element.getContainingFile().getViewProvider().getBaseLanguage());
        document.insertString(lineStart, (CharSequence)(indent + comment.getText() + "\n"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionId";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlSuppressableInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlSuppressableInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommentFor";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suppressForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Suppression {
        final PsiComment comment;
        final String suppressedIds;
        final int idEnd;

        Suppression(PsiComment comment, String suppressedIds, int idEnd) {
            this.comment = comment;
            this.suppressedIds = suppressedIds;
            this.idEnd = idEnd + comment.getTextRange().getStartOffset();
        }
    }
}

