/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlFile
extends PsiFileBase {
    private static final Key<FtlFile> FOR_FILE = Key.create((String)"FOR_FILE");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.freemarker.psi.files.FtlFile");
    @NonNls
    public static final Pattern VAR_DECL_PATTERN = Pattern.compile(".#-- @ftlvariable name=\"(.*)\"[ \n\t]+type=\"([^\"]*)\"([ \n\t]+file=\"(.*)\")?([ \n\t]*)--.");
    private final CachedValue<Map<FtlFile, Map<String, FtlImplicitVariable>>> myTopLevelVars = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create(FtlFile.collectImplicitVariables((PsiElement)this), (Object[])new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT}), false);
    private final CachedValue<List<FtlVariable>> myGlobalVars = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
        ArrayList<? extends FtlVariable> result = new ArrayList<FtlVariable>();
        for (FtlGlobalVariableProvider provider : (FtlGlobalVariableProvider[])Extensions.getExtensions(FtlGlobalVariableProvider.EP_NAME)) {
            result.addAll(provider.getGlobalVariables(this));
        }
        return CachedValueProvider.Result.create(result, (Object[])new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT});
    }, false);
    private PsiElement myContext;

    public FtlFile(FileViewProvider viewProvider) {
        super(viewProvider, (Language)FtlLanguage.INSTANCE);
    }

    public static Map<FtlFile, Map<String, FtlImplicitVariable>> collectImplicitVariables(PsiElement scope) {
        HashMap result = new HashMap();
        scope.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)result){
            final /* synthetic */ Map val$result;
            {
                this.val$result = map;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof FtlSignatureDirective) {
                    return;
                }
                super.visitElement(element);
            }

            public void visitComment(PsiComment comment) {
                String[] varNames;
                String text = comment.getText();
                Matcher matcher = VAR_DECL_PATTERN.matcher(text);
                if (matcher.matches() && (varNames = FtlPsiUtil.splitVarNames(matcher.group(1), comment.getProject())) != null) {
                    FtlFile scopeFile = FtlFile.getScopeFile(comment);
                    if (scopeFile == null && text.contains("file=\"")) {
                        return;
                    }
                    Map map = (Map)ContainerUtil.getOrCreate((Map)this.val$result, (Object)((Object)scopeFile), () -> new THashMap());
                    FtlImplicitVariable var = (FtlImplicitVariable)ContainerUtil.getOrCreate((Map)map, (Object)varNames[0], () -> new FtlImplicitVariable(comment, varNames[0], scopeFile));
                    map.put(varNames[0], var);
                    for (int i = 1; i < varNames.length; ++i) {
                        var = var.addSubVariable(varNames[i]);
                    }
                    var.addType(matcher.group(2));
                }
            }
        });
        return result;
    }

    @NotNull
    public FileType getFileType() {
        FtlFileType ftlFileType = FtlFileType.INSTANCE;
        if (ftlFileType == null) {
            FtlFile.$$$reportNull$$$0(0);
        }
        return ftlFileType;
    }

    public boolean isImplicitlyIncluded() {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcImplicitlyIncluded(), (Object[])new Object[]{this}));
    }

    private boolean calcImplicitlyIncluded() {
        String prefix;
        int length = "[#ftl]\n[#-- @implicitly included --]\n".length();
        return this.getTextLength() >= length && ("[#ftl]\n[#-- @implicitly included --]\n".equals(prefix = this.getText().substring(0, length)) || "<#ftl>\n<#-- @implicitly included -->\n".equals(prefix));
    }

    @Nullable
    private static FtlFile getScopeFile(PsiComment comment) {
        for (FileReference reference : FtlReferenceContributor.getFileReferences((PsiElement)comment)) {
            PsiFileSystemItem element = reference.resolve();
            if (!(element instanceof FtlFile)) continue;
            return (FtlFile)element;
        }
        return null;
    }

    @NonNls
    public String toString() {
        return "FtlFile:" + this.getName();
    }

    @NotNull
    public FtlXmlRootTag getRootTag() {
        FtlXmlRootTag tag = (FtlXmlRootTag)((Object)this.findChildByClass(FtlXmlRootTag.class));
        LOG.assertTrue(tag != null, (Object)"Shit happened");
        FtlXmlRootTag ftlXmlRootTag = tag;
        if (ftlXmlRootTag == null) {
            FtlFile.$$$reportNull$$$0(1);
        }
        return ftlXmlRootTag;
    }

    public Collection<FtlImplicitVariable> getTopLevelFtlVariables(@Nullable FtlFile file) {
        Map map = (Map)((Map)this.myTopLevelVars.getValue()).get((Object)file);
        return map == null ? Collections.emptyList() : map.values();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlFile.$$$reportNull$$$0(2);
        }
        if (state == null) {
            FtlFile.$$$reportNull$$$0(3);
        }
        if (place == null) {
            FtlFile.$$$reportNull$$$0(4);
        }
        return !Boolean.FALSE.equals(FtlFileReferenceDirective.FILE_RECURSION_GUARD.doPreventingRecursion((Object)this, false, () -> {
            if (processor == null) {
                FtlFile.$$$reportNull$$$0(8);
            }
            if (state == null) {
                FtlFile.$$$reportNull$$$0(9);
            }
            if (place == null) {
                FtlFile.$$$reportNull$$$0(10);
            }
            return this.processDeclarationsNoRecursion(processor, state, place);
        }));
    }

    private boolean processDeclarationsNoRecursion(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        FtlFile placeFile = (FtlFile)((Object)state.get(FOR_FILE));
        if (placeFile != null) {
            placeFile = (FtlFile)placeFile.getOriginalFile();
            for (FtlImplicitVariable ftlVariable : this.getTopLevelFtlVariables(placeFile)) {
                if (!ftlVariable.isForFile(placeFile) || FtlFile.processVariable(ftlVariable, processor, state, place)) continue;
                return false;
            }
            if (!this.getRootTag().processDirectiveDeclarations(processor, state, null, true)) {
                return false;
            }
        }
        for (FtlImplicitVariable ftlVariable : this.getTopLevelFtlVariables(null)) {
            if (FtlFile.processVariable(ftlVariable, processor, state, place)) continue;
            return false;
        }
        if (placeFile != null || this.isImplicitlyIncluded()) {
            return true;
        }
        for (FtlVariable variable : (List)this.myGlobalVars.getValue()) {
            if (FtlFile.processVariable(variable, processor, state, place)) continue;
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this);
        if (module == null) {
            return true;
        }
        for (FtlFile psiFile : FtlFile.getImplicitlyIncludedFiles(module)) {
            if (psiFile.processDeclarations(processor, state.put(FOR_FILE, (Object)this), null, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processVariable(FtlVariable ftlVariable, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        if (StringUtil.isEmpty((String)ftlVariable.getName())) {
            FtlType type = ftlVariable.getType();
            return type == null || type.processDeclarations(processor, place, state);
        }
        return processor.execute((PsiElement)ftlVariable, state);
    }

    public PsiElement getContext() {
        return this.myContext == null ? super.getContext() : this.myContext;
    }

    public static Collection<FtlFile> getImplicitlyIncludedFiles(@NotNull Module module) {
        if (module == null) {
            FtlFile.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                FtlFile.$$$reportNull$$$0(7);
            }
            return CachedValueProvider.Result.create(FtlFile.getImplicitlyIncludedFiles(project, GlobalSearchScope.moduleScope((Module)module)), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    public static Collection<FtlFile> getImplicitlyIncludedFiles(Project project, GlobalSearchScope filter) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.IMPLICITLY_INCLUDED, filter);
        ArrayList<FtlFile> result = new ArrayList<FtlFile>(files.size());
        for (VirtualFile virtualFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (!(psiFile instanceof FtlFile)) continue;
            result.add((FtlFile)psiFile);
        }
        return result;
    }

    @Nullable
    public FtlImplicitVariable findImplicitVariable(@NotNull PsiComment comment) {
        if (comment == null) {
            FtlFile.$$$reportNull$$$0(6);
        }
        return FtlFile.findImplicitVariable(comment, ContainerUtil.concat(((Map)this.myTopLevelVars.getValue()).values(), map -> map.values()));
    }

    @Nullable
    private static FtlImplicitVariable findImplicitVariable(PsiComment comment, Collection<FtlImplicitVariable> variables) {
        for (FtlImplicitVariable variable : variables) {
            if (variable.getNavigationElement() != comment) continue;
            FtlImplicitVariable child = FtlFile.findImplicitVariable(comment, variable.getSubVariables());
            if (child != null) {
                return child;
            }
            return variable;
        }
        return null;
    }

    public FtlDirectiveStyle getDirectiveStyle() {
        return FtlLexer.guessDirectiveStyle(this.getText());
    }

    public void setContext(PsiElement context) {
        this.myContext = context;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/files/FtlFile";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootTag";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/files/FtlFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitlyIncludedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findImplicitVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getImplicitlyIncludedFiles$4";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processDeclarations$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

