/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSMTestProxy
extends SMTestProxy {
    @Nullable
    private final String myClassName;
    @Nullable
    private String myStacktrace;
    @Nullable
    private String myParentId;

    public GradleSMTestProxy(String testName, boolean isSuite, @Nullable String locationUrl, @Nullable String className) {
        super(testName, isSuite, locationUrl);
        this.myClassName = className;
    }

    public void addStdOutput(final String output, final Key outputType) {
        this.addLast(new Printable(){

            public void printOn(Printer printer) {
                printer.printWithAnsiColoring(output, ConsoleViewContentType.getConsoleViewType((Key)outputType));
            }
        });
    }

    public void setTestFailed(@NotNull String localizedMessage, @Nullable String stackTrace, boolean testError) {
        if (localizedMessage == null) {
            GradleSMTestProxy.$$$reportNull$$$0(0);
        }
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestFailed(localizedMessage, stackTrace, testError);
    }

    public void setTestComparisonFailed(@NotNull String localizedMessage, @Nullable String stackTrace, @NotNull String actualText, @NotNull String expectedText) {
        if (localizedMessage == null) {
            GradleSMTestProxy.$$$reportNull$$$0(1);
        }
        if (actualText == null) {
            GradleSMTestProxy.$$$reportNull$$$0(2);
        }
        if (expectedText == null) {
            GradleSMTestProxy.$$$reportNull$$$0(3);
        }
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestComparisonFailed(localizedMessage, stackTrace, actualText, expectedText);
    }

    public void setTestIgnored(@Nullable String ignoreComment, @Nullable String stackTrace) {
        this.setStacktraceIfNotSet(stackTrace);
        super.setTestIgnored(ignoreComment, stackTrace);
    }

    @Nullable
    public Location getLocation(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            GradleSMTestProxy.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            GradleSMTestProxy.$$$reportNull$$$0(5);
        }
        if (this.getLocationUrl() != null && this.isDefect() && this.myStacktrace != null) {
            String[] stackTrace;
            for (String aStackTrace : stackTrace = new LineTokenizer(this.myStacktrace).execute()) {
                StackTraceLine line = new StackTraceLine(project, aStackTrace);
                if (!this.getName().equals(line.getMethodName()) || !StringUtil.equals((CharSequence)this.myClassName, (CharSequence)line.getClassName())) continue;
                return line.getMethodLocation(project);
            }
        }
        return super.getLocation(project, searchScope);
    }

    @Nullable
    public String getParentId() {
        return this.myParentId;
    }

    public void setParentId(@Nullable String parentId) {
        this.myParentId = parentId;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    private void setStacktraceIfNotSet(@Nullable String stacktrace) {
        if (this.myStacktrace == null) {
            this.myStacktrace = stacktrace;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleSMTestProxy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestFailed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setTestComparisonFailed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

