/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFix
extends BaseBVQuickFix {
    private final PsiClass myEnum;
    private final String myConstantName;

    public CreateEnumConstantFix(PsiClass psiClass, String val) {
        super(BVBundle.message("create.enum.constant", new Object[0]));
        this.myEnum = psiClass;
        this.myConstantName = val;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            CreateEnumConstantFix.$$$reportNull$$$0(1);
        }
        assert (this.myEnum.isEnum()) : "Must be enum";
        try {
            PsiEnumConstant enumConstant = JavaPsiFacade.getInstance((Project)this.myEnum.getProject()).getElementFactory().createEnumConstantFromText(this.myConstantName, null);
            this.myEnum.add((PsiElement)enumConstant);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "com/intellij/beanValidation/highlighting/fixes/CreateEnumConstantFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

