/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResult;
import com.intellij.jpa.remote.impl.QueryResultImpl;
import com.intellij.jpa.remote.impl.RemoteQueryResultImpl;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public abstract class RemoteQueryBaseImpl
extends JdbcRemoteObject
implements RemoteQuery {
    private final Session mySession;
    private int myUpdateCount;
    private boolean myResultFlag;

    protected RemoteQueryBaseImpl(Session session) {
        this.mySession = session;
    }

    public Session getSession() {
        return this.mySession;
    }

    protected abstract int executeUpdate();

    protected abstract List getResultList();

    protected abstract String getQueryString();

    public boolean execute() throws RemoteException {
        try {
            this.myUpdateCount = 0;
            String query = this.getQueryString();
            query = query == null ? null : query.trim().toUpperCase();
            boolean bl = this.myResultFlag = query != null && !query.startsWith("UPDATE") && !query.startsWith("DELETE") && !query.startsWith("INSERT");
            if (this.myResultFlag) {
                this.myUpdateCount = 0;
            } else {
                Transaction tx = this.mySession.beginTransaction();
                try {
                    this.myUpdateCount = this.executeUpdate();
                }
                finally {
                    tx.commit();
                }
            }
            return this.myResultFlag;
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public int getUpdateCount() throws RemoteException {
        return this.myUpdateCount;
    }

    public RemoteQueryResult getQueryResult() throws RemoteException {
        if (!this.myResultFlag) {
            return null;
        }
        try {
            return (RemoteQueryResult)this.export((Remote)RemoteQueryResultImpl.wrap((QueryResult)this.createQueryResult()));
        }
        catch (RemoteException e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    protected QueryResult createQueryResult() {
        return new QueryResultImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Object> getResultList() {
                RemoteQueryBaseImpl.this.mySession.clear();
                Transaction tx = RemoteQueryBaseImpl.this.mySession.beginTransaction();
                try {
                    List list = RemoteQueryBaseImpl.this.getResultList();
                    return list;
                }
                finally {
                    try {
                        tx.commit();
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    public void close() throws RemoteException {
        this.unreferenced();
    }
}

