/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.WSBundle;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.index.FileBasedWSIndex;
import com.intellij.ws.index.WSIndexEntry;
import com.intellij.ws.inspections.BaseWebServicesInspection;
import com.intellij.ws.inspections.InsertAnnotationFix;
import com.intellij.ws.inspections.MarkWebServiceMembersBase;
import com.intellij.ws.utils.DeployUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebMethodExposedImplicitlyInspection
extends MarkWebServiceMembersBase {
    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            WebMethodExposedImplicitlyInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkMember(ProblemsHolder problemsHolder, PsiMember psiMember) {
        PsiClass containingClass = psiMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        BaseWebServicesInspection.ExternallyBoundClassContext context = WebMethodExposedImplicitlyInspection.getClassContext(containingClass);
        if (psiMember instanceof PsiMethod && (context.annotation == null || AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, JWSDPWSEngine.wsMethodsSet) == null)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
            WSIndexEntry[] entries = FileBasedWSIndex.getWsEntries(Arrays.asList(context.getEntries(module)), psiMember);
            if (entries.length == 0 || !DeployUtils.canBeWebMethod(psiMember)) {
                return;
            }
            problemsHolder.registerProblem(WebMethodExposedImplicitlyInspection.findNameIdentifier(psiMember), WSBundle.message("webservices.inspections.implicitly.exposed.webmethod.inspection.webmethod.problem", psiMember.getName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AnnotateAsWebMethodFix()});
        }
    }

    @Override
    protected void doCheckClass(PsiClass c, ProblemsHolder problemsHolder) {
    }

    @NotNull
    public String getDisplayName() {
        String string = WSBundle.message("webservices.inspections.implicitly.exposed.webmethod.inspection.display.name", new Object[0]);
        if (string == null) {
            WebMethodExposedImplicitlyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        String string = WSBundle.message("webservices.inspections.implicitly.exposed.webmethod.inspection.short.name", new Object[0]);
        if (string == null) {
            WebMethodExposedImplicitlyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ws/inspections/WebMethodExposedImplicitlyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class AnnotateAsWebMethodFix
    extends InsertAnnotationFix
    implements LocalQuickFix {
        protected AnnotateAsWebMethodFix() {
            super("@javax.jws.WebMethod");
        }

        @NotNull
        public String getName() {
            String string = WSBundle.message("webservices.inspections.implicitly.exposed.webmethod.inspection.annotate.web.method.fix", new Object[0]);
            if (string == null) {
                AnnotateAsWebMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/WebMethodExposedImplicitlyInspection$AnnotateAsWebMethodFix", "getName"));
        }
    }
}

