/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.jaxb;

import com.intellij.openapi.module.Module;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.engines.ExternalEngine;
import com.intellij.ws.engines.ExternalEngineThatBundlesJEEJars;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public class JaxbMappingEngine
implements ExternalEngine,
ExternalEngineThatBundlesJEEJars {
    private static final String ACTIVATION_LIBRARY_NAME = "Activation";
    private static final String STAX_LIBRARY_NAME = "Stax";
    private static final String JAXB_LIBRARY_NAME = "JAXB2 EA";
    private static final String JAXB2_FINAL_LIBRARY_NAME = "JAXB2.X final";
    public static final String JAXB_2_ENGINE = "JAXB 2";
    public static Collection<? extends String> mappedClassesSet = Arrays.asList("javax.xml.bind.annotation.XmlType");
    @NonNls
    public static final String JAXB_IMPL_JAR = "jaxb-impl.jar";
    @NonNls
    private static final String JAXB_API_JAR = "jaxb-api.jar";
    @NonNls
    private static final String JAXB_XJC_LIBRARY_NAME = "JAXB XJC";

    @Override
    public String getName() {
        return JAXB_2_ENGINE;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        String basePath = this.getBasePath();
        if (basePath == null) {
            return LibraryDescriptor.EMPTY_ARRAY;
        }
        LibraryDescriptor[] glassFishLibs = JWSDPWSEngine.getLibInfosIfGlassFishOrMetroInstall(basePath, isForGeneratedCode);
        if (glassFishLibs != null) {
            return glassFishLibs;
        }
        if (new File(basePath + File.separator + "jaxb").exists()) {
            String commonJaxbPrefix = "jaxb" + File.separator + "lib" + File.separator;
            String[] jaxbPlainJars = new String[]{commonJaxbPrefix + JAXB_IMPL_JAR, commonJaxbPrefix + "jaxb1-impl.jar", commonJaxbPrefix + JAXB_API_JAR};
            if (isForGeneratedCode) {
                String sjsxpPrefix = File.separator + "sjsxp" + File.separator + "lib" + File.separator;
                String jswdpPrefix = File.separator + "jwsdp-shared" + File.separator + "lib" + File.separator;
                return new LibraryDescriptor[]{new LibraryInfo(JAXB_LIBRARY_NAME, jaxbPlainJars), new LibraryInfo(ACTIVATION_LIBRARY_NAME, jswdpPrefix + "activation.jar"), new LibraryInfo(STAX_LIBRARY_NAME, new String[]{sjsxpPrefix + "jsr173_api.jar", sjsxpPrefix + "sjsxp.jar"})};
            }
            return new LibraryDescriptor[]{new LibraryInfo(JAXB_LIBRARY_NAME, jaxbPlainJars), new LibraryInfo(JAXB_XJC_LIBRARY_NAME, commonJaxbPrefix + "jaxb-xjc.jar")};
        }
        boolean accessingLibsFromPlugin = LibUtils.accessingLibraryJarsFromPluginBundledLibs(basePath);
        String commonJaxbPrefix = accessingLibsFromPlugin ? "" : "lib" + File.separator;
        return JaxbMappingEngine.buildJaxbNeededJars(commonJaxbPrefix, isForGeneratedCode);
    }

    public static LibraryDescriptor[] buildJaxbNeededJars(String commonJaxbPrefix, boolean generatedCode) {
        String[] jaxbPlainJars = new String[]{commonJaxbPrefix + JAXB_IMPL_JAR, commonJaxbPrefix + JAXB_API_JAR};
        LibraryInfo info = new LibraryInfo(STAX_LIBRARY_NAME, new String[]{commonJaxbPrefix + "jsr173_api.jar", commonJaxbPrefix + "sjsxp.jar"});
        if (generatedCode) {
            return new LibraryDescriptor[]{new LibraryInfo(JAXB2_FINAL_LIBRARY_NAME, jaxbPlainJars), new LibraryInfo(ACTIVATION_LIBRARY_NAME, commonJaxbPrefix + "activation.jar"), info};
        }
        return new LibraryDescriptor[]{new LibraryInfo(JAXB2_FINAL_LIBRARY_NAME, jaxbPlainJars), new LibraryInfo(JAXB_XJC_LIBRARY_NAME, commonJaxbPrefix + "jaxb-xjc.jar"), info};
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getJwsdpPath();
    }

    @Override
    public String[] getJEEJarUrls(Module targetModule) {
        return JWSDPWSEngine.getJaxWsJarsForOverriding(this, targetModule, false);
    }
}

