/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.javaee.transport.TransportHostTargetManaged;
import com.intellij.javaee.transport.TransportManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.transport.WebDeploymentTransportHost;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebDeploymentTransportHostTarget
extends TransportHostTargetManaged {
    private String myTargetPath;

    public String getTargetPath() {
        return this.myTargetPath;
    }

    public void setTargetPath(String targetPath) {
        this.myTargetPath = targetPath;
    }

    @Transient
    public boolean transfer(Project project, List<VirtualFile> files) {
        WebServerConfig serverConfig = this.findWebServerConfig(project);
        return serverConfig != null && new TransferUpload(project, serverConfig).transfer(files);
    }

    @Transient
    public boolean delete(Project project, List<VirtualFile> files) {
        WebServerConfig serverConfig = this.findWebServerConfig(project);
        return serverConfig != null && new TransferDelete(project, serverConfig).transfer(files);
    }

    @Nullable
    private WebServerConfig findWebServerConfig(@Nullable Project project) {
        WebDeploymentTransportHost host = (WebDeploymentTransportHost)TransportManager.getInstance().findHost(this.getHostId(), project);
        return host == null ? null : host.getServer();
    }

    private static String concatPaths(@NotNull String prefix, @NotNull String suffix) {
        if (prefix == null) {
            WebDeploymentTransportHostTarget.$$$reportNull$$$0(0);
        }
        if (suffix == null) {
            WebDeploymentTransportHostTarget.$$$reportNull$$$0(1);
        }
        return FileUtil.toSystemIndependentName((String)(prefix.trim() + "/" + suffix.trim()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "prefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "suffix";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/transport/WebDeploymentTransportHostTarget";
        objectArray[2] = "concatPaths";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TransferDelete
    extends TransferWrapper {
        public TransferDelete(Project project, WebServerConfig serverConfig) {
            super(project, serverConfig);
        }

        @Override
        protected String getTitle() {
            return WDBundle.message((String)"WebDeploymentTransportHostTarget.deleting.status", (Object[])new Object[]{this.getWebServerConfig().getName()});
        }

        @Override
        protected TransferTask.ListBased.ResultWithErrors doBuildOperationsList(ExecutionContext executionContext, List<VirtualFile> filesToTransfer) throws FileSystemException {
            ArrayList<TransferOperation.Delete> result = new ArrayList<TransferOperation.Delete>();
            DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions = new DeploymentPathUtils.ErrorsAndExclusions();
            for (DeploymentPathMapping mapping : executionContext.getConfig().getPathMappings(this.getWebServerConfig().getId())) {
                WebServerConfig.RemotePath fullDeployPath = mapping.getFullDeployPath((Mappable)this.getWebServerConfig());
                if (PublishConfig.isRemotePathExcluded((WebServerConfig.RemotePath)fullDeployPath, (Mappable)this.getWebServerConfig(), (PublishConfig)executionContext.getConfig())) {
                    errorsAndExclusions.addExcludedPath(fullDeployPath, this.getWebServerConfig());
                    continue;
                }
                result.add(new TransferOperation.Delete(fullDeployPath, false, true));
            }
            return new TransferTask.ListBased.ResultWithErrors(result, errorsAndExclusions);
        }
    }

    private class TransferUpload
    extends TransferWrapper {
        public TransferUpload(Project project, WebServerConfig serverConfig) {
            super(project, serverConfig);
        }

        @Override
        protected String getTitle() {
            return WDBundle.message((String)"WebDeploymentTransportHostTarget.uploading.status", (Object[])new Object[]{this.getWebServerConfig().getName()});
        }

        @Override
        protected TransferTask.ListBased.ResultWithErrors doBuildOperationsList(ExecutionContext executionContext, List<VirtualFile> filesToTransfer) throws FileSystemException {
            return PublishActionUtil.scanFiles((ExecutionContext)executionContext, filesToTransfer);
        }
    }

    private abstract class TransferWrapper {
        @NotNull
        private final Project myProject;
        private final WebServerConfig myServerConfig;

        public TransferWrapper(Project project, WebServerConfig serverConfig) {
            if (project == null) {
                TransferWrapper.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myServerConfig = serverConfig;
        }

        protected final WebServerConfig getWebServerConfig() {
            return this.myServerConfig;
        }

        public boolean transfer(final List<VirtualFile> filesToTransfer) {
            PublishConfig separatePublishConfig = PublishConfig.getInstance((Project)this.myProject).clone();
            ArrayList<DeploymentPathMapping> mappings = new ArrayList<DeploymentPathMapping>();
            for (VirtualFile fileToTransfer : filesToTransfer) {
                DeploymentPathMapping mapping = new DeploymentPathMapping();
                mapping.setLocalPath(fileToTransfer.getPath());
                mapping.setDeployPath(WebDeploymentTransportHostTarget.concatPaths(WebDeploymentTransportHostTarget.this.myTargetPath, fileToTransfer.getName()));
                mapping.setWebPath("");
                mappings.add(mapping);
            }
            separatePublishConfig.setPathMappings(this.myServerConfig.getId(), mappings);
            final Semaphore done = new Semaphore();
            done.down();
            final Ref resultRef = new Ref();
            Runnable transferRunnable = () -> new TransferTask.ListBased(this.myProject, ConnectionOwnerFactory.createConnectionOwner((Project)this.myProject), true, separatePublishConfig, Deployable.create((WebServerConfig)this.myServerConfig), this.getTitle(), true, true, true, DeploymentRevisionTracker.DEAF){

                public void run(@NotNull ProgressIndicator pi) {
                    if (pi == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        resultRef.set((Object)this.doRun(pi));
                    }
                    finally {
                        done.up();
                    }
                }

                protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext executionContext) throws FileSystemException {
                    return TransferWrapper.this.doBuildOperationsList(executionContext, filesToTransfer);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/transport/WebDeploymentTransportHostTarget$TransferWrapper$1", "run"));
                }
            }.queue();
            ApplicationManager.getApplication().invokeAndWait(transferRunnable);
            done.waitFor();
            return (Boolean)resultRef.get();
        }

        protected abstract String getTitle();

        protected abstract TransferTask.ListBased.ResultWithErrors doBuildOperationsList(ExecutionContext var1, List<VirtualFile> var2) throws FileSystemException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/transport/WebDeploymentTransportHostTarget$TransferWrapper", "<init>"));
        }
    }
}

