/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.context.UsageTracker;
import org.jetbrains.kotlin.js.translate.expression.CapturedArgsParams;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0012H\u0002\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u001a \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002\u001a\"\u0010\u001e\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n\u00a8\u0006 "}, d2={"declareAliasInsideFunction", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "name", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "alias", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getReferenceToLambda", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getTemporaryNamesInScope", "", "suggested", "isLocalInlineDeclaration", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "moveCapturedLocalInside", "Lorg/jetbrains/kotlin/js/translate/expression/CapturedArgsParams;", "capturingFunction", "capturedName", "localFunAlias", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "addDeclaration", "value", "getStaticRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "withCapturedParameters", "invokingContext", "kotlin-compiler"})
public final class LiteralFunctionTranslatorKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression withCapturedParameters(@NotNull JsFunction $receiver, @NotNull CallableMemberDescriptor descriptor2, @NotNull TranslationContext context, @NotNull TranslationContext invokingContext) {
        JsInvocation jsInvocation;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(invokingContext, "invokingContext");
        context.addDeclarationStatement($receiver.makeStmt());
        JsName jsName = $receiver.getName();
        Intrinsics.checkExpressionValueIsNotNull(jsName, "name");
        JsExpression ref = LiteralFunctionTranslatorKt.getReferenceToLambda(invokingContext, descriptor2, jsName);
        JsInvocation $receiver2 = jsInvocation = new JsInvocation(ref, new JsExpression[0]);
        MetadataProperties.setSideEffects($receiver2, SideEffectKind.PURE);
        JsInvocation invocation = jsInvocation;
        List<JsExpression> invocationArguments = invocation.getArguments();
        List<JsParameter> functionParameters = $receiver.getParameters();
        UsageTracker usageTracker = context.usageTracker();
        if (usageTracker == null) {
            Intrinsics.throwNpe();
        }
        UsageTracker tracker = usageTracker;
        Map<DeclarationDescriptor, JsName> map2 = tracker.getCapturedDescriptorToJsName();
        Iterator<Map.Entry<DeclarationDescriptor, JsName>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<DeclarationDescriptor, JsName> entry;
            Map.Entry<DeclarationDescriptor, JsName> entry2 = entry = iterator2.next();
            DeclarationDescriptor capturedDescriptor = entry2.getKey();
            entry2 = entry;
            JsName name = entry2.getValue();
            if (Intrinsics.areEqual(capturedDescriptor, tracker.getContainingDescriptor()) && !DescriptorUtilsKt.isCoroutineLambda(capturedDescriptor)) continue;
            JsExpression capturedRef = invokingContext.getArgumentForClosureConstructor(capturedDescriptor);
            List<JsExpression> additionalArgs = CollectionsKt.listOf(capturedRef);
            List<JsParameter> additionalParams = CollectionsKt.listOf(new JsParameter(name));
            if (capturedDescriptor instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)capturedDescriptor).isReified()) {
                additionalArgs = CollectionsKt.plus((Collection)CollectionsKt.listOf(invokingContext.getNameForDescriptor(capturedDescriptor).makeRef()), (Iterable)additionalArgs);
                additionalParams = CollectionsKt.plus((Collection)CollectionsKt.listOf(new JsParameter(context.getNameForDescriptor(capturedDescriptor))), (Iterable)additionalParams);
            }
            if (capturedDescriptor instanceof CallableDescriptor && LiteralFunctionTranslatorKt.isLocalInlineDeclaration((CallableDescriptor)capturedDescriptor)) {
                JsExpression localFunAlias;
                JsNameRef aliasRef;
                JsExpression jsExpression = capturedRef;
                if (!(jsExpression instanceof JsNameRef)) {
                    jsExpression = null;
                }
                JsNameRef jsNameRef = aliasRef = (JsNameRef)jsExpression;
                JsNode jsNode = jsNameRef != null ? LiteralFunctionTranslatorKt.getStaticRef(jsNameRef) : null;
                if (!(jsNode instanceof JsExpression)) {
                    jsNode = null;
                }
                if ((localFunAlias = (JsExpression)jsNode) != null) {
                    void args;
                    CapturedArgsParams capturedArgsParams = LiteralFunctionTranslatorKt.moveCapturedLocalInside($receiver, name, localFunAlias);
                    List<JsExpression> list2 = capturedArgsParams.component1();
                    List<JsParameter> params = capturedArgsParams.component2();
                    additionalArgs = args;
                    additionalParams = params;
                }
            }
            functionParameters.addAll((Collection<JsParameter>)additionalParams);
            invocationArguments.addAll((Collection<JsExpression>)additionalArgs);
        }
        return invocation;
    }

    private static final JsExpression getReferenceToLambda(TranslationContext context, CallableMemberDescriptor descriptor2, JsName name) {
        JsExpression jsExpression;
        if (context.isPublicInlineFunction()) {
            JsExpression fqn = context.getQualifiedReference(descriptor2);
            if (fqn instanceof JsNameRef) {
                JsName jsName = ((JsNameRef)fqn).getName();
                if (jsName != null) {
                    JsName jsName2;
                    JsName it = jsName2 = jsName;
                    MetadataProperties.setStaticRef(it, MetadataProperties.getStaticRef(name));
                }
            }
            JsExpression jsExpression2 = fqn;
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "fqn");
        } else {
            JsNameRef jsNameRef = JsAstUtils.pureFqn(name, null);
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "JsAstUtils.pureFqn(name, null)");
            jsExpression = jsNameRef;
        }
        return jsExpression;
    }

    private static final CapturedArgsParams moveCapturedLocalInside(JsFunction capturingFunction, JsName capturedName, JsExpression localFunAlias) {
        CapturedArgsParams capturedArgsParams;
        JsExpression jsExpression = localFunAlias;
        if (jsExpression instanceof JsNameRef) {
            LiteralFunctionTranslatorKt.declareAliasInsideFunction(capturingFunction, capturedName, localFunAlias);
            capturedArgsParams = new CapturedArgsParams(null, null, 3, null);
        } else if (jsExpression instanceof JsInvocation) {
            capturedArgsParams = LiteralFunctionTranslatorKt.moveCapturedLocalInside(capturingFunction, capturedName, (JsInvocation)localFunAlias);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Local function reference has wrong alias " + localFunAlias)));
        }
        return capturedArgsParams;
    }

    /*
     * WARNING - void declaration
     */
    private static final CapturedArgsParams moveCapturedLocalInside(JsFunction capturingFunction, JsName capturedName, JsInvocation localFunAlias) {
        void $receiver$iv$iv;
        SourceInfoAwareJsNode sourceInfoAwareJsNode;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        List<JsExpression> capturedArgs;
        List<JsExpression> list2 = capturedArgs = localFunAlias.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "capturedArgs");
        List<JsName> freshNames = LiteralFunctionTranslatorKt.getTemporaryNamesInScope(list2);
        Iterable iterable = $receiver$iv = (Iterable)freshNames;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void p1;
            JsName jsName = (JsName)item$iv$iv;
            collection = destination$iv$iv;
            sourceInfoAwareJsNode = p1.makeRef();
            collection.add(sourceInfoAwareJsNode);
        }
        List aliasCallArguments = (List)destination$iv$iv;
        JsInvocation alias = new JsInvocation(localFunAlias.getQualifier(), aliasCallArguments);
        LiteralFunctionTranslatorKt.declareAliasInsideFunction(capturingFunction, capturedName, alias);
        Iterable $receiver$iv2 = freshNames;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            JsName $i$f$mapTo = (JsName)item$iv$iv;
            collection = destination$iv$iv2;
            sourceInfoAwareJsNode = new JsParameter((JsName)p1);
            collection.add(sourceInfoAwareJsNode);
        }
        List capturedParameters = (List)destination$iv$iv2;
        return new CapturedArgsParams(capturedArgs, capturedParameters);
    }

    private static final void declareAliasInsideFunction(JsFunction function2, JsName name, JsExpression alias) {
        block0: {
            MetadataProperties.setStaticRef(name, alias);
            JsFunction jsFunction = FunctionUtilsKt.getInnerFunction(function2);
            if (jsFunction == null) break block0;
            LiteralFunctionTranslatorKt.addDeclaration(jsFunction, name, alias);
        }
    }

    private static final List<JsName> getTemporaryNamesInScope(List<? extends JsExpression> suggested) {
        ArrayList<JsName> freshNames = new ArrayList<JsName>();
        for (JsExpression jsExpression : suggested) {
            if (!(jsExpression instanceof JsNameRef)) {
                throw (Throwable)((Object)new AssertionError((Object)"Expected suggestion to be JsNameRef"));
            }
            String ident = ((JsNameRef)jsExpression).getIdent();
            JsName name = JsScope.declareTemporaryName(ident);
            freshNames.add(name);
        }
        return freshNames;
    }

    private static final void addDeclaration(@NotNull JsFunction $receiver, JsName name, JsExpression value) {
        JsVars declaration = JsAstUtils.newVar(name, value);
        $receiver.getBody().getStatements().add(0, declaration);
    }

    private static final JsNode getStaticRef(@NotNull HasName $receiver) {
        JsName jsName = $receiver.getName();
        return jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
    }

    private static final boolean isLocalInlineDeclaration(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.LOCAL) && InlineUtil.isInline(descriptor2);
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$getReferenceToLambda(@NotNull TranslationContext context, @NotNull CallableMemberDescriptor descriptor2, @NotNull JsName name) {
        return LiteralFunctionTranslatorKt.getReferenceToLambda(context, descriptor2, name);
    }
}

