/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsImportedModule;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.facade.MainCallParameters;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationException;
import org.jetbrains.kotlin.js.facade.exceptions.TranslationRuntimeException;
import org.jetbrains.kotlin.js.facade.exceptions.UnsupportedFeatureException;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.FileDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AstGenerationResult;
import org.jetbrains.kotlin.js.translate.general.Merger;
import org.jetbrains.kotlin.js.translate.general.ModuleWrapperTranslation;
import org.jetbrains.kotlin.js.translate.test.JSTestGenerator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.AssignToExpressionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.serialization.js.ast.JsAstDeserializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public final class Translation {
    private Translation() {
    }

    @NotNull
    public static PatternTranslator patternTranslator(@NotNull TranslationContext context) {
        if (context == null) {
            Translation.$$$reportNull$$$0(0);
        }
        PatternTranslator patternTranslator = PatternTranslator.newInstance(context);
        if (patternTranslator == null) {
            Translation.$$$reportNull$$$0(1);
        }
        return patternTranslator;
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(3);
        }
        JsNode jsNode = Translation.translateExpression(expression2, context, context.dynamicContext().jsBlock());
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(4);
        }
        return jsNode;
    }

    @NotNull
    public static JsNode translateExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsExpression constantResult;
        KotlinType type2;
        JsExpression aliasForExpression;
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(5);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(6);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(7);
        }
        if ((aliasForExpression = context.aliasingContext().getAliasForExpression(expression2)) != null) {
            JsExpression jsExpression = aliasForExpression;
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(8);
            }
            return jsExpression;
        }
        CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression2, context.bindingContext());
        if (compileTimeValue != null && (type2 = context.bindingContext().getType(expression2)) != null && (KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isInt(type2) && expression2 instanceof KtUnaryExpression) && (constantResult = Translation.translateConstant(compileTimeValue, expression2, context)) != null) {
            JsExpression jsExpression = constantResult.source(expression2);
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(9);
            }
            return jsExpression;
        }
        TranslationContext innerContext = context.innerBlock();
        JsNode result2 = Translation.doTranslateExpression(expression2, innerContext);
        context.moveVarsFrom(innerContext);
        block.getStatements().addAll(innerContext.dynamicContext().jsBlock().getStatements());
        JsNode jsNode = result2;
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(10);
        }
        return jsNode;
    }

    @Nullable
    public static JsExpression translateConstant(@NotNull CompileTimeConstant compileTimeValue, @NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KotlinType expectedType2;
        ConstantValue constant;
        if (compileTimeValue == null) {
            Translation.$$$reportNull$$$0(11);
        }
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(12);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(13);
        }
        if ((constant = compileTimeValue.toConstantValue((expectedType2 = context.bindingContext().getType(expression2)) != null ? expectedType2 : TypeUtils.NO_EXPECTED_TYPE)) instanceof NullValue) {
            return new JsNullLiteral();
        }
        Object value = constant.getValue();
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return new JsIntLiteral(((Number)value).intValue());
        }
        if (value instanceof Long) {
            return JsAstUtils.newLong((Long)value);
        }
        if (value instanceof Float) {
            float floatValue = ((Float)value).floatValue();
            double doubleValue = Float.isInfinite(floatValue) || Float.isNaN(floatValue) ? (double)floatValue : Double.parseDouble(Float.toString(floatValue));
            return new JsDoubleLiteral(doubleValue);
        }
        if (value instanceof Number) {
            return new JsDoubleLiteral(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return new JsBooleanLiteral((Boolean)value);
        }
        if (value instanceof String) {
            return new JsStringLiteral((String)value);
        }
        if (value instanceof Character) {
            return new JsIntLiteral(((Character)value).charValue());
        }
        return null;
    }

    @NotNull
    private static JsNode doTranslateExpression(KtExpression expression2, TranslationContext context) {
        JsNode jsNode;
        try {
            jsNode = expression2.accept(new ExpressionVisitor(), context);
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException(expression2, (Throwable)e);
        }
        if (jsNode == null) {
            Translation.$$$reportNull$$$0(14);
        }
        return jsNode;
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(15);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(16);
        }
        JsExpression jsExpression = Translation.translateAsExpression(expression2, context, context.dynamicContext().jsBlock());
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(17);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsExpression(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        JsNode jsNode;
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(18);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(19);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(20);
        }
        if ((jsNode = Translation.translateExpression(expression2, context, block)) instanceof JsExpression) {
            KotlinType expressionType = context.bindingContext().getType(expression2);
            JsExpression jsExpression = Translation.unboxIfNeeded((JsExpression)jsNode, expressionType != null && KotlinBuiltIns.isCharOrNullableChar(expressionType));
            if (jsExpression == null) {
                Translation.$$$reportNull$$$0(21);
            }
            return jsExpression;
        }
        assert (jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, context.bindingContext())) {
            TemporaryVariable result2 = context.declareTemporary(null, expression2);
            AssignToExpressionMutator saveResultToTemporaryMutator = new AssignToExpressionMutator(result2.reference());
            block.getStatements().add(LastExpressionMutator.mutateLastExpression(jsNode, saveResultToTemporaryMutator));
            JsNameRef jsNameRef = result2.reference();
            if (jsNameRef == null) {
                Translation.$$$reportNull$$$0(22);
            }
            return jsNameRef;
        }
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsExpression jsExpression = new JsNullLiteral().source(expression2);
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(23);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression unboxIfNeeded(@NotNull JsExpression expression2, boolean charOrNullableChar) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(24);
        }
        if (charOrNullableChar && (expression2 instanceof JsInvocation || expression2 instanceof JsNameRef || expression2 instanceof JsArrayAccess)) {
            expression2 = JsAstUtils.boxedCharToChar(expression2);
        }
        JsExpression jsExpression = expression2;
        if (jsExpression == null) {
            Translation.$$$reportNull$$$0(25);
        }
        return jsExpression;
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(26);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(27);
        }
        JsStatement jsStatement = Translation.translateAsStatement(expression2, context, context.dynamicContext().jsBlock());
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(28);
        }
        return jsStatement;
    }

    @NotNull
    public static JsStatement translateAsStatement(@NotNull KtExpression expression2, @NotNull TranslationContext context, @NotNull JsBlock block) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(29);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(30);
        }
        if (block == null) {
            Translation.$$$reportNull$$$0(31);
        }
        JsStatement jsStatement = JsAstUtils.convertToStatement(Translation.translateExpression(expression2, context, block));
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(32);
        }
        return jsStatement;
    }

    @NotNull
    public static JsStatement translateAsStatementAndMergeInBlockIfNeeded(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            Translation.$$$reportNull$$$0(33);
        }
        if (context == null) {
            Translation.$$$reportNull$$$0(34);
        }
        JsBlock block = new JsBlock();
        JsNode node = Translation.translateExpression(expression2, context, block);
        JsStatement jsStatement = JsAstUtils.mergeStatementInBlockIfNeeded(JsAstUtils.convertToStatement(node), block);
        if (jsStatement == null) {
            Translation.$$$reportNull$$$0(35);
        }
        return jsStatement;
    }

    @NotNull
    public static AstGenerationResult generateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config) throws TranslationException {
        AstGenerationResult astGenerationResult;
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(36);
        }
        if (units == null) {
            Translation.$$$reportNull$$$0(37);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(38);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(39);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(40);
        }
        try {
            astGenerationResult = Translation.doGenerateAst(bindingTrace, units, mainCallParameters, moduleDescriptor, config);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedFeatureException("Unsupported feature used.", e);
        }
        catch (Throwable e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        if (astGenerationResult == null) {
            Translation.$$$reportNull$$$0(41);
        }
        return astGenerationResult;
    }

    @NotNull
    private static AstGenerationResult doGenerateAst(@NotNull BindingTrace bindingTrace, @NotNull Collection<TranslationUnit> units, @NotNull MainCallParameters mainCallParameters, @NotNull ModuleDescriptor moduleDescriptor, @NotNull JsConfig config) {
        JsProgramFragment mainCallFragment;
        if (bindingTrace == null) {
            Translation.$$$reportNull$$$0(42);
        }
        if (units == null) {
            Translation.$$$reportNull$$$0(43);
        }
        if (mainCallParameters == null) {
            Translation.$$$reportNull$$$0(44);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(45);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(46);
        }
        JsProgram program = new JsProgram();
        JsFunction rootFunction = new JsFunction((JsScope)program.getRootScope(), new JsBlock(), "root function");
        JsName internalModuleName = program.getScope().declareName("_");
        Merger merger = new Merger(rootFunction, internalModuleName, moduleDescriptor);
        HashMap<KtFile, JsProgramFragment> fragmentMap = new HashMap<KtFile, JsProgramFragment>();
        ArrayList<JsProgramFragment> fragments2 = new ArrayList<JsProgramFragment>();
        ArrayList<JsProgramFragment> newFragments = new ArrayList<JsProgramFragment>();
        HashMap<KtFile, ArrayList<DeclarationDescriptor>> fileMemberScopes = new HashMap<KtFile, ArrayList<DeclarationDescriptor>>();
        List sourceRoots = config.getSourceMapRoots().stream().map(File::new).collect(Collectors.toList());
        JsAstDeserializer deserializer = new JsAstDeserializer(program, sourceRoots);
        for (TranslationUnit unit : units) {
            if (unit instanceof TranslationUnit.SourceFile) {
                KtFile file = ((TranslationUnit.SourceFile)unit).getFile();
                StaticContext staticContext = new StaticContext(bindingTrace, config, moduleDescriptor);
                TranslationContext context = TranslationContext.rootContext(staticContext);
                ArrayList<DeclarationDescriptor> fileMemberScope = new ArrayList<DeclarationDescriptor>();
                Translation.translateFile(context, file, fileMemberScope);
                fragments2.add(staticContext.getFragment());
                newFragments.add(staticContext.getFragment());
                fragmentMap.put(file, staticContext.getFragment());
                fileMemberScopes.put(file, fileMemberScope);
                merger.addFragment(staticContext.getFragment());
                continue;
            }
            if (!(unit instanceof TranslationUnit.BinaryAst)) continue;
            byte[] astData = ((TranslationUnit.BinaryAst)unit).getData();
            JsProgramFragment fragment = deserializer.deserialize(new ByteArrayInputStream(astData));
            merger.addFragment(fragment);
            fragments2.add(fragment);
        }
        JsProgramFragment testFragment = Translation.mayBeGenerateTests(config, bindingTrace, moduleDescriptor);
        fragments2.add(testFragment);
        newFragments.add(testFragment);
        merger.addFragment(testFragment);
        rootFunction.getParameters().add(new JsParameter(internalModuleName));
        if (mainCallParameters.shouldBeGenerated() && (mainCallFragment = Translation.generateCallToMain(bindingTrace, config, moduleDescriptor, mainCallParameters.arguments())) != null) {
            fragments2.add(mainCallFragment);
            newFragments.add(mainCallFragment);
            merger.addFragment(mainCallFragment);
        }
        merger.merge();
        JsBlock rootBlock = rootFunction.getBody();
        List<JsStatement> statements = rootBlock.getStatements();
        statements.add(0, new JsStringLiteral("use strict").makeStmt());
        if (!Translation.isBuiltinModule(fragments2)) {
            Translation.defineModule(program, statements, config.getModuleId());
        }
        List<JsImportedModule> importedModuleList = merger.getImportedModules();
        for (JsImportedModule importedModule : importedModuleList) {
            rootFunction.getParameters().add(new JsParameter(importedModule.getInternalName()));
        }
        statements.add(new JsReturn(internalModuleName.makeRef()));
        JsGlobalBlock block = program.getGlobalBlock();
        block.getStatements().addAll(ModuleWrapperTranslation.wrapIfNecessary(config.getModuleId(), rootFunction, importedModuleList, program, config.getModuleKind()));
        AstGenerationResult astGenerationResult = new AstGenerationResult(program, internalModuleName, fragments2, fragmentMap, newFragments, fileMemberScopes, importedModuleList);
        if (astGenerationResult == null) {
            Translation.$$$reportNull$$$0(47);
        }
        return astGenerationResult;
    }

    private static boolean isBuiltinModule(@NotNull List<JsProgramFragment> fragments2) {
        if (fragments2 == null) {
            Translation.$$$reportNull$$$0(48);
        }
        for (JsProgramFragment fragment : fragments2) {
            for (JsNameBinding nameBinding : fragment.getNameBindings()) {
                if (!nameBinding.getKey().equals("kotlin$Enum") || fragment.getImports().containsKey("kotlin$Enum")) continue;
                return true;
            }
        }
        return false;
    }

    private static void translateFile(@NotNull TranslationContext context, @NotNull KtFile file, @NotNull List<DeclarationDescriptor> fileMemberScope) {
        if (context == null) {
            Translation.$$$reportNull$$$0(49);
        }
        if (file == null) {
            Translation.$$$reportNull$$$0(50);
        }
        if (fileMemberScope == null) {
            Translation.$$$reportNull$$$0(51);
        }
        FileDeclarationVisitor fileVisitor = new FileDeclarationVisitor(context);
        try {
            for (KtDeclaration declaration : file.getDeclarations()) {
                DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForElement(context.bindingContext(), declaration);
                fileMemberScope.add(descriptor2);
                if (AnnotationsUtils.isPredefinedObject(descriptor2)) continue;
                declaration.accept(fileVisitor, context);
            }
        }
        catch (TranslationRuntimeException e) {
            throw e;
        }
        catch (AssertionError | RuntimeException e) {
            throw new TranslationRuntimeException(file, (Throwable)e);
        }
    }

    private static void defineModule(@NotNull JsProgram program, @NotNull List<JsStatement> statements, @NotNull String moduleId) {
        JsName rootPackageName;
        if (program == null) {
            Translation.$$$reportNull$$$0(52);
        }
        if (statements == null) {
            Translation.$$$reportNull$$$0(53);
        }
        if (moduleId == null) {
            Translation.$$$reportNull$$$0(54);
        }
        if ((rootPackageName = program.getScope().findName(Namer.getRootPackageName())) != null) {
            Namer namer = Namer.newInstance(program.getScope());
            statements.add(new JsInvocation((JsExpression)namer.kotlin("defineModule"), new JsStringLiteral(moduleId), rootPackageName.makeRef()).makeStmt());
        }
    }

    @NotNull
    private static JsProgramFragment mayBeGenerateTests(@NotNull JsConfig config, @NotNull BindingTrace trace, @NotNull ModuleDescriptor moduleDescriptor) {
        if (config == null) {
            Translation.$$$reportNull$$$0(55);
        }
        if (trace == null) {
            Translation.$$$reportNull$$$0(56);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(57);
        }
        StaticContext staticContext = new StaticContext(trace, config, moduleDescriptor);
        TranslationContext context = TranslationContext.rootContext(staticContext);
        new JSTestGenerator(context).generateTestCalls(moduleDescriptor);
        JsProgramFragment jsProgramFragment = staticContext.getFragment();
        if (jsProgramFragment == null) {
            Translation.$$$reportNull$$$0(58);
        }
        return jsProgramFragment;
    }

    @Nullable
    private static JsProgramFragment generateCallToMain(@NotNull BindingTrace trace, @NotNull JsConfig config, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<String> arguments2) {
        StaticContext staticContext;
        TranslationContext context;
        MainFunctionDetector mainFunctionDetector;
        FunctionDescriptor functionDescriptor;
        if (trace == null) {
            Translation.$$$reportNull$$$0(59);
        }
        if (config == null) {
            Translation.$$$reportNull$$$0(60);
        }
        if (moduleDescriptor == null) {
            Translation.$$$reportNull$$$0(61);
        }
        if (arguments2 == null) {
            Translation.$$$reportNull$$$0(62);
        }
        if ((functionDescriptor = (mainFunctionDetector = new MainFunctionDetector((context = TranslationContext.rootContext(staticContext = new StaticContext(trace, config, moduleDescriptor))).bindingContext())).getMainFunction(moduleDescriptor)) == null) {
            return null;
        }
        JsArrayLiteral argument = new JsArrayLiteral(JsAstUtils.toStringLiteralList(arguments2));
        JsExpression call2 = CallTranslator.INSTANCE.buildCall(context, functionDescriptor, Collections.singletonList(argument), null);
        context.addTopLevelStatement(call2.makeStmt());
        return staticContext.getFragment();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 2: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 24: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileTimeValue";
                break;
            }
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingTrace";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "units";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainCallParameters";
                break;
            }
            case 39: 
            case 45: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDescriptor";
                break;
            }
            case 40: 
            case 46: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileMemberScope";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "program";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/general/Translation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "patternTranslator";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doTranslateExpression";
                break;
            }
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsExpression";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxIfNeeded";
                break;
            }
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAst";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateAst";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "mayBeGenerateTests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "patternTranslator";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: 
            case 58: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "translateExpression";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "translateConstant";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "translateAsExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "unboxIfNeeded";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "translateAsStatementAndMergeInBlockIfNeeded";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateAst";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateAst";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isBuiltinModule";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "translateFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "defineModule";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "mayBeGenerateTests";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "generateCallToMain";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 41: 
            case 47: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

