/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.test;

import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J-\u0010*\u001a\u00020\u0011*\u00020\u00122\u0006\u0010+\u001a\u00020\u00192\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190-\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/js/translate/test/JSTestGenerator;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "suiteRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getSuiteRef", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "suiteRef$delegate", "Lkotlin/Lazy;", "testRef", "getTestRef", "testRef$delegate", "isIgnored", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "isTest", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "findFunction", "name", "", "generateCodeForTestMethod", "", "functionDescriptor", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "parentFun", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "generateTestCalls", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "packageName", "Lorg/jetbrains/kotlin/name/FqName;", "generateTestFunction", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "generateTestFunctions", "annotationFinder", "shortName", "packages", "", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Ljava/lang/String;[Ljava/lang/String;)Z", "kotlin-compiler"})
public final class JSTestGenerator {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy suiteRef$delegate;
    private final Lazy testRef$delegate;
    @NotNull
    private final TranslationContext context;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(JSTestGenerator.class), "suiteRef", "getSuiteRef()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;")), Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(JSTestGenerator.class), "testRef", "getTestRef()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;"))};
    }

    public final void generateTestCalls(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull(moduleDescriptor, "moduleDescriptor");
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqName.ROOT");
        this.generateTestCalls(moduleDescriptor, fqName2);
    }

    private final void generateTestCalls(ModuleDescriptor moduleDescriptor, FqName packageName) {
        JsFunction packageFunction = new JsFunction(this.context.scope(), new JsBlock(), "" + packageName.asString() + " package suite function");
        for (PackageFragmentDescriptor packageDescriptor : moduleDescriptor.getPackage(packageName).getFragments()) {
            if (DescriptorUtils.getContainingModule(packageDescriptor) != moduleDescriptor) continue;
            Iterable $receiver$iv = packageDescriptor.getMemberScope().getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER());
            for (Object element$iv : $receiver$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                if (!(it instanceof ClassDescriptor)) continue;
                this.generateTestFunctions((ClassDescriptor)it, packageFunction);
            }
        }
        if (!packageFunction.getBody().isEmpty()) {
            JsStringLiteral suiteName = new JsStringLiteral(packageName.asString());
            this.context.addTopLevelStatement(new JsInvocation(this.getSuiteRef(), suiteName, new JsBooleanLiteral(false), packageFunction).makeStmt());
        }
        for (FqName subpackageName : moduleDescriptor.getSubPackagesOf(packageName, MemberScope.Companion.getALL_NAME_FILTER())) {
            this.generateTestCalls(moduleDescriptor, subpackageName);
        }
    }

    private final void generateTestFunctions(ClassDescriptor classDescriptor, JsFunction parentFun) {
        if (classDescriptor.getModality() == Modality.ABSTRACT) {
            return;
        }
        JsFunction suiteFunction = new JsFunction(this.context.scope(), new JsBlock(), "suite function");
        Iterable $receiver$iv = classDescriptor.getUnsubstitutedMemberScope().getContributedDescriptors(DescriptorKindFilter.FUNCTIONS, MemberScope.Companion.getALL_NAME_FILTER());
        for (Object element$iv : $receiver$iv) {
            DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
            if (!(it instanceof FunctionDescriptor) || !this.isTest((FunctionDescriptor)it)) continue;
            this.generateCodeForTestMethod((FunctionDescriptor)it, classDescriptor, suiteFunction);
        }
        if (!suiteFunction.getBody().isEmpty()) {
            JsStringLiteral suiteName = new JsStringLiteral(classDescriptor.getName().toString());
            Collection collection = parentFun.getBody().getStatements();
            JsStatement jsStatement = new JsInvocation(this.getSuiteRef(), suiteName, new JsBooleanLiteral(this.isIgnored(classDescriptor)), suiteFunction).makeStmt();
            collection.add(jsStatement);
        }
    }

    private final void generateCodeForTestMethod(FunctionDescriptor functionDescriptor, ClassDescriptor classDescriptor, JsFunction parentFun) {
        JsFunctionScope jsFunctionScope = parentFun.getScope();
        Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "parentFun.scope");
        JsFunction functionToTest = this.generateTestFunction(functionDescriptor, classDescriptor, jsFunctionScope);
        JsStringLiteral testName = new JsStringLiteral(functionDescriptor.getName().toString());
        Collection collection = parentFun.getBody().getStatements();
        JsStatement jsStatement = new JsInvocation(this.getTestRef(), testName, new JsBooleanLiteral(this.isIgnored(functionDescriptor)), functionToTest).makeStmt();
        collection.add(jsStatement);
    }

    private final JsFunction generateTestFunction(FunctionDescriptor functionDescriptor, ClassDescriptor classDescriptor, JsScope scope) {
        JsExpression expression2 = ReferenceTranslator.translateAsValueReference(classDescriptor, this.context);
        JsNew testClass = new JsNew(expression2);
        JsExpression functionToTestCall = CallTranslator.INSTANCE.buildCall(this.context, functionDescriptor, CollectionsKt.emptyList(), testClass);
        JsFunction functionToTest = new JsFunction(scope, "test function");
        functionToTest.setBody(new JsBlock(functionToTestCall.makeStmt()));
        return functionToTest;
    }

    private final JsExpression getSuiteRef() {
        Lazy lazy = this.suiteRef$delegate;
        JSTestGenerator jSTestGenerator = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (JsExpression)lazy.getValue();
    }

    private final JsExpression getTestRef() {
        Lazy lazy = this.testRef$delegate;
        JSTestGenerator jSTestGenerator = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (JsExpression)lazy.getValue();
    }

    private final JsExpression findFunction(String name) {
        ModuleDescriptor moduleDescriptor = this.context.getCurrentModule();
        FqName fqName2 = new FqNameUnsafe("kotlin.test").toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FqNameUnsafe(\"kotlin.test\").toSafe()");
        FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByNameOrNull(moduleDescriptor.getPackage(fqName2).getMemberScope(), Name.identifier(name));
        if (functionDescriptor == null) {
            return new JsNameRef(name, (JsExpression)new JsNameRef("Kotlin"));
        }
        FunctionDescriptor descriptor2 = functionDescriptor;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(descriptor2, this.context);
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "ReferenceTranslator.tran\u2026ence(descriptor, context)");
        return jsExpression;
    }

    private final boolean isTest(@NotNull FunctionDescriptor $receiver) {
        return this.annotationFinder($receiver, "Test", "kotlin.test");
    }

    private final boolean isIgnored(@NotNull DeclarationDescriptor $receiver) {
        return this.annotationFinder($receiver, "Ignore", "kotlin.test");
    }

    private final boolean annotationFinder(@NotNull DeclarationDescriptor $receiver, String shortName, String ... packages2) {
        boolean bl;
        block1: {
            Object[] $receiver$iv = packages2;
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                String packageName = (String)element$iv;
                if (!$receiver.getAnnotations().hasAnnotation(new FqName("" + packageName + '.' + shortName))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final TranslationContext getContext() {
        return this.context;
    }

    public JSTestGenerator(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.suiteRef$delegate = LazyKt.lazy((Function0)new Function0<JsExpression>(this){
            final /* synthetic */ JSTestGenerator this$0;

            @NotNull
            public final JsExpression invoke() {
                return JSTestGenerator.access$findFunction(this.this$0, "suite");
            }
            {
                this.this$0 = jSTestGenerator;
                super(0);
            }
        });
        this.testRef$delegate = LazyKt.lazy((Function0)new Function0<JsExpression>(this){
            final /* synthetic */ JSTestGenerator this$0;

            @NotNull
            public final JsExpression invoke() {
                return JSTestGenerator.access$findFunction(this.this$0, "test");
            }
            {
                this.this$0 = jSTestGenerator;
                super(0);
            }
        });
    }

    @NotNull
    public static final /* synthetic */ JsExpression access$findFunction(JSTestGenerator $this, @NotNull String name) {
        return $this.findFunction(name);
    }
}

