/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import com.google.common.collect.Sets;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class CompileTimeConstantChecker {
    private static final Set<DiagnosticFactory<?>> errorsThatDependOnExpectedType = Sets.newHashSet(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH, Errors.NULL_FOR_NONNULL_TYPE);
    private final KotlinBuiltIns builtIns;
    private final BindingTrace trace;
    private final boolean checkOnlyErrorsThatDependOnExpectedType;
    private final ResolutionContext<?> context;

    public CompileTimeConstantChecker(@NotNull ResolutionContext<?> context, @NotNull KotlinBuiltIns builtIns, boolean checkOnlyErrorsThatDependOnExpectedType) {
        if (context == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(0);
        }
        if (builtIns == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(1);
        }
        this.checkOnlyErrorsThatDependOnExpectedType = checkOnlyErrorsThatDependOnExpectedType;
        this.builtIns = builtIns;
        this.trace = context.trace;
        this.context = context;
    }

    public boolean checkConstantExpressionType(@Nullable ConstantValue<?> compileTimeConstant, @NotNull KtConstantExpression expression2, @NotNull KotlinType expectedType2) {
        IElementType elementType;
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(2);
        }
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(3);
        }
        if ((elementType = expression2.getNode().getElementType()) == KtNodeTypes.INTEGER_CONSTANT) {
            return this.checkIntegerValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.FLOAT_CONSTANT) {
            return this.checkFloatValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.BOOLEAN_CONSTANT) {
            return this.checkBooleanValue(expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT) {
            return this.checkCharValue(compileTimeConstant, expectedType2, expression2);
        }
        if (elementType == KtNodeTypes.NULL) {
            return this.checkNullValue(expectedType2, expression2);
        }
        return false;
    }

    private boolean checkIntegerValue(@Nullable ConstantValue<?> value, @NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        KotlinType valueType;
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(4);
        }
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(5);
        }
        if (value == null) {
            return this.reportError(Errors.INT_LITERAL_OUT_OF_RANGE.on(expression2));
        }
        if (expression2.getText().endsWith("l")) {
            return this.reportError(Errors.WRONG_LONG_SUFFIX.on(expression2));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value.getType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "integer", expectedType2, null);
        }
        return false;
    }

    private boolean checkFloatValue(@Nullable ConstantValue<?> value, @NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        KotlinType valueType;
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(6);
        }
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(7);
        }
        if (value == null) {
            return this.reportError(Errors.FLOAT_LITERAL_OUT_OF_RANGE.on(expression2));
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType = value.getType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "floating-point", expectedType2, null);
        }
        return false;
    }

    private boolean checkBooleanValue(@NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(8);
        }
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(9);
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getBooleanType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "boolean", expectedType2, this.builtIns.getBooleanType());
        }
        return false;
    }

    private boolean checkCharValue(ConstantValue<?> constant, KotlinType expectedType2, KtConstantExpression expression2) {
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(this.builtIns.getCharType(), expectedType2)) {
            return this.reportConstantExpectedTypeMismatch(expression2, "character", expectedType2, this.builtIns.getCharType());
        }
        if (constant != null) {
            return false;
        }
        Diagnostic diagnostic = CompileTimeConstantChecker.parseCharacter(expression2).getDiagnostic();
        if (diagnostic != null) {
            return this.reportError(diagnostic);
        }
        return false;
    }

    private boolean checkNullValue(@NotNull KotlinType expectedType2, @NotNull KtConstantExpression expression2) {
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(11);
        }
        if (!CompileTimeConstantChecker.noExpectedTypeOrError(expectedType2) && !TypeUtils.acceptsNullable(expectedType2)) {
            if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression2, expectedType2, this.builtIns.getNullableNothingType())) {
                return true;
            }
            return this.reportError(Errors.NULL_FOR_NONNULL_TYPE.on(expression2, expectedType2));
        }
        return false;
    }

    @NotNull
    private static CharacterWithDiagnostic parseCharacter(@NotNull KtConstantExpression expression2) {
        String text2;
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(12);
        }
        if ((text2 = expression2.getText()).length() < 2 || text2.charAt(0) != '\'' || text2.charAt(text2.length() - 1) != '\'') {
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.INCORRECT_CHARACTER_LITERAL.on(expression2));
            if (characterWithDiagnostic == null) {
                CompileTimeConstantChecker.$$$reportNull$$$0(13);
            }
            return characterWithDiagnostic;
        }
        if ((text2 = text2.substring(1, text2.length() - 1)).length() == 0) {
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.EMPTY_CHARACTER_LITERAL.on(expression2));
            if (characterWithDiagnostic == null) {
                CompileTimeConstantChecker.$$$reportNull$$$0(14);
            }
            return characterWithDiagnostic;
        }
        if (text2.charAt(0) != '\\') {
            if (text2.length() == 1) {
                CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(text2.charAt(0));
                if (characterWithDiagnostic == null) {
                    CompileTimeConstantChecker.$$$reportNull$$$0(15);
                }
                return characterWithDiagnostic;
            }
            CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.TOO_MANY_CHARACTERS_IN_CHARACTER_LITERAL.on(expression2, expression2));
            if (characterWithDiagnostic == null) {
                CompileTimeConstantChecker.$$$reportNull$$$0(16);
            }
            return characterWithDiagnostic;
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.escapedStringToCharacter(text2, expression2);
        if (characterWithDiagnostic == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(17);
        }
        return characterWithDiagnostic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static CharacterWithDiagnostic escapedStringToCharacter(@NotNull String text2, @NotNull KtElement expression2) {
        if (text2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(18);
        }
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(19);
        }
        assert (text2.length() > 0 && text2.charAt(0) == '\\') : "Only escaped sequences must be passed to this routine: " + text2;
        String escape = text2.substring(1);
        switch (escape.length()) {
            case 0: {
                CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression2);
                if (characterWithDiagnostic != null) return characterWithDiagnostic;
                CompileTimeConstantChecker.$$$reportNull$$$0(20);
                return characterWithDiagnostic;
            }
            case 1: {
                Character escaped = CompileTimeConstantChecker.translateEscape(escape.charAt(0));
                if (escaped == null) {
                    CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression2);
                    if (characterWithDiagnostic != null) return characterWithDiagnostic;
                    CompileTimeConstantChecker.$$$reportNull$$$0(21);
                    return characterWithDiagnostic;
                }
                CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(escaped.charValue());
                if (characterWithDiagnostic != null) return characterWithDiagnostic;
                CompileTimeConstantChecker.$$$reportNull$$$0(22);
                return characterWithDiagnostic;
            }
            case 5: {
                CharacterWithDiagnostic characterWithDiagnostic;
                if (escape.charAt(0) != 'u') break;
                try {
                    Integer intValue = Integer.valueOf(escape.substring(1), 16);
                    characterWithDiagnostic = new CharacterWithDiagnostic((char)intValue.intValue());
                    if (characterWithDiagnostic != null) return characterWithDiagnostic;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                CompileTimeConstantChecker.$$$reportNull$$$0(23);
                return characterWithDiagnostic;
            }
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.illegalEscape(expression2);
        if (characterWithDiagnostic != null) return characterWithDiagnostic;
        CompileTimeConstantChecker.$$$reportNull$$$0(24);
        return characterWithDiagnostic;
    }

    @NotNull
    private static CharacterWithDiagnostic illegalEscape(@NotNull KtElement expression2) {
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(25);
        }
        CharacterWithDiagnostic characterWithDiagnostic = CompileTimeConstantChecker.createErrorCharacter(Errors.ILLEGAL_ESCAPE.on(expression2, expression2));
        if (characterWithDiagnostic == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(26);
        }
        return characterWithDiagnostic;
    }

    @NotNull
    private static CharacterWithDiagnostic createErrorCharacter(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(27);
        }
        CharacterWithDiagnostic characterWithDiagnostic = new CharacterWithDiagnostic(diagnostic);
        if (characterWithDiagnostic == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(28);
        }
        return characterWithDiagnostic;
    }

    @Nullable
    public static Character parseChar(@NotNull KtConstantExpression expression2) {
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(29);
        }
        return CompileTimeConstantChecker.parseCharacter(expression2).getValue();
    }

    @Nullable
    private static Character translateEscape(char c) {
        switch (c) {
            case 't': {
                return Character.valueOf('\t');
            }
            case 'b': {
                return Character.valueOf('\b');
            }
            case 'n': {
                return Character.valueOf('\n');
            }
            case 'r': {
                return Character.valueOf('\r');
            }
            case '\'': {
                return Character.valueOf('\'');
            }
            case '\"': {
                return Character.valueOf('\"');
            }
            case '\\': {
                return Character.valueOf('\\');
            }
            case '$': {
                return Character.valueOf('$');
            }
        }
        return null;
    }

    private static boolean noExpectedTypeOrError(KotlinType expectedType2) {
        return TypeUtils.noExpectedType(expectedType2) || KotlinTypeKt.isError(expectedType2);
    }

    private boolean reportConstantExpectedTypeMismatch(@NotNull KtConstantExpression expression2, @NotNull String typeName, @NotNull KotlinType expectedType2, @Nullable KotlinType expressionType) {
        if (expression2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(30);
        }
        if (typeName == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(31);
        }
        if (expectedType2 == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(32);
        }
        if (DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(this.context, expression2, expectedType2, expressionType)) {
            return true;
        }
        this.trace.report(Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.on(expression2, typeName, expectedType2));
        return true;
    }

    private boolean reportError(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            CompileTimeConstantChecker.$$$reportNull$$$0(33);
        }
        if (!this.checkOnlyErrorsThatDependOnExpectedType || errorsThatDependOnExpectedType.contains(diagnostic.getFactory())) {
            this.trace.report(diagnostic);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCharacter";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "escapedStringToCharacter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "illegalEscape";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorCharacter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConstantExpressionType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkIntegerValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFloatValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkBooleanValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkNullValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseCharacter";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "escapedStringToCharacter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "illegalEscape";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createErrorCharacter";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseChar";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "reportConstantExpectedTypeMismatch";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CharacterWithDiagnostic {
        private Diagnostic diagnostic;
        private Character value;

        public CharacterWithDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                CharacterWithDiagnostic.$$$reportNull$$$0(0);
            }
            this.diagnostic = diagnostic;
        }

        public CharacterWithDiagnostic(char value) {
            this.value = Character.valueOf(value);
        }

        @Nullable
        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Nullable
        public Character getValue() {
            return this.value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/resolve/constants/CompileTimeConstantChecker$CharacterWithDiagnostic", "<init>"));
        }
    }
}

