/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.ws.references.WSReference;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.utils.JavaElementVisitor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWebServicesReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AbstractWebServicesReferenceInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void checkElement(PsiElement element) {
                AbstractWebServicesReferenceInspection.this.checkElement(element, holder);
            }
        };
        if (javaElementVisitor == null) {
            AbstractWebServicesReferenceInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    @NotNull
    protected abstract Map<ElementPattern<? extends PsiElement>, WSReferenceProvider> getProviders();

    protected void checkElement(PsiElement element, ProblemsHolder holder) {
        for (ElementPattern<? extends PsiElement> pattern : this.getProviders().keySet()) {
            if (!pattern.accepts((Object)element)) continue;
            for (PsiReference reference : element.getReferences()) {
                if (reference.resolve() != null) continue;
                if (reference instanceof WSReference) {
                    WSReference ref = (WSReference)reference;
                    String message = ref.getUnresolvedMessagePattern();
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, reference.getRangeInElement(), message, ref.getProblemType(), holder.isOnTheFly(), ref.getQuickFixes()));
                    continue;
                }
                if (!(reference instanceof JavaClassReference)) continue;
                holder.registerProblem(element, "Unresolved symbol", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/inspections/AbstractWebServicesReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/inspections/AbstractWebServicesReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

