/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.beans.wrappers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowFlowWrapper
extends WebflowElementWrapper<XmlFile> {
    private static final String PATH = "flowPath";
    @Nullable
    private final WebflowModel myModel;
    @NotNull
    private final XmlFile myElement;

    public WebflowFlowWrapper(@NotNull XmlFile file) {
        if (file == null) {
            WebflowFlowWrapper.$$$reportNull$$$0(0);
        }
        this.myElement = file;
        this.myModel = WebflowDomModelManager.getInstance(this.myElement.getProject()).getWebflowModel(this.myElement);
    }

    @Override
    @NotNull
    public XmlFile getElement() {
        XmlFile xmlFile = this.myElement;
        if (xmlFile == null) {
            WebflowFlowWrapper.$$$reportNull$$$0(1);
        }
        return xmlFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myElement.getName();
        if (string == null) {
            WebflowFlowWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getFqn() {
        VirtualFile virtualFile = this.myElement.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return "flowPath=" + virtualFile.getPath();
    }

    @Override
    @NotNull
    public List<WebflowModel> getFlowModels() {
        if (!this.myElement.isValid()) {
            List<WebflowModel> list = Collections.emptyList();
            if (list == null) {
                WebflowFlowWrapper.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.myModel);
        if (list == null) {
            WebflowFlowWrapper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static WebflowElementWrapper resolveElementByFQN(String fqn, Project project) {
        String path = WebflowFlowWrapper.split(fqn).get(PATH);
        XmlFile file = WebflowFlowWrapper.findFile(project, path);
        if (file == null) {
            return null;
        }
        return new WebflowFlowWrapper(file);
    }

    @Nullable
    private static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        PsiFile psiFile;
        VirtualFile relativeFile;
        if (project == null) {
            WebflowFlowWrapper.$$$reportNull$$$0(5);
        }
        if (!StringUtil.isEmptyOrSpaces((String)path) && (relativeFile = VfsUtil.findRelativeFile((String)path, null)) != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/diagram/beans/wrappers/WebflowFlowWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

